/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.device.dto;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.manager.device.api.internal.dto.vigi.VigiDeviceTypeEnum;
import com.tplink.smb.omada.manager.device.api.web.device.a.c;
import com.tplink.smb.omada.manager.device.api.web.device.dto.HealthStatVO;
import java.util.Objects;
import lombok.Generated;

public abstract class BaseDeviceStatVO {
    private HealthStatVO switchHealth;
    private HealthStatVO eapHealth;
    private HealthStatVO oltHealth;
    private Integer allDevices;
    private Integer allSwitchsAndGateway;
    private Integer allAps;
    private Integer allOlts;
    private Integer allIPCs;
    private Integer allNVRs;
    private Integer mesh;
    private Integer config;
    private Integer performance;
    private Integer unActivated;
    private Integer activated;
    private Integer expired;
    private Integer good;
    private Integer fair;
    private Integer poor;
    private Integer noData;
    private Integer ecspV1Num;

    public abstract void addDeviceScoreStat(DeviceTypeEnum var1, Integer var2);

    public abstract void removeUselessHealthStat();

    public void addHealthStat(c healthStatus) {
        switch (healthStatus) {
            case a: {
                Integer n2 = this.noData;
                this.noData = this.noData + 1;
                break;
            }
            case b: {
                Integer n3 = this.poor;
                this.poor = this.poor + 1;
                break;
            }
            case c: {
                Integer n4 = this.fair;
                this.fair = this.fair + 1;
                break;
            }
            case d: {
                Integer n5 = this.good;
                this.good = this.good + 1;
                break;
            }
        }
    }

    public void addDeviceNum(DeviceTypeEnum deviceTypeEnum) {
        if (Objects.isNull(deviceTypeEnum)) {
            return;
        }
        switch (deviceTypeEnum) {
            case a: {
                this.allAps = this.allAps + 1;
                break;
            }
            case c: 
            case b: {
                this.allSwitchsAndGateway = this.allSwitchsAndGateway + 1;
                break;
            }
            case d: {
                this.allOlts = this.allOlts + 1;
            }
        }
        this.allDevices = this.allDevices + 1;
    }

    public void addVigiDeviceNum(VigiDeviceTypeEnum vigiDeviceTypeEnum) {
        if (Objects.isNull((Object)vigiDeviceTypeEnum)) {
            return;
        }
        switch (vigiDeviceTypeEnum) {
            case a: {
                this.allIPCs = this.allIPCs + 1;
                break;
            }
            case b: {
                this.allNVRs = this.allNVRs + 1;
                break;
            }
        }
        this.allDevices = this.allDevices + 1;
    }

    public void addMesh(Boolean supportMesh) {
        if (Boolean.TRUE.equals(supportMesh)) {
            this.mesh = this.mesh + 1;
        }
    }

    public void addConfig() {
        this.config = this.config + 1;
    }

    public void addPerformance() {
        this.performance = this.performance + 1;
    }

    public void addActivate() {
        this.activated = this.activated + 1;
    }

    public void addUnActivate() {
        this.unActivated = this.unActivated + 1;
    }

    public void addExpired() {
        this.expired = this.expired + 1;
    }

    public void addEcspDeviceNum(Integer ecspFirstVersion) {
        if (Objects.isNull(ecspFirstVersion)) {
            return;
        }
        switch (EcspFirstVersionEnum.resolve((int)ecspFirstVersion)) {
            case V1: {
                Integer n2 = this.ecspV1Num;
                this.ecspV1Num = this.ecspV1Num + 1;
                break;
            }
        }
    }

    @Generated
    protected BaseDeviceStatVO(BaseDeviceStatVOBuilder<?, ?> b2) {
        this.switchHealth = b2.switchHealth;
        this.eapHealth = b2.eapHealth;
        this.oltHealth = b2.oltHealth;
        this.allDevices = b2.allDevices;
        this.allSwitchsAndGateway = b2.allSwitchsAndGateway;
        this.allAps = b2.allAps;
        this.allOlts = b2.allOlts;
        this.allIPCs = b2.allIPCs;
        this.allNVRs = b2.allNVRs;
        this.mesh = b2.mesh;
        this.config = b2.config;
        this.performance = b2.performance;
        this.unActivated = b2.unActivated;
        this.activated = b2.activated;
        this.expired = b2.expired;
        this.good = b2.good;
        this.fair = b2.fair;
        this.poor = b2.poor;
        this.noData = b2.noData;
        this.ecspV1Num = b2.ecspV1Num;
    }

    @Generated
    public HealthStatVO getSwitchHealth() {
        return this.switchHealth;
    }

    @Generated
    public HealthStatVO getEapHealth() {
        return this.eapHealth;
    }

    @Generated
    public HealthStatVO getOltHealth() {
        return this.oltHealth;
    }

    @Generated
    public Integer getAllDevices() {
        return this.allDevices;
    }

    @Generated
    public Integer getAllSwitchsAndGateway() {
        return this.allSwitchsAndGateway;
    }

    @Generated
    public Integer getAllAps() {
        return this.allAps;
    }

    @Generated
    public Integer getAllOlts() {
        return this.allOlts;
    }

    @Generated
    public Integer getAllIPCs() {
        return this.allIPCs;
    }

    @Generated
    public Integer getAllNVRs() {
        return this.allNVRs;
    }

    @Generated
    public Integer getMesh() {
        return this.mesh;
    }

    @Generated
    public Integer getConfig() {
        return this.config;
    }

    @Generated
    public Integer getPerformance() {
        return this.performance;
    }

    @Generated
    public Integer getUnActivated() {
        return this.unActivated;
    }

    @Generated
    public Integer getActivated() {
        return this.activated;
    }

    @Generated
    public Integer getExpired() {
        return this.expired;
    }

    @Generated
    public Integer getGood() {
        return this.good;
    }

    @Generated
    public Integer getFair() {
        return this.fair;
    }

    @Generated
    public Integer getPoor() {
        return this.poor;
    }

    @Generated
    public Integer getNoData() {
        return this.noData;
    }

    @Generated
    public Integer getEcspV1Num() {
        return this.ecspV1Num;
    }

    @Generated
    public void setSwitchHealth(HealthStatVO switchHealth) {
        this.switchHealth = switchHealth;
    }

    @Generated
    public void setEapHealth(HealthStatVO eapHealth) {
        this.eapHealth = eapHealth;
    }

    @Generated
    public void setOltHealth(HealthStatVO oltHealth) {
        this.oltHealth = oltHealth;
    }

    @Generated
    public void setAllDevices(Integer allDevices) {
        this.allDevices = allDevices;
    }

    @Generated
    public void setAllSwitchsAndGateway(Integer allSwitchsAndGateway) {
        this.allSwitchsAndGateway = allSwitchsAndGateway;
    }

    @Generated
    public void setAllAps(Integer allAps) {
        this.allAps = allAps;
    }

    @Generated
    public void setAllOlts(Integer allOlts) {
        this.allOlts = allOlts;
    }

    @Generated
    public void setAllIPCs(Integer allIPCs) {
        this.allIPCs = allIPCs;
    }

    @Generated
    public void setAllNVRs(Integer allNVRs) {
        this.allNVRs = allNVRs;
    }

    @Generated
    public void setMesh(Integer mesh) {
        this.mesh = mesh;
    }

    @Generated
    public void setConfig(Integer config) {
        this.config = config;
    }

    @Generated
    public void setPerformance(Integer performance) {
        this.performance = performance;
    }

    @Generated
    public void setUnActivated(Integer unActivated) {
        this.unActivated = unActivated;
    }

    @Generated
    public void setActivated(Integer activated) {
        this.activated = activated;
    }

    @Generated
    public void setExpired(Integer expired) {
        this.expired = expired;
    }

    @Generated
    public void setGood(Integer good) {
        this.good = good;
    }

    @Generated
    public void setFair(Integer fair) {
        this.fair = fair;
    }

    @Generated
    public void setPoor(Integer poor) {
        this.poor = poor;
    }

    @Generated
    public void setNoData(Integer noData) {
        this.noData = noData;
    }

    @Generated
    public void setEcspV1Num(Integer ecspV1Num) {
        this.ecspV1Num = ecspV1Num;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BaseDeviceStatVO)) {
            return false;
        }
        BaseDeviceStatVO other = (BaseDeviceStatVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$allDevices = this.getAllDevices();
        Integer other$allDevices = other.getAllDevices();
        if (this$allDevices == null ? other$allDevices != null : !((Object)this$allDevices).equals(other$allDevices)) {
            return false;
        }
        Integer this$allSwitchsAndGateway = this.getAllSwitchsAndGateway();
        Integer other$allSwitchsAndGateway = other.getAllSwitchsAndGateway();
        if (this$allSwitchsAndGateway == null ? other$allSwitchsAndGateway != null : !((Object)this$allSwitchsAndGateway).equals(other$allSwitchsAndGateway)) {
            return false;
        }
        Integer this$allAps = this.getAllAps();
        Integer other$allAps = other.getAllAps();
        if (this$allAps == null ? other$allAps != null : !((Object)this$allAps).equals(other$allAps)) {
            return false;
        }
        Integer this$allOlts = this.getAllOlts();
        Integer other$allOlts = other.getAllOlts();
        if (this$allOlts == null ? other$allOlts != null : !((Object)this$allOlts).equals(other$allOlts)) {
            return false;
        }
        Integer this$allIPCs = this.getAllIPCs();
        Integer other$allIPCs = other.getAllIPCs();
        if (this$allIPCs == null ? other$allIPCs != null : !((Object)this$allIPCs).equals(other$allIPCs)) {
            return false;
        }
        Integer this$allNVRs = this.getAllNVRs();
        Integer other$allNVRs = other.getAllNVRs();
        if (this$allNVRs == null ? other$allNVRs != null : !((Object)this$allNVRs).equals(other$allNVRs)) {
            return false;
        }
        Integer this$mesh = this.getMesh();
        Integer other$mesh = other.getMesh();
        if (this$mesh == null ? other$mesh != null : !((Object)this$mesh).equals(other$mesh)) {
            return false;
        }
        Integer this$config = this.getConfig();
        Integer other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Integer this$performance = this.getPerformance();
        Integer other$performance = other.getPerformance();
        if (this$performance == null ? other$performance != null : !((Object)this$performance).equals(other$performance)) {
            return false;
        }
        Integer this$unActivated = this.getUnActivated();
        Integer other$unActivated = other.getUnActivated();
        if (this$unActivated == null ? other$unActivated != null : !((Object)this$unActivated).equals(other$unActivated)) {
            return false;
        }
        Integer this$activated = this.getActivated();
        Integer other$activated = other.getActivated();
        if (this$activated == null ? other$activated != null : !((Object)this$activated).equals(other$activated)) {
            return false;
        }
        Integer this$expired = this.getExpired();
        Integer other$expired = other.getExpired();
        if (this$expired == null ? other$expired != null : !((Object)this$expired).equals(other$expired)) {
            return false;
        }
        Integer this$good = this.getGood();
        Integer other$good = other.getGood();
        if (this$good == null ? other$good != null : !((Object)this$good).equals(other$good)) {
            return false;
        }
        Integer this$fair = this.getFair();
        Integer other$fair = other.getFair();
        if (this$fair == null ? other$fair != null : !((Object)this$fair).equals(other$fair)) {
            return false;
        }
        Integer this$poor = this.getPoor();
        Integer other$poor = other.getPoor();
        if (this$poor == null ? other$poor != null : !((Object)this$poor).equals(other$poor)) {
            return false;
        }
        Integer this$noData = this.getNoData();
        Integer other$noData = other.getNoData();
        if (this$noData == null ? other$noData != null : !((Object)this$noData).equals(other$noData)) {
            return false;
        }
        Integer this$ecspV1Num = this.getEcspV1Num();
        Integer other$ecspV1Num = other.getEcspV1Num();
        if (this$ecspV1Num == null ? other$ecspV1Num != null : !((Object)this$ecspV1Num).equals(other$ecspV1Num)) {
            return false;
        }
        HealthStatVO this$switchHealth = this.getSwitchHealth();
        HealthStatVO other$switchHealth = other.getSwitchHealth();
        if (this$switchHealth == null ? other$switchHealth != null : !((Object)this$switchHealth).equals(other$switchHealth)) {
            return false;
        }
        HealthStatVO this$eapHealth = this.getEapHealth();
        HealthStatVO other$eapHealth = other.getEapHealth();
        if (this$eapHealth == null ? other$eapHealth != null : !((Object)this$eapHealth).equals(other$eapHealth)) {
            return false;
        }
        HealthStatVO this$oltHealth = this.getOltHealth();
        HealthStatVO other$oltHealth = other.getOltHealth();
        return !(this$oltHealth == null ? other$oltHealth != null : !((Object)this$oltHealth).equals(other$oltHealth));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseDeviceStatVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $allDevices = this.getAllDevices();
        result = result * 59 + ($allDevices == null ? 43 : ((Object)$allDevices).hashCode());
        Integer $allSwitchsAndGateway = this.getAllSwitchsAndGateway();
        result = result * 59 + ($allSwitchsAndGateway == null ? 43 : ((Object)$allSwitchsAndGateway).hashCode());
        Integer $allAps = this.getAllAps();
        result = result * 59 + ($allAps == null ? 43 : ((Object)$allAps).hashCode());
        Integer $allOlts = this.getAllOlts();
        result = result * 59 + ($allOlts == null ? 43 : ((Object)$allOlts).hashCode());
        Integer $allIPCs = this.getAllIPCs();
        result = result * 59 + ($allIPCs == null ? 43 : ((Object)$allIPCs).hashCode());
        Integer $allNVRs = this.getAllNVRs();
        result = result * 59 + ($allNVRs == null ? 43 : ((Object)$allNVRs).hashCode());
        Integer $mesh = this.getMesh();
        result = result * 59 + ($mesh == null ? 43 : ((Object)$mesh).hashCode());
        Integer $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Integer $performance = this.getPerformance();
        result = result * 59 + ($performance == null ? 43 : ((Object)$performance).hashCode());
        Integer $unActivated = this.getUnActivated();
        result = result * 59 + ($unActivated == null ? 43 : ((Object)$unActivated).hashCode());
        Integer $activated = this.getActivated();
        result = result * 59 + ($activated == null ? 43 : ((Object)$activated).hashCode());
        Integer $expired = this.getExpired();
        result = result * 59 + ($expired == null ? 43 : ((Object)$expired).hashCode());
        Integer $good = this.getGood();
        result = result * 59 + ($good == null ? 43 : ((Object)$good).hashCode());
        Integer $fair = this.getFair();
        result = result * 59 + ($fair == null ? 43 : ((Object)$fair).hashCode());
        Integer $poor = this.getPoor();
        result = result * 59 + ($poor == null ? 43 : ((Object)$poor).hashCode());
        Integer $noData = this.getNoData();
        result = result * 59 + ($noData == null ? 43 : ((Object)$noData).hashCode());
        Integer $ecspV1Num = this.getEcspV1Num();
        result = result * 59 + ($ecspV1Num == null ? 43 : ((Object)$ecspV1Num).hashCode());
        HealthStatVO $switchHealth = this.getSwitchHealth();
        result = result * 59 + ($switchHealth == null ? 43 : ((Object)$switchHealth).hashCode());
        HealthStatVO $eapHealth = this.getEapHealth();
        result = result * 59 + ($eapHealth == null ? 43 : ((Object)$eapHealth).hashCode());
        HealthStatVO $oltHealth = this.getOltHealth();
        result = result * 59 + ($oltHealth == null ? 43 : ((Object)$oltHealth).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseDeviceStatVO(switchHealth=" + this.getSwitchHealth() + ", eapHealth=" + this.getEapHealth() + ", oltHealth=" + this.getOltHealth() + ", allDevices=" + this.getAllDevices() + ", allSwitchsAndGateway=" + this.getAllSwitchsAndGateway() + ", allAps=" + this.getAllAps() + ", allOlts=" + this.getAllOlts() + ", allIPCs=" + this.getAllIPCs() + ", allNVRs=" + this.getAllNVRs() + ", mesh=" + this.getMesh() + ", config=" + this.getConfig() + ", performance=" + this.getPerformance() + ", unActivated=" + this.getUnActivated() + ", activated=" + this.getActivated() + ", expired=" + this.getExpired() + ", good=" + this.getGood() + ", fair=" + this.getFair() + ", poor=" + this.getPoor() + ", noData=" + this.getNoData() + ", ecspV1Num=" + this.getEcspV1Num() + ")";
    }

    @Generated
    public BaseDeviceStatVO() {
    }

    @Generated
    public BaseDeviceStatVO(HealthStatVO switchHealth, HealthStatVO eapHealth, HealthStatVO oltHealth, Integer allDevices, Integer allSwitchsAndGateway, Integer allAps, Integer allOlts, Integer allIPCs, Integer allNVRs, Integer mesh, Integer config, Integer performance, Integer unActivated, Integer activated, Integer expired, Integer good, Integer fair, Integer poor, Integer noData, Integer ecspV1Num) {
        this.switchHealth = switchHealth;
        this.eapHealth = eapHealth;
        this.oltHealth = oltHealth;
        this.allDevices = allDevices;
        this.allSwitchsAndGateway = allSwitchsAndGateway;
        this.allAps = allAps;
        this.allOlts = allOlts;
        this.allIPCs = allIPCs;
        this.allNVRs = allNVRs;
        this.mesh = mesh;
        this.config = config;
        this.performance = performance;
        this.unActivated = unActivated;
        this.activated = activated;
        this.expired = expired;
        this.good = good;
        this.fair = fair;
        this.poor = poor;
        this.noData = noData;
        this.ecspV1Num = ecspV1Num;
    }

    @Generated
    public static abstract class BaseDeviceStatVOBuilder<C extends BaseDeviceStatVO, B extends BaseDeviceStatVOBuilder<C, B>> {
        @Generated
        private HealthStatVO switchHealth;
        @Generated
        private HealthStatVO eapHealth;
        @Generated
        private HealthStatVO oltHealth;
        @Generated
        private Integer allDevices;
        @Generated
        private Integer allSwitchsAndGateway;
        @Generated
        private Integer allAps;
        @Generated
        private Integer allOlts;
        @Generated
        private Integer allIPCs;
        @Generated
        private Integer allNVRs;
        @Generated
        private Integer mesh;
        @Generated
        private Integer config;
        @Generated
        private Integer performance;
        @Generated
        private Integer unActivated;
        @Generated
        private Integer activated;
        @Generated
        private Integer expired;
        @Generated
        private Integer good;
        @Generated
        private Integer fair;
        @Generated
        private Integer poor;
        @Generated
        private Integer noData;
        @Generated
        private Integer ecspV1Num;

        @Generated
        public B switchHealth(HealthStatVO switchHealth) {
            this.switchHealth = switchHealth;
            return this.self();
        }

        @Generated
        public B eapHealth(HealthStatVO eapHealth) {
            this.eapHealth = eapHealth;
            return this.self();
        }

        @Generated
        public B oltHealth(HealthStatVO oltHealth) {
            this.oltHealth = oltHealth;
            return this.self();
        }

        @Generated
        public B allDevices(Integer allDevices) {
            this.allDevices = allDevices;
            return this.self();
        }

        @Generated
        public B allSwitchsAndGateway(Integer allSwitchsAndGateway) {
            this.allSwitchsAndGateway = allSwitchsAndGateway;
            return this.self();
        }

        @Generated
        public B allAps(Integer allAps) {
            this.allAps = allAps;
            return this.self();
        }

        @Generated
        public B allOlts(Integer allOlts) {
            this.allOlts = allOlts;
            return this.self();
        }

        @Generated
        public B allIPCs(Integer allIPCs) {
            this.allIPCs = allIPCs;
            return this.self();
        }

        @Generated
        public B allNVRs(Integer allNVRs) {
            this.allNVRs = allNVRs;
            return this.self();
        }

        @Generated
        public B mesh(Integer mesh) {
            this.mesh = mesh;
            return this.self();
        }

        @Generated
        public B config(Integer config) {
            this.config = config;
            return this.self();
        }

        @Generated
        public B performance(Integer performance) {
            this.performance = performance;
            return this.self();
        }

        @Generated
        public B unActivated(Integer unActivated) {
            this.unActivated = unActivated;
            return this.self();
        }

        @Generated
        public B activated(Integer activated) {
            this.activated = activated;
            return this.self();
        }

        @Generated
        public B expired(Integer expired) {
            this.expired = expired;
            return this.self();
        }

        @Generated
        public B good(Integer good) {
            this.good = good;
            return this.self();
        }

        @Generated
        public B fair(Integer fair) {
            this.fair = fair;
            return this.self();
        }

        @Generated
        public B poor(Integer poor) {
            this.poor = poor;
            return this.self();
        }

        @Generated
        public B noData(Integer noData) {
            this.noData = noData;
            return this.self();
        }

        @Generated
        public B ecspV1Num(Integer ecspV1Num) {
            this.ecspV1Num = ecspV1Num;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseDeviceStatVO.BaseDeviceStatVOBuilder(switchHealth=" + this.switchHealth + ", eapHealth=" + this.eapHealth + ", oltHealth=" + this.oltHealth + ", allDevices=" + this.allDevices + ", allSwitchsAndGateway=" + this.allSwitchsAndGateway + ", allAps=" + this.allAps + ", allOlts=" + this.allOlts + ", allIPCs=" + this.allIPCs + ", allNVRs=" + this.allNVRs + ", mesh=" + this.mesh + ", config=" + this.config + ", performance=" + this.performance + ", unActivated=" + this.unActivated + ", activated=" + this.activated + ", expired=" + this.expired + ", good=" + this.good + ", fair=" + this.fair + ", poor=" + this.poor + ", noData=" + this.noData + ", ecspV1Num=" + this.ecspV1Num + ")";
        }
    }
}

