/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.ap.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.util.T;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ApVoipVlanSettingVO {
    private static final Integer VOIP_VLAN_MODE_FOLLOW_MVLAN = 0;
    private static final Integer VOIP_VLAN_MODE_FOLLOW_CUSTOM = 1;
    private static final Integer VOIP_VLAN_IP_TYPE_STATIC = 0;
    private static final Integer VOIP_VLAN_IP_TYPE_DHCP = 1;
    @Range(min=0L, max=1L)
    private @Range(min=0L, max=1L) Integer mode;
    private String lanNetworkId;
    private Integer voipBridgeVlan;
    @Range(min=0L, max=1L)
    private @Range(min=0L, max=1L) Integer ipType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip address.") String ip;
    @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid ipMask.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid ipMask.") String ipMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipGateway.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipGateway.") String ipGateway;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns1.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns1.") String ipDns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns2.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns2.") String ipDns2;

    public boolean validate() {
        if (Objects.equals(this.getMode(), VOIP_VLAN_MODE_FOLLOW_CUSTOM)) {
            if (this.getIpType() == null) {
                return false;
            }
            if (Objects.equals(this.getIpType(), VOIP_VLAN_IP_TYPE_STATIC) && (T.a((String)this.getIp()) || T.a((String)this.getIpMask()) || T.a((String)this.getIpGateway()))) {
                return false;
            }
        }
        return true;
    }

    @Generated
    public static ApVoipVlanSettingVOBuilder builder() {
        return new ApVoipVlanSettingVOBuilder();
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getLanNetworkId() {
        return this.lanNetworkId;
    }

    @Generated
    public Integer getVoipBridgeVlan() {
        return this.voipBridgeVlan;
    }

    @Generated
    public Integer getIpType() {
        return this.ipType;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getIpMask() {
        return this.ipMask;
    }

    @Generated
    public String getIpGateway() {
        return this.ipGateway;
    }

    @Generated
    public String getIpDns1() {
        return this.ipDns1;
    }

    @Generated
    public String getIpDns2() {
        return this.ipDns2;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setLanNetworkId(String lanNetworkId) {
        this.lanNetworkId = lanNetworkId;
    }

    @Generated
    public void setVoipBridgeVlan(Integer voipBridgeVlan) {
        this.voipBridgeVlan = voipBridgeVlan;
    }

    @Generated
    public void setIpType(Integer ipType) {
        this.ipType = ipType;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setIpMask(String ipMask) {
        this.ipMask = ipMask;
    }

    @Generated
    public void setIpGateway(String ipGateway) {
        this.ipGateway = ipGateway;
    }

    @Generated
    public void setIpDns1(String ipDns1) {
        this.ipDns1 = ipDns1;
    }

    @Generated
    public void setIpDns2(String ipDns2) {
        this.ipDns2 = ipDns2;
    }

    @Generated
    public String toString() {
        return "ApVoipVlanSettingVO(mode=" + this.getMode() + ", lanNetworkId=" + this.getLanNetworkId() + ", voipBridgeVlan=" + this.getVoipBridgeVlan() + ", ipType=" + this.getIpType() + ", ip=" + this.getIp() + ", ipMask=" + this.getIpMask() + ", ipGateway=" + this.getIpGateway() + ", ipDns1=" + this.getIpDns1() + ", ipDns2=" + this.getIpDns2() + ")";
    }

    @Generated
    public ApVoipVlanSettingVO() {
    }

    @Generated
    public ApVoipVlanSettingVO(Integer mode, String lanNetworkId, Integer voipBridgeVlan, Integer ipType, String ip, String ipMask, String ipGateway, String ipDns1, String ipDns2) {
        this.mode = mode;
        this.lanNetworkId = lanNetworkId;
        this.voipBridgeVlan = voipBridgeVlan;
        this.ipType = ipType;
        this.ip = ip;
        this.ipMask = ipMask;
        this.ipGateway = ipGateway;
        this.ipDns1 = ipDns1;
        this.ipDns2 = ipDns2;
    }

    @Generated
    public static class ApVoipVlanSettingVOBuilder {
        @Generated
        private Integer mode;
        @Generated
        private String lanNetworkId;
        @Generated
        private Integer voipBridgeVlan;
        @Generated
        private Integer ipType;
        @Generated
        private String ip;
        @Generated
        private String ipMask;
        @Generated
        private String ipGateway;
        @Generated
        private String ipDns1;
        @Generated
        private String ipDns2;

        @Generated
        ApVoipVlanSettingVOBuilder() {
        }

        @Generated
        public ApVoipVlanSettingVOBuilder mode(Integer mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder lanNetworkId(String lanNetworkId) {
            this.lanNetworkId = lanNetworkId;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder voipBridgeVlan(Integer voipBridgeVlan) {
            this.voipBridgeVlan = voipBridgeVlan;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder ipType(Integer ipType) {
            this.ipType = ipType;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder ipMask(String ipMask) {
            this.ipMask = ipMask;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder ipGateway(String ipGateway) {
            this.ipGateway = ipGateway;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder ipDns1(String ipDns1) {
            this.ipDns1 = ipDns1;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVOBuilder ipDns2(String ipDns2) {
            this.ipDns2 = ipDns2;
            return this;
        }

        @Generated
        public ApVoipVlanSettingVO build() {
            return new ApVoipVlanSettingVO(this.mode, this.lanNetworkId, this.voipBridgeVlan, this.ipType, this.ip, this.ipMask, this.ipGateway, this.ipDns1, this.ipDns2);
        }

        @Generated
        public String toString() {
            return "ApVoipVlanSettingVO.ApVoipVlanSettingVOBuilder(mode=" + this.mode + ", lanNetworkId=" + this.lanNetworkId + ", voipBridgeVlan=" + this.voipBridgeVlan + ", ipType=" + this.ipType + ", ip=" + this.ip + ", ipMask=" + this.ipMask + ", ipGateway=" + this.ipGateway + ", ipDns1=" + this.ipDns1 + ", ipDns2=" + this.ipDns2 + ")";
        }
    }
}

