/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.ap.dto;

import com.tplink.smb.omada.manager.device.api.app.ap.dto.ApRadioSettingAppVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(name="ApRadioSetting", description="Radio Setting")
public class ApRadioSettingVO {
    @Schema(name="radioEnable", description="Enable/Disable radio setting(if false, other params is not required)")
    private Boolean radioEnable;
    @Schema(name="channelRange", description="Custom optional channel freq collection.")
    private List<Integer> channelRange;
    @Schema(name="channelWidth", description="RADIO_20 = 2; RADIO_40 = 3; RADIO_40_20 = 4(corresponding 2G Auto); RADIO_80 = 5; RADIO_80_40_20 = 6(corresponding 5G Auto); RADIO_160= 7; RADIO_160_80_40_20 = 8; RADIO_240 = 9; RADIO_320 = 10")
    private String channelWidth;
    @Schema(name="channel", description="Channel Index; The channel index list supported by device can be obtained from interface : Get available channel list of ap; If select auto configuration need to enter 0.")
    private String channel;
    @Schema(name="txPower", description="TX Power")
    private Integer txPower;
    @Schema(name="txPowerLevel", description="It should be a value as follows: 0: Low; 1: Medium; 2: High; 3: Custom; 4: Auto")
    private Integer txPowerLevel;
    @Schema(name="channelLimitEnable", description="Enable channel limit(site level)")
    private Boolean channelLimitEnable;
    @Schema(name="freq", description="Frequency;The frequency list supported by device can be obtained from interface : Get available channel list of ap.The freq and channel fields should be corresponding, otherwise the channel will be corrected based on the freq field.")
    private Integer freq;
    @Schema(name="wirelessMode", description="Wireless mode config status of the device; -2 : Auto; 3 : 802.11b/g mixed(Only for 2.4G); 4 : 802.11b/g/n mixed(Only for 2.4G); 13 : 802.11b/g/n/ax mixed(Only for 2.4G); 17 : 802.11b/g/n/ax/be mixed(Only for 2.4G); 7 : 802.11a/n mixed(Only for 5G); 10 : 802.11a/n/ac mixed(Only for 5G); 16 : 802.11a/n/ac/ax mixed(Only for 5G); 18 : 802.11a/n/ac/ax/be mixed(Only for 5G); 11 : 802.11ax only(Only for 6G); 19 : 802.11ax/be mixed(Only for 6G).")
    private Integer wirelessMode;
    @Schema(name="autoSwitchOffWifi", description="Enable auto Switch Off Wifi")
    private Boolean autoSwitchOffWifi;
    @Schema(name="autoSwitchOffWifiInterval", description="Auto Switch Off Wifi Interval")
    private Integer autoSwitchOffWifiInterval;
    private Integer rrmType;
    private Long interTimeStamp;

    @Nullable
    public static ApRadioSettingVO buildFromAppVO(ApRadioSettingAppVO appVO) {
        if (appVO == null) {
            return null;
        }
        return ApRadioSettingVO.builder().radioEnable(appVO.getRadioEnable()).channelWidth(appVO.getChannelWidth()).channel(appVO.getChannel()).channelRange(Optional.ofNullable(appVO.getChannelRange()).map(ArrayList::new).orElse(null)).txPower(appVO.getTxPower()).txPowerLevel(appVO.getTxPowerLevel()).channelLimitEnable(appVO.getChannelLimitEnable()).freq(appVO.getFreq()).wirelessMode(appVO.getWirelessMode()).autoSwitchOffWifi(appVO.getAutoSwitchOffWifi()).autoSwitchOffWifiInterval(appVO.getAutoSwitchOnWifiInterval()).build();
    }

    @Generated
    public static ApRadioSettingVOBuilder builder() {
        return new ApRadioSettingVOBuilder();
    }

    @Generated
    public Boolean getRadioEnable() {
        return this.radioEnable;
    }

    @Generated
    public List<Integer> getChannelRange() {
        return this.channelRange;
    }

    @Generated
    public String getChannelWidth() {
        return this.channelWidth;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public Integer getTxPower() {
        return this.txPower;
    }

    @Generated
    public Integer getTxPowerLevel() {
        return this.txPowerLevel;
    }

    @Generated
    public Boolean getChannelLimitEnable() {
        return this.channelLimitEnable;
    }

    @Generated
    public Integer getFreq() {
        return this.freq;
    }

    @Generated
    public Integer getWirelessMode() {
        return this.wirelessMode;
    }

    @Generated
    public Boolean getAutoSwitchOffWifi() {
        return this.autoSwitchOffWifi;
    }

    @Generated
    public Integer getAutoSwitchOffWifiInterval() {
        return this.autoSwitchOffWifiInterval;
    }

    @Generated
    public Integer getRrmType() {
        return this.rrmType;
    }

    @Generated
    public Long getInterTimeStamp() {
        return this.interTimeStamp;
    }

    @Generated
    public void setRadioEnable(Boolean radioEnable) {
        this.radioEnable = radioEnable;
    }

    @Generated
    public void setChannelRange(List<Integer> channelRange) {
        this.channelRange = channelRange;
    }

    @Generated
    public void setChannelWidth(String channelWidth) {
        this.channelWidth = channelWidth;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public void setTxPower(Integer txPower) {
        this.txPower = txPower;
    }

    @Generated
    public void setTxPowerLevel(Integer txPowerLevel) {
        this.txPowerLevel = txPowerLevel;
    }

    @Generated
    public void setChannelLimitEnable(Boolean channelLimitEnable) {
        this.channelLimitEnable = channelLimitEnable;
    }

    @Generated
    public void setFreq(Integer freq) {
        this.freq = freq;
    }

    @Generated
    public void setWirelessMode(Integer wirelessMode) {
        this.wirelessMode = wirelessMode;
    }

    @Generated
    public void setAutoSwitchOffWifi(Boolean autoSwitchOffWifi) {
        this.autoSwitchOffWifi = autoSwitchOffWifi;
    }

    @Generated
    public void setAutoSwitchOffWifiInterval(Integer autoSwitchOffWifiInterval) {
        this.autoSwitchOffWifiInterval = autoSwitchOffWifiInterval;
    }

    @Generated
    public void setRrmType(Integer rrmType) {
        this.rrmType = rrmType;
    }

    @Generated
    public void setInterTimeStamp(Long interTimeStamp) {
        this.interTimeStamp = interTimeStamp;
    }

    @Generated
    public String toString() {
        return "ApRadioSettingVO(radioEnable=" + this.getRadioEnable() + ", channelRange=" + this.getChannelRange() + ", channelWidth=" + this.getChannelWidth() + ", channel=" + this.getChannel() + ", txPower=" + this.getTxPower() + ", txPowerLevel=" + this.getTxPowerLevel() + ", channelLimitEnable=" + this.getChannelLimitEnable() + ", freq=" + this.getFreq() + ", wirelessMode=" + this.getWirelessMode() + ", autoSwitchOffWifi=" + this.getAutoSwitchOffWifi() + ", autoSwitchOffWifiInterval=" + this.getAutoSwitchOffWifiInterval() + ", rrmType=" + this.getRrmType() + ", interTimeStamp=" + this.getInterTimeStamp() + ")";
    }

    @Generated
    public ApRadioSettingVO() {
    }

    @Generated
    public ApRadioSettingVO(Boolean radioEnable, List<Integer> channelRange, String channelWidth, String channel, Integer txPower, Integer txPowerLevel, Boolean channelLimitEnable, Integer freq, Integer wirelessMode, Boolean autoSwitchOffWifi, Integer autoSwitchOffWifiInterval, Integer rrmType, Long interTimeStamp) {
        this.radioEnable = radioEnable;
        this.channelRange = channelRange;
        this.channelWidth = channelWidth;
        this.channel = channel;
        this.txPower = txPower;
        this.txPowerLevel = txPowerLevel;
        this.channelLimitEnable = channelLimitEnable;
        this.freq = freq;
        this.wirelessMode = wirelessMode;
        this.autoSwitchOffWifi = autoSwitchOffWifi;
        this.autoSwitchOffWifiInterval = autoSwitchOffWifiInterval;
        this.rrmType = rrmType;
        this.interTimeStamp = interTimeStamp;
    }

    @Generated
    public static class ApRadioSettingVOBuilder {
        @Generated
        private Boolean radioEnable;
        @Generated
        private List<Integer> channelRange;
        @Generated
        private String channelWidth;
        @Generated
        private String channel;
        @Generated
        private Integer txPower;
        @Generated
        private Integer txPowerLevel;
        @Generated
        private Boolean channelLimitEnable;
        @Generated
        private Integer freq;
        @Generated
        private Integer wirelessMode;
        @Generated
        private Boolean autoSwitchOffWifi;
        @Generated
        private Integer autoSwitchOffWifiInterval;
        @Generated
        private Integer rrmType;
        @Generated
        private Long interTimeStamp;

        @Generated
        ApRadioSettingVOBuilder() {
        }

        @Generated
        public ApRadioSettingVOBuilder radioEnable(Boolean radioEnable) {
            this.radioEnable = radioEnable;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder channelRange(List<Integer> channelRange) {
            this.channelRange = channelRange;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder channelWidth(String channelWidth) {
            this.channelWidth = channelWidth;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder txPower(Integer txPower) {
            this.txPower = txPower;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder txPowerLevel(Integer txPowerLevel) {
            this.txPowerLevel = txPowerLevel;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder channelLimitEnable(Boolean channelLimitEnable) {
            this.channelLimitEnable = channelLimitEnable;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder freq(Integer freq) {
            this.freq = freq;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder wirelessMode(Integer wirelessMode) {
            this.wirelessMode = wirelessMode;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder autoSwitchOffWifi(Boolean autoSwitchOffWifi) {
            this.autoSwitchOffWifi = autoSwitchOffWifi;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder autoSwitchOffWifiInterval(Integer autoSwitchOffWifiInterval) {
            this.autoSwitchOffWifiInterval = autoSwitchOffWifiInterval;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder rrmType(Integer rrmType) {
            this.rrmType = rrmType;
            return this;
        }

        @Generated
        public ApRadioSettingVOBuilder interTimeStamp(Long interTimeStamp) {
            this.interTimeStamp = interTimeStamp;
            return this;
        }

        @Generated
        public ApRadioSettingVO build() {
            return new ApRadioSettingVO(this.radioEnable, this.channelRange, this.channelWidth, this.channel, this.txPower, this.txPowerLevel, this.channelLimitEnable, this.freq, this.wirelessMode, this.autoSwitchOffWifi, this.autoSwitchOffWifiInterval, this.rrmType, this.interTimeStamp);
        }

        @Generated
        public String toString() {
            return "ApRadioSettingVO.ApRadioSettingVOBuilder(radioEnable=" + this.radioEnable + ", channelRange=" + this.channelRange + ", channelWidth=" + this.channelWidth + ", channel=" + this.channel + ", txPower=" + this.txPower + ", txPowerLevel=" + this.txPowerLevel + ", channelLimitEnable=" + this.channelLimitEnable + ", freq=" + this.freq + ", wirelessMode=" + this.wirelessMode + ", autoSwitchOffWifi=" + this.autoSwitchOffWifi + ", autoSwitchOffWifiInterval=" + this.autoSwitchOffWifiInterval + ", rrmType=" + this.rrmType + ", interTimeStamp=" + this.interTimeStamp + ")";
        }
    }
}

