/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.internal.event.inform;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.eventcenter.api.event.AbstractDomainEvent;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.body.olt.OltInformBody;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.ap.ApInformDomainEventDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.olt.OltInformDomainEventDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osg.OsgInformDomainEventDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osw.OswInformDomainEventDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeviceInformDomainEventDTO<T>
extends AbstractDomainEvent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceInformDomainEventDTO.class);
    private String ecspVersion;
    private Integer seq;
    private String deviceType;
    private String omadacId;
    private String siteId;
    @a
    private String deviceMac;
    private String deviceName;
    private T informBody;
    private Long timestamp;
    private AddressDTO addressDTO;
    private com.tplink.smb.omada.device.gateway.a.d.b.a.a oswInfo;
    private Boolean supportAnomaly;
    @Deprecated
    private String message;
    private Boolean wirelessRouter;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public boolean validate() {
        if (T.a((String)this.omadacId) || T.a((String)this.siteId) || T.a((String)this.deviceType) || T.a((String)this.deviceMac) || T.a((String)this.deviceName)) {
            log.error("omadacId={},siteId={},deviceType={},deviceMac={}, name={},but some parameters is null", new Object[]{this.omadacId, this.siteId, this.deviceType, this.deviceMac, this.deviceName});
            return false;
        }
        return true;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean validateParam() {
        if (T.a((String)this.getOmadacId()) || T.a((String)this.getSiteId()) || T.a((String)this.getDeviceType()) || T.a((String)this.getDeviceMac()) || T.a((String)this.getDeviceName()) || Objects.isNull(this.getInformBody()) || Objects.isNull(this.getTimestamp())) {
            log.warn("Invalid device inform event due to parameters is illegal, invalid event :{}", (Object)this);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static DeviceInformDomainEventDTO<?> buildDomainEvent(com.tplink.smb.omada.device.gateway.a.d.b.a deviceInform) {
        DeviceInformDomainEventDTO<EapInformBody> deviceInformDomainEventDTO;
        try {
            switch (DeviceTypeEnum.b((String)deviceInform.d())) {
                case a: {
                    deviceInformDomainEventDTO = new ApInformDomainEventDTO().setInformBody((EapInformBody)x.a((Map)deviceInform.i(), EapInformBody.class));
                    break;
                }
                case c: {
                    deviceInformDomainEventDTO = new OswInformDomainEventDTO().setInformBody((OswInformBody)x.a((Map)deviceInform.i(), OswInformBody.class));
                    break;
                }
                case b: {
                    deviceInformDomainEventDTO = new OsgInformDomainEventDTO().setInformBody((OsgInformBody)x.a((Map)deviceInform.i(), OsgInformBody.class));
                    break;
                }
                case d: {
                    deviceInformDomainEventDTO = new OltInformDomainEventDTO().setInformBody((OltInformBody)x.a((Map)deviceInform.i(), OltInformBody.class));
                    break;
                }
                default: {
                    log.warn("build lite inform domain event error of mac: {} because of unknown device type", (Object)deviceInform.e());
                    return null;
                }
            }
        }
        catch (Exception e2) {
            log.warn("build lite inform domain event error of omadacId: {}, mac: {}", new Object[]{deviceInform.g(), deviceInform.e(), e2});
            return null;
        }
        com.tplink.smb.omada.device.gateway.a.d.b.a.a oswInfo = new com.tplink.smb.omada.device.gateway.a.d.b.a.a();
        if (Objects.nonNull(deviceInform.k())) {
            oswInfo.a(deviceInform.k().b());
            oswInfo.a(deviceInform.k().a());
        }
        deviceInformDomainEventDTO.setEcspVersion(deviceInform.b()).setSeq(deviceInform.c()).setDeviceType(deviceInform.d()).setDeviceMac(deviceInform.e()).setDeviceName(deviceInform.f()).setOmadacId(deviceInform.g()).setSiteId(deviceInform.h()).setTimestamp(deviceInform.j()).setAddressDTO(deviceInform.m()).setOswInfo(oswInfo).setSupportAnomaly(deviceInform.n()).setWirelessRouter(deviceInform.l());
        return deviceInformDomainEventDTO;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setEcspVersion(String ecspVersion) {
        this.ecspVersion = ecspVersion;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setSeq(Integer seq) {
        this.seq = seq;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setInformBody(T informBody) {
        this.informBody = informBody;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setAddressDTO(AddressDTO addressDTO) {
        this.addressDTO = addressDTO;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setOswInfo(com.tplink.smb.omada.device.gateway.a.d.b.a.a oswInfo) {
        this.oswInfo = oswInfo;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setSupportAnomaly(Boolean supportAnomaly) {
        this.supportAnomaly = supportAnomaly;
        return this;
    }

    @Deprecated
    @Generated
    public DeviceInformDomainEventDTO<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    @Generated
    public DeviceInformDomainEventDTO<T> setWirelessRouter(Boolean wirelessRouter) {
        this.wirelessRouter = wirelessRouter;
        return this;
    }

    @JsonIgnore
    @Generated
    public DeviceInformDomainEventDTO<T> setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Generated
    public String getEcspVersion() {
        return this.ecspVersion;
    }

    @Generated
    public Integer getSeq() {
        return this.seq;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public T getInformBody() {
        return this.informBody;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public AddressDTO getAddressDTO() {
        return this.addressDTO;
    }

    @Generated
    public com.tplink.smb.omada.device.gateway.a.d.b.a.a getOswInfo() {
        return this.oswInfo;
    }

    @Generated
    public Boolean getSupportAnomaly() {
        return this.supportAnomaly;
    }

    @Deprecated
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Boolean getWirelessRouter() {
        return this.wirelessRouter;
    }

    @Generated
    public String toString() {
        return "DeviceInformDomainEventDTO(ecspVersion=" + this.getEcspVersion() + ", seq=" + this.getSeq() + ", deviceType=" + this.getDeviceType() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", deviceMac=" + this.getDeviceMac() + ", deviceName=" + this.getDeviceName() + ", informBody=" + this.getInformBody() + ", timestamp=" + this.getTimestamp() + ", addressDTO=" + this.getAddressDTO() + ", oswInfo=" + this.getOswInfo() + ", supportAnomaly=" + this.getSupportAnomaly() + ", message=" + this.getMessage() + ", wirelessRouter=" + this.getWirelessRouter() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

