/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.internal.dto.olt;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.c.s;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeviceNotifyLogDTO
implements Serializable {
    private static final String INVALID_REQUEST = "Invalid request parameters.";
    private String omadacId;
    private String siteId;
    private String logKey;
    private Long logTime;
    private String[] params;

    public static DeviceNotifyLogDTO build(String omadacId, String siteId, s logKey, Long time, String ... params) {
        DeviceNotifyLogDTO dpmsLog = new DeviceNotifyLogDTO(omadacId, siteId, logKey.name(), time, params);
        if (!dpmsLog.validate(omadacId, logKey.name(), time, params)) {
            throw new IllegalArgumentException(INVALID_REQUEST);
        }
        return dpmsLog;
    }

    public static DeviceNotifyLogDTO build(String omadacId, String siteId, s logKey, Long time) {
        DeviceNotifyLogDTO dpmsLog = new DeviceNotifyLogDTO(omadacId, siteId, logKey.name(), time, null);
        if (!dpmsLog.validate(omadacId, logKey.name(), time, null)) {
            throw new IllegalArgumentException(INVALID_REQUEST);
        }
        return dpmsLog;
    }

    public static DeviceNotifyLogDTO build(String omadacId, s logKey, Long time, String ... params) {
        DeviceNotifyLogDTO dpmsLog = new DeviceNotifyLogDTO(omadacId, null, logKey.name(), time, params);
        if (!dpmsLog.validate(omadacId, logKey.name(), time, params)) {
            throw new IllegalArgumentException(INVALID_REQUEST);
        }
        return dpmsLog;
    }

    public static DeviceNotifyLogDTO build(String omadacId, s logKey, Long time) {
        DeviceNotifyLogDTO dpmsLog = new DeviceNotifyLogDTO(omadacId, null, logKey.name(), time, null);
        if (!dpmsLog.validate(omadacId, logKey.name(), time, null)) {
            throw new IllegalArgumentException(INVALID_REQUEST);
        }
        return dpmsLog;
    }

    public boolean validate(String omadacId, String logKey, Long time, String ... params) {
        if (Objects.isNull(omadacId) || Objects.isNull(logKey) || Objects.isNull(time)) {
            return false;
        }
        return !Objects.nonNull(params) || params.length >= 1;
    }

    public String toJson() {
        return x.a((Object)this);
    }

    public boolean isSite() {
        return !StringUtils.isNull((String)this.omadacId) && !StringUtils.isNull((String)this.siteId);
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getLogKey() {
        return this.logKey;
    }

    @Generated
    public Long getLogTime() {
        return this.logTime;
    }

    @Generated
    public String[] getParams() {
        return this.params;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setLogKey(String logKey) {
        this.logKey = logKey;
    }

    @Generated
    public void setLogTime(Long logTime) {
        this.logTime = logTime;
    }

    @Generated
    public void setParams(String[] params) {
        this.params = params;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DeviceNotifyLogDTO)) {
            return false;
        }
        DeviceNotifyLogDTO other = (DeviceNotifyLogDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$logTime = this.getLogTime();
        Long other$logTime = other.getLogTime();
        if (this$logTime == null ? other$logTime != null : !((Object)this$logTime).equals(other$logTime)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$logKey = this.getLogKey();
        String other$logKey = other.getLogKey();
        if (this$logKey == null ? other$logKey != null : !this$logKey.equals(other$logKey)) {
            return false;
        }
        return Arrays.deepEquals(this.getParams(), other.getParams());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceNotifyLogDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $logTime = this.getLogTime();
        result = result * 59 + ($logTime == null ? 43 : ((Object)$logTime).hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $logKey = this.getLogKey();
        result = result * 59 + ($logKey == null ? 43 : $logKey.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParams());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceNotifyLogDTO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", logKey=" + this.getLogKey() + ", logTime=" + this.getLogTime() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
    }

    @Generated
    public DeviceNotifyLogDTO() {
    }

    @Generated
    public DeviceNotifyLogDTO(String omadacId, String siteId, String logKey, Long logTime, String[] params) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.logKey = logKey;
        this.logTime = logTime;
        this.params = params;
    }
}

