/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.topology.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.BaseTopologyNodeDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.ClientAggHealthDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.SupportNetworkDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.SupportSsidDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyFilterClientCountDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public abstract class BaseTopologyDeviceDTO
extends BaseTopologyNodeDTO {
    private Integer clientCount;
    private Integer ipcCount;
    private TopologyFilterClientCountDTO filterClientCount;
    private TopologyFilterClientCountDTO filterCameraClientCount;
    private Integer mixClientCount;
    private List<BaseTopologyNodeDTO> successors;
    private Integer healthScore;
    private ClientAggHealthDTO clientHealth;
    @JsonIgnore
    private Boolean clientGroupCount;
    @JsonIgnore
    private Boolean inTopology;
    private Boolean vigiManaged;
    private Boolean vigiOnline;
    private String ip;
    private String firmwareVersion;
    @JsonIgnore
    private Boolean managedByVms;
    private Boolean disconnected;
    private Boolean active;
    private List<SupportNetworkDTO> supportNetworks;
    private List<SupportSsidDTO> supportSsids;
    private Boolean warnNvrFirmware;
    private Boolean existStpLoop;

    public BaseTopologyDeviceDTO() {
        this.setClientCount(0);
        this.setIpcCount(0);
        this.setSuccessors(new ArrayList<BaseTopologyNodeDTO>());
    }

    public int increaseClientCount() {
        if (this.clientCount == null) {
            this.clientCount = 0;
        }
        Integer n2 = this.clientCount;
        this.clientCount = this.clientCount + 1;
        return n2;
    }

    public int increaseIpcCount() {
        if (this.ipcCount == null) {
            this.ipcCount = 0;
        }
        Integer n2 = this.ipcCount;
        this.ipcCount = this.ipcCount + 1;
        return n2;
    }

    public void addSuccessor(BaseTopologyNodeDTO successor) {
        if (this.successors == null) {
            this.successors = new ArrayList<BaseTopologyNodeDTO>();
        }
        this.successors.add(successor);
    }

    public List<String> getVigiSuccessor() {
        if (CollectionUtils.isEmpty(this.successors)) {
            return new ArrayList<String>();
        }
        return this.successors.stream().filter(node -> b.F.contains(node.getType())).map(BaseTopologyNodeDTO::getMac).collect(Collectors.toList());
    }

    public List<String> getAllVigiSuccessor() {
        if (CollectionUtils.isEmpty(this.successors)) {
            return new ArrayList<String>();
        }
        return this.successors.stream().filter(node -> b.G.contains(node.getType())).map(BaseTopologyNodeDTO::getMac).collect(Collectors.toList());
    }

    @JsonIgnore
    public boolean vigiOnlineManaged() {
        return Boolean.TRUE.equals(this.vigiManaged) && Boolean.TRUE.equals(this.vigiOnline);
    }

    public void setIpcCount(Integer clientCount) {
        if (Objects.isNull(this.ipcCount) || this.ipcCount < 0) {
            this.ipcCount = 0;
        }
        this.ipcCount = clientCount;
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BaseTopologyDeviceDTO)) {
            return false;
        }
        BaseTopologyDeviceDTO other = (BaseTopologyDeviceDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$clientCount = this.getClientCount();
        Integer other$clientCount = other.getClientCount();
        if (this$clientCount == null ? other$clientCount != null : !((Object)this$clientCount).equals(other$clientCount)) {
            return false;
        }
        Integer this$ipcCount = this.getIpcCount();
        Integer other$ipcCount = other.getIpcCount();
        if (this$ipcCount == null ? other$ipcCount != null : !((Object)this$ipcCount).equals(other$ipcCount)) {
            return false;
        }
        Integer this$mixClientCount = this.getMixClientCount();
        Integer other$mixClientCount = other.getMixClientCount();
        if (this$mixClientCount == null ? other$mixClientCount != null : !((Object)this$mixClientCount).equals(other$mixClientCount)) {
            return false;
        }
        Integer this$healthScore = this.getHealthScore();
        Integer other$healthScore = other.getHealthScore();
        if (this$healthScore == null ? other$healthScore != null : !((Object)this$healthScore).equals(other$healthScore)) {
            return false;
        }
        Boolean this$clientGroupCount = this.getClientGroupCount();
        Boolean other$clientGroupCount = other.getClientGroupCount();
        if (this$clientGroupCount == null ? other$clientGroupCount != null : !((Object)this$clientGroupCount).equals(other$clientGroupCount)) {
            return false;
        }
        Boolean this$inTopology = this.getInTopology();
        Boolean other$inTopology = other.getInTopology();
        if (this$inTopology == null ? other$inTopology != null : !((Object)this$inTopology).equals(other$inTopology)) {
            return false;
        }
        Boolean this$vigiManaged = this.getVigiManaged();
        Boolean other$vigiManaged = other.getVigiManaged();
        if (this$vigiManaged == null ? other$vigiManaged != null : !((Object)this$vigiManaged).equals(other$vigiManaged)) {
            return false;
        }
        Boolean this$vigiOnline = this.getVigiOnline();
        Boolean other$vigiOnline = other.getVigiOnline();
        if (this$vigiOnline == null ? other$vigiOnline != null : !((Object)this$vigiOnline).equals(other$vigiOnline)) {
            return false;
        }
        Boolean this$managedByVms = this.getManagedByVms();
        Boolean other$managedByVms = other.getManagedByVms();
        if (this$managedByVms == null ? other$managedByVms != null : !((Object)this$managedByVms).equals(other$managedByVms)) {
            return false;
        }
        Boolean this$disconnected = this.getDisconnected();
        Boolean other$disconnected = other.getDisconnected();
        if (this$disconnected == null ? other$disconnected != null : !((Object)this$disconnected).equals(other$disconnected)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$warnNvrFirmware = this.getWarnNvrFirmware();
        Boolean other$warnNvrFirmware = other.getWarnNvrFirmware();
        if (this$warnNvrFirmware == null ? other$warnNvrFirmware != null : !((Object)this$warnNvrFirmware).equals(other$warnNvrFirmware)) {
            return false;
        }
        Boolean this$existStpLoop = this.getExistStpLoop();
        Boolean other$existStpLoop = other.getExistStpLoop();
        if (this$existStpLoop == null ? other$existStpLoop != null : !((Object)this$existStpLoop).equals(other$existStpLoop)) {
            return false;
        }
        TopologyFilterClientCountDTO this$filterClientCount = this.getFilterClientCount();
        TopologyFilterClientCountDTO other$filterClientCount = other.getFilterClientCount();
        if (this$filterClientCount == null ? other$filterClientCount != null : !((Object)this$filterClientCount).equals(other$filterClientCount)) {
            return false;
        }
        TopologyFilterClientCountDTO this$filterCameraClientCount = this.getFilterCameraClientCount();
        TopologyFilterClientCountDTO other$filterCameraClientCount = other.getFilterCameraClientCount();
        if (this$filterCameraClientCount == null ? other$filterCameraClientCount != null : !((Object)this$filterCameraClientCount).equals(other$filterCameraClientCount)) {
            return false;
        }
        List<BaseTopologyNodeDTO> this$successors = this.getSuccessors();
        List<BaseTopologyNodeDTO> other$successors = other.getSuccessors();
        if (this$successors == null ? other$successors != null : !((Object)this$successors).equals(other$successors)) {
            return false;
        }
        ClientAggHealthDTO this$clientHealth = this.getClientHealth();
        ClientAggHealthDTO other$clientHealth = other.getClientHealth();
        if (this$clientHealth == null ? other$clientHealth != null : !((Object)this$clientHealth).equals(other$clientHealth)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$firmwareVersion = this.getFirmwareVersion();
        String other$firmwareVersion = other.getFirmwareVersion();
        if (this$firmwareVersion == null ? other$firmwareVersion != null : !this$firmwareVersion.equals(other$firmwareVersion)) {
            return false;
        }
        List<SupportNetworkDTO> this$supportNetworks = this.getSupportNetworks();
        List<SupportNetworkDTO> other$supportNetworks = other.getSupportNetworks();
        if (this$supportNetworks == null ? other$supportNetworks != null : !((Object)this$supportNetworks).equals(other$supportNetworks)) {
            return false;
        }
        List<SupportSsidDTO> this$supportSsids = this.getSupportSsids();
        List<SupportSsidDTO> other$supportSsids = other.getSupportSsids();
        return !(this$supportSsids == null ? other$supportSsids != null : !((Object)this$supportSsids).equals(other$supportSsids));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseTopologyDeviceDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $clientCount = this.getClientCount();
        result = result * 59 + ($clientCount == null ? 43 : ((Object)$clientCount).hashCode());
        Integer $ipcCount = this.getIpcCount();
        result = result * 59 + ($ipcCount == null ? 43 : ((Object)$ipcCount).hashCode());
        Integer $mixClientCount = this.getMixClientCount();
        result = result * 59 + ($mixClientCount == null ? 43 : ((Object)$mixClientCount).hashCode());
        Integer $healthScore = this.getHealthScore();
        result = result * 59 + ($healthScore == null ? 43 : ((Object)$healthScore).hashCode());
        Boolean $clientGroupCount = this.getClientGroupCount();
        result = result * 59 + ($clientGroupCount == null ? 43 : ((Object)$clientGroupCount).hashCode());
        Boolean $inTopology = this.getInTopology();
        result = result * 59 + ($inTopology == null ? 43 : ((Object)$inTopology).hashCode());
        Boolean $vigiManaged = this.getVigiManaged();
        result = result * 59 + ($vigiManaged == null ? 43 : ((Object)$vigiManaged).hashCode());
        Boolean $vigiOnline = this.getVigiOnline();
        result = result * 59 + ($vigiOnline == null ? 43 : ((Object)$vigiOnline).hashCode());
        Boolean $managedByVms = this.getManagedByVms();
        result = result * 59 + ($managedByVms == null ? 43 : ((Object)$managedByVms).hashCode());
        Boolean $disconnected = this.getDisconnected();
        result = result * 59 + ($disconnected == null ? 43 : ((Object)$disconnected).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $warnNvrFirmware = this.getWarnNvrFirmware();
        result = result * 59 + ($warnNvrFirmware == null ? 43 : ((Object)$warnNvrFirmware).hashCode());
        Boolean $existStpLoop = this.getExistStpLoop();
        result = result * 59 + ($existStpLoop == null ? 43 : ((Object)$existStpLoop).hashCode());
        TopologyFilterClientCountDTO $filterClientCount = this.getFilterClientCount();
        result = result * 59 + ($filterClientCount == null ? 43 : ((Object)$filterClientCount).hashCode());
        TopologyFilterClientCountDTO $filterCameraClientCount = this.getFilterCameraClientCount();
        result = result * 59 + ($filterCameraClientCount == null ? 43 : ((Object)$filterCameraClientCount).hashCode());
        List<BaseTopologyNodeDTO> $successors = this.getSuccessors();
        result = result * 59 + ($successors == null ? 43 : ((Object)$successors).hashCode());
        ClientAggHealthDTO $clientHealth = this.getClientHealth();
        result = result * 59 + ($clientHealth == null ? 43 : ((Object)$clientHealth).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $firmwareVersion = this.getFirmwareVersion();
        result = result * 59 + ($firmwareVersion == null ? 43 : $firmwareVersion.hashCode());
        List<SupportNetworkDTO> $supportNetworks = this.getSupportNetworks();
        result = result * 59 + ($supportNetworks == null ? 43 : ((Object)$supportNetworks).hashCode());
        List<SupportSsidDTO> $supportSsids = this.getSupportSsids();
        result = result * 59 + ($supportSsids == null ? 43 : ((Object)$supportSsids).hashCode());
        return result;
    }

    @Generated
    public Integer getClientCount() {
        return this.clientCount;
    }

    @Generated
    public Integer getIpcCount() {
        return this.ipcCount;
    }

    @Generated
    public TopologyFilterClientCountDTO getFilterClientCount() {
        return this.filterClientCount;
    }

    @Generated
    public TopologyFilterClientCountDTO getFilterCameraClientCount() {
        return this.filterCameraClientCount;
    }

    @Generated
    public Integer getMixClientCount() {
        return this.mixClientCount;
    }

    @Generated
    public List<BaseTopologyNodeDTO> getSuccessors() {
        return this.successors;
    }

    @Generated
    public Integer getHealthScore() {
        return this.healthScore;
    }

    @Generated
    public ClientAggHealthDTO getClientHealth() {
        return this.clientHealth;
    }

    @Generated
    public Boolean getClientGroupCount() {
        return this.clientGroupCount;
    }

    @Generated
    public Boolean getInTopology() {
        return this.inTopology;
    }

    @Generated
    public Boolean getVigiManaged() {
        return this.vigiManaged;
    }

    @Generated
    public Boolean getVigiOnline() {
        return this.vigiOnline;
    }

    @Override
    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Generated
    public Boolean getManagedByVms() {
        return this.managedByVms;
    }

    @Generated
    public Boolean getDisconnected() {
        return this.disconnected;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public List<SupportNetworkDTO> getSupportNetworks() {
        return this.supportNetworks;
    }

    @Generated
    public List<SupportSsidDTO> getSupportSsids() {
        return this.supportSsids;
    }

    @Generated
    public Boolean getWarnNvrFirmware() {
        return this.warnNvrFirmware;
    }

    @Generated
    public Boolean getExistStpLoop() {
        return this.existStpLoop;
    }

    @Generated
    public void setClientCount(Integer clientCount) {
        this.clientCount = clientCount;
    }

    @Generated
    public void setFilterClientCount(TopologyFilterClientCountDTO filterClientCount) {
        this.filterClientCount = filterClientCount;
    }

    @Generated
    public void setFilterCameraClientCount(TopologyFilterClientCountDTO filterCameraClientCount) {
        this.filterCameraClientCount = filterCameraClientCount;
    }

    @Generated
    public void setMixClientCount(Integer mixClientCount) {
        this.mixClientCount = mixClientCount;
    }

    @Generated
    public void setSuccessors(List<BaseTopologyNodeDTO> successors) {
        this.successors = successors;
    }

    @Generated
    public void setHealthScore(Integer healthScore) {
        this.healthScore = healthScore;
    }

    @Generated
    public void setClientHealth(ClientAggHealthDTO clientHealth) {
        this.clientHealth = clientHealth;
    }

    @JsonIgnore
    @Generated
    public void setClientGroupCount(Boolean clientGroupCount) {
        this.clientGroupCount = clientGroupCount;
    }

    @JsonIgnore
    @Generated
    public void setInTopology(Boolean inTopology) {
        this.inTopology = inTopology;
    }

    @Generated
    public void setVigiManaged(Boolean vigiManaged) {
        this.vigiManaged = vigiManaged;
    }

    @Generated
    public void setVigiOnline(Boolean vigiOnline) {
        this.vigiOnline = vigiOnline;
    }

    @Override
    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @JsonIgnore
    @Generated
    public void setManagedByVms(Boolean managedByVms) {
        this.managedByVms = managedByVms;
    }

    @Generated
    public void setDisconnected(Boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setSupportNetworks(List<SupportNetworkDTO> supportNetworks) {
        this.supportNetworks = supportNetworks;
    }

    @Generated
    public void setSupportSsids(List<SupportSsidDTO> supportSsids) {
        this.supportSsids = supportSsids;
    }

    @Generated
    public void setWarnNvrFirmware(Boolean warnNvrFirmware) {
        this.warnNvrFirmware = warnNvrFirmware;
    }

    @Generated
    public void setExistStpLoop(Boolean existStpLoop) {
        this.existStpLoop = existStpLoop;
    }

    @Override
    @Generated
    public String toString() {
        return "BaseTopologyDeviceDTO(super=" + super.toString() + ", clientCount=" + this.getClientCount() + ", ipcCount=" + this.getIpcCount() + ", filterClientCount=" + this.getFilterClientCount() + ", filterCameraClientCount=" + this.getFilterCameraClientCount() + ", mixClientCount=" + this.getMixClientCount() + ", successors=" + this.getSuccessors() + ", healthScore=" + this.getHealthScore() + ", clientHealth=" + this.getClientHealth() + ", clientGroupCount=" + this.getClientGroupCount() + ", inTopology=" + this.getInTopology() + ", vigiManaged=" + this.getVigiManaged() + ", vigiOnline=" + this.getVigiOnline() + ", ip=" + this.getIp() + ", firmwareVersion=" + this.getFirmwareVersion() + ", managedByVms=" + this.getManagedByVms() + ", disconnected=" + this.getDisconnected() + ", active=" + this.getActive() + ", supportNetworks=" + this.getSupportNetworks() + ", supportSsids=" + this.getSupportSsids() + ", warnNvrFirmware=" + this.getWarnNvrFirmware() + ", existStpLoop=" + this.getExistStpLoop() + ")";
    }
}

