/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.wireless;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.common.util.f.b;
import com.tplink.smb.omada.common.util.f.c;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.c.G;
import com.tplink.smb.omada.manager.c.a.d;
import com.tplink.smb.omada.manager.c.a.f;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.AuthenticationParamVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.DhcpOption82SettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.EapMethodVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.HotspotV2SettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.MultiCastSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.PPSKSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.PlmnIdVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.PskSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.RateAndBeaconCtrlVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.RateLimitSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.RealmVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.RoamingConsortiumOiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVlanCustomSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVlanDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVlanSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.WpaSettingVO;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SsidVO
extends com.tplink.smb.omada.common.e.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SsidVO.class);
    private String id;
    private Integer idInt;
    private Long index;
    @NotNull
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    private String site;
    private String wlanId;
    private Integer band;
    private Boolean guestNetEnable;
    private Integer security;
    private Boolean broadcast;
    @Deprecated
    private Boolean vlanEnable;
    @Deprecated
    private Integer vlanId;
    private Boolean portalEnable;
    private String portalId;
    private String portalName;
    private Boolean accessEnable;
    @Valid
    @NotNull(message="rateLimit should not be null")
    private @Valid @NotNull(message="rateLimit should not be null") RateLimitSettingVO rateLimit;
    @Valid
    private RateLimitSettingVO ssidRateLimit;
    @Valid
    private WpaSettingVO wpaSetting;
    @Valid
    private PskSettingVO pskSetting;
    @NotNull(message="wlanScheduleEnable should not be null")
    private @NotNull(message="wlanScheduleEnable should not be null") Boolean wlanScheduleEnable;
    private Integer action;
    private String scheduleId;
    private Integer macFilterType;
    @NotNull(message="macFilterEnable should not be null")
    private @NotNull(message="macFilterEnable should not be null") Boolean macFilterEnable;
    private Integer policy;
    private String macFilterId;
    private List<String> ouiProfileIdList;
    @Valid
    private RateAndBeaconCtrlVO rateAndBeaconCtrl;
    private PPSKSettingVO ppskSetting;
    private Boolean enable11r;
    @NumberSet(value={1, 2, 3}, message="Parameter [pmfMode] should be 1 or 2 or 3")
    private Integer pmfMode;
    @Valid
    private MultiCastSettingVO multiCastSetting;
    private Boolean greEnable;
    private Boolean mloEnable;
    @Valid
    private DhcpOption82SettingVO dhcpOption82;
    private Boolean hidePwd;
    private Integer deviceType;
    private Boolean wanAccess;
    private Boolean prohibitWifiShare;
    private Integer resource;
    private Boolean oweEnable;
    private SsidVlanSettingVO vlanSetting;
    @Valid
    private HotspotV2SettingVO hotspotV2Setting;

    public static OperationResponse validate(SsidVO ssidVO) {
        OperationResponse validateRes = SsidVO.validateAndFillSsidName(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        validateRes = SsidVO.validateAndFillVlan(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        if (!(SsidVO.contain2G(ssidVO.getBand()) || SsidVO.contain5G(ssidVO.getBand()) || SsidVO.contain6G(ssidVO.getBand()))) {
            log.warn("Invalid band {} for ssid {}", (Object)ssidVO.getBand(), (Object)a.c((String)ssidVO.getName()));
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateAndFillSecurity(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        validateRes = SsidVO.validateRatelimit(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateSchedule(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateMacFilter(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateRateControl(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateMultiCast(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateMlo(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validate11r(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = SsidVO.validateDhcpOption82(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.deviceTypeContainsEap(ssidVO.getDeviceType()) && !SsidVO.deviceTypeContainsGateway(ssidVO.getDeviceType())) {
            log.warn("Invalid device type {} for ssid {}", (Object)ssidVO.getDeviceType(), (Object)a.c((String)ssidVO.getName()));
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validate11r(SsidVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getMloEnable()) && Boolean.TRUE.equals(ssidVO.getEnable11r())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    public static OperationResponse validateMlo(SsidVO ssidVO) {
        PskSettingVO pskSetting;
        WpaSettingVO wpaSetting;
        boolean contain6g;
        if (!Boolean.TRUE.equals(ssidVO.getMloEnable())) {
            return OperationResponse.SUCCESS;
        }
        int bandNum = 0;
        if (SsidVO.contain2G(ssidVO.getBand())) {
            ++bandNum;
        }
        if (SsidVO.contain5G(ssidVO.getBand())) {
            ++bandNum;
        }
        if (contain6g = SsidVO.contain6G(ssidVO.getBand())) {
            ++bandNum;
        }
        if (bandNum < 2) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Objects.nonNull((Object)ssidVO.getWpaSetting()) && !Objects.equals((wpaSetting = ssidVO.getWpaSetting()).getVersionEnt(), 4)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Objects.nonNull((Object)ssidVO.getPskSetting()) && !Objects.equals((pskSetting = ssidVO.getPskSetting()).getVersionPsk(), 4)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillSsidName(SsidVO ssidVO) {
        if (!b.e((String)ssidVO.getName())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gf);
        }
        if (Objects.equals(ssidVO.getName(), "00000JAPAN")) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fW);
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillVlan(SsidVO ssidVO) {
        if (ssidVO.getVlanSetting() != null) {
            return SsidVO.validateNewVlanSetting(ssidVO);
        }
        if (Boolean.TRUE.equals(ssidVO.getVlanEnable()) && (ssidVO.getVlanId() == null || !b.a((int)ssidVO.getVlanId(), (int)1, (int)4094))) {
            log.warn("Invalid vlanId {}", (Object)ssidVO.getVlanId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.nD);
        }
        SsidVlanSettingVO ssidVlanSettingVO = new SsidVlanSettingVO();
        if (Boolean.TRUE.equals(ssidVO.getVlanEnable())) {
            ssidVlanSettingVO.setMode(1);
            ssidVlanSettingVO.setCustomConfig((SsidVlanCustomSettingVO)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)SsidVlanCustomSettingVO.builder().customMode(1))).vlanId(ssidVO.getVlanId()))).build());
        } else {
            ssidVlanSettingVO.setMode(0);
        }
        ssidVO.setVlanSetting(ssidVlanSettingVO);
        ssidVO.setVlanId(null);
        ssidVO.setVlanEnable(null);
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateNewVlanSetting(SsidVO ssidVO) {
        SsidVlanSettingVO vlanSetting = ssidVO.getVlanSetting();
        if (Objects.equals(vlanSetting.getMode(), 0)) {
            return OperationResponse.SUCCESS;
        }
        if (Objects.equals(vlanSetting.getMode(), 1)) {
            if (vlanSetting.getCustomConfig() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            Integer customMode = vlanSetting.getCustomConfig().getCustomMode();
            if (Objects.equals(customMode, 0)) {
                Map<String, List<Integer>> lanNetworkVlanIds = vlanSetting.getCustomConfig().getLanNetworkVlanIds();
                if (Objects.isNull(vlanSetting.getCustomConfig().getLanNetworkId()) && (Objects.isNull(lanNetworkVlanIds) || lanNetworkVlanIds.isEmpty())) {
                    log.warn("LanNetworkVlanIds and lanNetworkIds are both null.");
                    return OperationResponse.PARAM_ERROR;
                }
                if (!CollectionUtils.isEmpty(lanNetworkVlanIds)) {
                    OperationResponse operationResponse = SsidVO.checkVlanIds(lanNetworkVlanIds);
                    if (!operationResponse.success()) {
                        return operationResponse;
                    }
                    SsidVO.fillLanNetworkIdAndBridgeVlan(ssidVO);
                }
            } else if (Objects.equals(customMode, 1)) {
                if (Objects.isNull(vlanSetting.getCustomConfig().getVlanPoolIds()) && Objects.isNull(vlanSetting.getCustomConfig().getVlanId())) {
                    log.warn("VlanPoolIds and vlanId are both null.");
                    return OperationResponse.PARAM_ERROR;
                }
                if (vlanSetting.getCustomConfig().getVlanPoolIds() != null) {
                    OperationResponse operationResponse = SsidVO.parseVlansString(vlanSetting.getCustomConfig().getVlanPoolIds());
                    if (!operationResponse.success()) {
                        log.warn("parse vlanPoolId failed because {}, vlanPoolId:{}", (Object)operationResponse.getMsg(), (Object)vlanSetting.getCustomConfig().getVlanPoolIds());
                        return operationResponse;
                    }
                    List vlanIds = (List)operationResponse.getResult();
                    if (vlanIds.size() > 256) {
                        log.warn("One SSID supports up to 256 VLAN pool ID.");
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.gv);
                    }
                    Collections.sort(vlanIds);
                    vlanSetting.getCustomConfig().setVlanId((Integer)vlanIds.get(0));
                }
            }
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse checkVlanIds(Map<String, List<Integer>> lanNetworkVlanIds) {
        int total = 0;
        for (String lanNetworkId : lanNetworkVlanIds.keySet()) {
            List<Integer> vlanIds = lanNetworkVlanIds.get(lanNetworkId);
            total += vlanIds.size();
        }
        if (total > 256) {
            log.warn("One SSID supports up to 256 VLAN pool ID.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gv);
        }
        return OperationResponse.SUCCESS;
    }

    private static void fillLanNetworkIdAndBridgeVlan(SsidVO ssidVO) {
        Map<String, List<Integer>> lanNetworkIdVlanIds = ssidVO.getVlanSetting().getCustomConfig().getLanNetworkVlanIds();
        ArrayList<Map.Entry<String, List<Integer>>> lanNetworkIdVlanIdsList = new ArrayList<Map.Entry<String, List<Integer>>>(lanNetworkIdVlanIds.entrySet());
        lanNetworkIdVlanIdsList.sort((o1, o2) -> {
            Integer i1 = (Integer)Collections.min((Collection)o1.getValue());
            Integer i2 = (Integer)Collections.min((Collection)o2.getValue());
            return i1 - i2;
        });
        ssidVO.getVlanSetting().getCustomConfig().setLanNetworkId((String)((Map.Entry)lanNetworkIdVlanIdsList.get(0)).getKey());
        ssidVO.getVlanSetting().getCustomConfig().setBridgeVlan((Integer)Collections.min((Collection)((Map.Entry)lanNetworkIdVlanIdsList.get(0)).getValue()));
    }

    private static OperationResponse parseVlansString(@Nonnull String vlans) {
        if (!vlans.matches("^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$")) {
            return OperationResponse.PARAM_ERROR;
        }
        ArrayList<Integer> vlanIds = new ArrayList<Integer>();
        String[] splitStrings = vlans.split(",");
        if (splitStrings == null || splitStrings.length == 0) {
            return OperationResponse.PARAM_ERROR;
        }
        if (splitStrings.length == 1 && splitStrings[0].matches("[\\d]+")) {
            if (!SsidVO.checkVlanString(splitStrings[0])) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.nD);
            }
            Integer vlanNum = Integer.valueOf(splitStrings[0]);
            vlanIds.add(vlanNum);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, vlanIds);
        }
        for (String splitString : splitStrings) {
            if (!SsidVO.checkVlanString(splitString)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.nD);
            }
            OperationResponse operationResponse = SsidVO.addVlansToList(splitString, vlanIds);
            if (operationResponse.success()) continue;
            return operationResponse;
        }
        if (vlanIds.size() == 0) {
            return OperationResponse.PARAM_ERROR;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, vlanIds);
    }

    private static boolean checkVlanString(String vlanString) {
        if (vlanString.matches("[\\d]+")) {
            int vlanNum = Integer.parseInt(vlanString);
            if (vlanNum < 1 || vlanNum > 4094) {
                log.warn("ssid vlan should be between 1 and 4094");
                return false;
            }
        } else if (vlanString.matches("^\\d+-\\d+$")) {
            String[] strings = vlanString.split("-");
            if (strings.length != 2) {
                log.warn("vlan should be like begin-end instead of {}", (Object)vlanString);
                return false;
            }
            int begin = Integer.parseInt(strings[0]);
            if (begin < 1 || begin > 4094) {
                log.warn("ssid begin vlan should be between 1 and 4094");
                return false;
            }
            int end = Integer.parseInt(strings[1]);
            if (end < 1 || end > 4094) {
                log.warn("ssid end vlan should be between 1 and 4094");
                return false;
            }
        } else {
            log.warn("vlanSplitString should be like 1 or 1-100");
            return false;
        }
        return true;
    }

    private static OperationResponse addVlansToList(String splitString, List<Integer> vlanIds) {
        if (splitString.matches("[\\d]+")) {
            Integer vlanNum = Integer.valueOf(splitString);
            if (vlanIds.contains(vlanNum)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.gw);
            }
            vlanIds.add(vlanNum);
        } else {
            String[] strings = splitString.split("-");
            int begin = Integer.parseInt(strings[0]);
            int end = Integer.parseInt(strings[1]);
            if (end < begin) {
                int temp = end;
                end = begin;
                begin = temp;
            }
            for (int i2 = begin; i2 <= end; ++i2) {
                if (vlanIds.contains(i2)) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.gw);
                }
                vlanIds.add(i2);
            }
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillSecurity(SsidVO ssidVO) {
        OperationResponse validateRes;
        Integer security = ssidVO.getSecurity();
        if (ssidVO.getSecurity() == null) {
            log.warn("Invalid security mode: null");
            return OperationResponse.PARAM_ERROR;
        }
        switch (security) {
            case 0: {
                validateRes = OperationResponse.SUCCESS;
                break;
            }
            case 2: {
                validateRes = SsidVO.validateEnterprise(ssidVO);
                break;
            }
            case 3: {
                boolean needCheckSecurityKey = !Boolean.TRUE.equals(ssidVO.getHidePwd()) || !T.a((String)ssidVO.getPskSetting().getSecurityKey());
                validateRes = SsidVO.validatePersonal(ssidVO, needCheckSecurityKey);
                break;
            }
            case 4: 
            case 5: {
                validateRes = SsidVO.validatePPSK(ssidVO);
                break;
            }
            default: {
                log.warn("Invalid SecurityMode {} of ssid {}", (Object)ssidVO.getSecurity(), (Object)a.c((String)ssidVO.getName()));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.fN);
            }
        }
        return validateRes;
    }

    private static OperationResponse validateRatelimit(SsidVO ssidVO) {
        boolean ratelimitEnable;
        RateLimitSettingVO ratelimit = ssidVO.getRateLimit();
        if (ratelimit == null) {
            log.warn("Empty ratelimit in ssid {}", (Object)ssidVO.getId());
            return OperationResponse.PARAM_ERROR;
        }
        boolean downEnable = Boolean.TRUE.equals(ratelimit.getDownLimitEnable());
        boolean upEnable = Boolean.TRUE.equals(ratelimit.getUpLimitEnable());
        boolean bl = ratelimitEnable = downEnable || upEnable;
        if (!ratelimitEnable) {
            return OperationResponse.SUCCESS;
        }
        if (downEnable && ratelimit.getDownLimit() == null) {
            log.warn("Downlimit should not be null");
            return OperationResponse.PARAM_ERROR;
        }
        if (upEnable && ratelimit.getUpLimit() == null) {
            log.warn("Uplimit should not be null");
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validatePPSK(SsidVO ssidVO) {
        OperationResponse ops = SsidVO.validatePersonal(ssidVO, false);
        if (!ops.success()) {
            return ops;
        }
        PPSKSettingVO ppskSettingVO = ssidVO.getPpskSetting();
        if (ppskSettingVO == null) {
            log.info("Empty ppskSetting in ssid {}", (Object)ssidVO.getId());
            return OperationResponse.PARAM_ERROR;
        }
        if (4 == ssidVO.getSecurity()) {
            if (ppskSettingVO.getPpskProfileId() == null) {
                log.info("Empty ppskProfileId in ssid {}", (Object)ssidVO.getId());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.mw);
            }
            if (ppskSettingVO.getRadiusProfileId() != null) {
                log.info("RadiusProfileId in ssid {}", (Object)ssidVO.getId());
                return OperationResponse.PARAM_ERROR;
            }
        }
        if (5 == ssidVO.getSecurity() && ppskSettingVO.getRadiusProfileId() == null) {
            log.info("Empty radiusProfileId in ssid {}", (Object)ssidVO.getId());
            return OperationResponse.PARAM_ERROR;
        }
        if ((4 == ssidVO.getSecurity() || 5 == ssidVO.getSecurity()) && Objects.equals(ssidVO.getPskSetting().getVersionPsk(), 4)) {
            log.info("SSID not support PPSK WPA3 mode in ssid {}", (Object)ssidVO.getId());
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateSchedule(SsidVO ssidVO) {
        if (!ssidVO.getWlanScheduleEnable().booleanValue()) {
            ssidVO.setAction(null);
            ssidVO.setScheduleId(null);
            return OperationResponse.SUCCESS;
        }
        if (T.a((String)ssidVO.getScheduleId())) {
            log.warn("Invalid empty scheduleId");
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateMacFilter(SsidVO ssidVO) {
        if (!Boolean.TRUE.equals(ssidVO.getMacFilterEnable())) {
            ssidVO.setPolicy(null);
            ssidVO.setMacFilterId(null);
            ssidVO.setOuiProfileIdList(null);
            return OperationResponse.SUCCESS;
        }
        if (T.a((String)ssidVO.getMacFilterId()) && CollectionUtils.isEmpty(ssidVO.getOuiProfileIdList())) {
            log.warn("Invalid empty macFilterId and empty oui profiles");
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateRateControl(SsidVO ssidVO) {
        if (!SsidVO.validateRateAndBeaconCtrl(ssidVO).success()) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validate2gRateSetting(ssidVO).success()) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validate5gRateSetting(ssidVO).success()) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validate6gRateSetting(ssidVO).success()) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateRateAndBeaconCtrl(SsidVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getRateAndBeaconCtrl().getRate2gCtrlEnable()) && (ssidVO.getRateAndBeaconCtrl().getCckRatesDisable() == null || ssidVO.getRateAndBeaconCtrl().getClientRatesRequire2g() == null)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(ssidVO.getRateAndBeaconCtrl().getRate5gCtrlEnable()) && ssidVO.getRateAndBeaconCtrl().getClientRatesRequire5g() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(ssidVO.getRateAndBeaconCtrl().getRate6gCtrlEnable()) && (ssidVO.getRateAndBeaconCtrl().getClientRatesRequire6g() == null || ssidVO.getRateAndBeaconCtrl().getSendBeacons6g() == null)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validate2gRateSetting(SsidVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getRateAndBeaconCtrl().getRate2gCtrlEnable())) {
            if (ssidVO.getRateAndBeaconCtrl().getLowerDensity2g() == null || !G.aK.contains(I.a((Number)ssidVO.getRateAndBeaconCtrl().getLowerDensity2g()))) {
                return OperationResponse.PARAM_ERROR;
            }
            if (ssidVO.getRateAndBeaconCtrl().getCckRatesDisable().booleanValue() && G.aL.contains(I.a((Number)ssidVO.getRateAndBeaconCtrl().getLowerDensity2g()))) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.fV);
            }
            if (ssidVO.getRateAndBeaconCtrl().getHigherDensity2g() == null || !Objects.equals(ssidVO.getRateAndBeaconCtrl().getHigherDensity2g(), 54)) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validate5gRateSetting(SsidVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getRateAndBeaconCtrl().getRate5gCtrlEnable())) {
            if (ssidVO.getRateAndBeaconCtrl().getLowerDensity5g() == null || !G.aM.contains(ssidVO.getRateAndBeaconCtrl().getLowerDensity5g())) {
                return OperationResponse.PARAM_ERROR;
            }
            if (ssidVO.getRateAndBeaconCtrl().getHigherDensity5g() == null || !Objects.equals(ssidVO.getRateAndBeaconCtrl().getHigherDensity5g(), 54)) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validate6gRateSetting(SsidVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getRateAndBeaconCtrl().getRate6gCtrlEnable())) {
            if (ssidVO.getRateAndBeaconCtrl().getLowerDensity6g() == null || !G.aM.contains(ssidVO.getRateAndBeaconCtrl().getLowerDensity6g())) {
                return OperationResponse.PARAM_ERROR;
            }
            if (ssidVO.getRateAndBeaconCtrl().getHigherDensity6g() == null || !Objects.equals(ssidVO.getRateAndBeaconCtrl().getHigherDensity6g(), 54)) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean contain2G(Integer bandInfo) {
        return bandInfo != null && (bandInfo & 1) > 0;
    }

    public static boolean contain5G(Integer bandInfo) {
        return bandInfo != null && (bandInfo & 2) > 0;
    }

    public static boolean contain6G(Integer bandInfo) {
        return bandInfo != null && (bandInfo & 4) > 0;
    }

    public static boolean onlyEnable6G(Integer bandInfo) {
        return bandInfo != null && bandInfo == 4;
    }

    public static OperationResponse validateEnterprise(SsidVO ssidVO) {
        boolean notSupportMix;
        boolean contain6G = SsidVO.contain6G(ssidVO.getBand());
        if (!SsidVO.validateWpaEntVersion(ssidVO.getWpaSetting().getVersionEnt(), contain6G)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpaEncryption(ssidVO.getWpaSetting().getEncryptionEnt())) {
            return OperationResponse.PARAM_ERROR;
        }
        boolean bl = notSupportMix = SsidVO.onlyEnable6G(ssidVO.getBand()) || SsidVO.contain6G(ssidVO.getBand()) && Boolean.TRUE.equals(ssidVO.getMloEnable());
        if (!SsidVO.validateWpa3Encryption(ssidVO.getWpaSetting().getVersionEnt(), ssidVO.getWpaSetting().getEncryptionEnt(), notSupportMix)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getWpaSetting().getGikRekeyEnable().booleanValue()) {
            if (ssidVO.getWpaSetting().getIntervalType() == null || ssidVO.getWpaSetting().getRekeyInterval() == null) {
                log.warn("Wpasetting Interval type or interval is null");
                return OperationResponse.PARAM_ERROR;
            }
            if (!SsidVO.validateGroupKeyUpdatePeriod(ssidVO.getWpaSetting().getRekeyInterval(), ssidVO.getWpaSetting().getIntervalType())) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        if (!SsidVO.validatePmfForEnterprise(ssidVO.getWpaSetting().getVersionEnt(), ssidVO.getWpaSetting().getEncryptionEnt(), ssidVO.getPmfMode())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gt);
        }
        if (Boolean.TRUE.equals(ssidVO.getOweEnable())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpaEntNasidMode(ssidVO.getWpaSetting().getMode())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (T.b((String)ssidVO.getWpaSetting().getNasId()) && (ssidVO.getWpaSetting().getMode() == null || ssidVO.getWpaSetting().getMode() != 2)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getWpaSetting().getMode() != null && ssidVO.getWpaSetting().getMode() == 2 && !SsidVO.validateWpaEntNasid(ssidVO.getWpaSetting().getNasId())) {
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse hotspotV2Resp = SsidVO.validateHotspotV2(ssidVO);
        if (!hotspotV2Resp.success()) {
            return hotspotV2Resp;
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean validateWpaEntVersion(Integer versionEnt, boolean contain6G) {
        if (contain6G) {
            return versionEnt != null && versionEnt == 4;
        }
        return versionEnt != null && (versionEnt == 1 || versionEnt == 2 || versionEnt == 3 || versionEnt == 4);
    }

    public static boolean validateWpaEncryption(Integer encryptionMode) {
        return encryptionMode != null && (encryptionMode == 1 || encryptionMode == 3 || encryptionMode == 4 || encryptionMode == 5 || encryptionMode == 6);
    }

    public static boolean validateWpa3PskEncryption(Integer versionPsk, Integer encryptionMode) {
        boolean isWpa3;
        boolean bl = isWpa3 = versionPsk == 4;
        if (isWpa3) {
            return encryptionMode == 3;
        }
        return true;
    }

    public static boolean validateWpa3Encryption(Integer versionPsk, Integer encryptionMode, boolean notSupportMix) {
        boolean isWpa3;
        boolean bl = isWpa3 = versionPsk == 4;
        if (isWpa3) {
            ArrayList<Integer> supportedModes = new ArrayList<Integer>(Arrays.asList(4, 5, 6));
            if (!notSupportMix) {
                supportedModes.add(3);
            }
            return supportedModes.contains(encryptionMode);
        }
        return true;
    }

    public static boolean validateWpaEntNasidMode(Integer mode) {
        return mode == null || mode == 0 || mode == 1 || mode == 2;
    }

    public static boolean validateWpaEntNasid(String nasId) {
        if (T.a((String)nasId)) {
            return false;
        }
        byte[] bytes = nasId.getBytes(StandardCharsets.UTF_8);
        return bytes.length <= 64;
    }

    public static boolean validateGroupKeyUpdatePeriod(Integer updatePeriod, Integer type) {
        boolean checkValue = false;
        switch (type) {
            case 0: {
                checkValue = updatePeriod != null && (updatePeriod == 0 || updatePeriod >= 30 && updatePeriod <= 8640000);
                break;
            }
            case 1: {
                checkValue = updatePeriod != null && (updatePeriod == 0 || updatePeriod >= 1 && updatePeriod <= 1440);
                break;
            }
            case 2: {
                checkValue = updatePeriod != null && (updatePeriod == 0 || updatePeriod >= 1 && updatePeriod <= 24);
                break;
            }
            default: {
                log.warn("Interval type {} is incorrect.", (Object)type);
            }
        }
        return checkValue;
    }

    public static OperationResponse validatePersonal(SsidVO ssidVO, boolean needCheckSecurityKey) {
        if (needCheckSecurityKey && T.a((String)ssidVO.getPskSetting().getSecurityKey())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getPskSetting().getVersionPsk() == null || ssidVO.getPskSetting().getEncryptionPsk() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!T.a((String)ssidVO.getPskSetting().getSecurityKey()) && !SsidVO.validatePsk(ssidVO.getPskSetting().getSecurityKey())) {
            log.warn("PSK securityKey should be 8-63 ASCII characters or 8-64 Hexadecimal characters");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fT);
        }
        if (ssidVO.getPskSetting().getGikRekeyPskEnable() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        boolean contain6G = SsidVO.contain6G(ssidVO.getBand());
        if (!SsidVO.validateWpaPskVersion(ssidVO.getPskSetting().getVersionPsk(), contain6G)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpaEncryption(ssidVO.getPskSetting().getEncryptionPsk())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpa3PskEncryption(ssidVO.getPskSetting().getVersionPsk(), ssidVO.getPskSetting().getEncryptionPsk())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getPskSetting().getGikRekeyPskEnable().booleanValue()) {
            if (ssidVO.getPskSetting().getIntervalPskType() == null || ssidVO.getPskSetting().getRekeyPskInterval() == null) {
                log.warn("Psksetting Interval type or interval is null");
                return OperationResponse.PARAM_ERROR;
            }
            if (!SsidVO.validateGroupKeyUpdatePeriod(ssidVO.getPskSetting().getRekeyPskInterval(), ssidVO.getPskSetting().getIntervalPskType())) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        if (!SsidVO.validatePmfForPsk(ssidVO.getPskSetting().getVersionPsk(), ssidVO.getPmfMode(), ssidVO.getBand(), ssidVO.getMloEnable())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gt);
        }
        if (Boolean.TRUE.equals(ssidVO.getOweEnable())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean validatePsk(String psk) {
        if (T.a((String)psk)) {
            return false;
        }
        Matcher matcher = c.be.matcher(psk);
        return matcher.matches();
    }

    public static boolean validateWpaPskVersion(Integer versionPsk, boolean contain6G) {
        if (contain6G) {
            return versionPsk != null && versionPsk == 4;
        }
        return versionPsk != null && (versionPsk == 1 || versionPsk == 2 || versionPsk == 3 || versionPsk == 4);
    }

    private static OperationResponse validateMultiCast(SsidVO ssidVO) {
        if (ssidVO.getMultiCastSetting() == null) {
            return OperationResponse.SUCCESS;
        }
        MultiCastSettingVO multiCastSetting = ssidVO.getMultiCastSetting();
        if (Boolean.TRUE.equals(multiCastSetting.getMultiCastEnable()) && Objects.isNull(multiCastSetting.getChannelUtil())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(multiCastSetting.getFilterEnable()) && Objects.isNull(multiCastSetting.getFilterMode())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean validatePmfForPsk(Integer versionPsk, Integer pmfMode, Integer bandInfo, Boolean mloEnable) {
        if (versionPsk != null && pmfMode != null) {
            if (versionPsk == 1 && (pmfMode == 1 || pmfMode == 2)) {
                return false;
            }
            if (versionPsk == 4) {
                if (SsidVO.onlyEnable6G(bandInfo) || Boolean.TRUE.equals(mloEnable) && SsidVO.contain6G(bandInfo)) {
                    return pmfMode != 2 && pmfMode != 3;
                }
                return pmfMode != 3;
            }
        }
        return true;
    }

    public static boolean validatePmfForEnterprise(Integer versionEnt, Integer encryptionEnt, Integer pmfMode) {
        if (versionEnt != null && pmfMode != null && encryptionEnt != null) {
            if (versionEnt == 1 && (pmfMode == 1 || pmfMode == 2)) {
                return false;
            }
            if (versionEnt == 4) {
                if (encryptionEnt == 3) {
                    return pmfMode != 3;
                }
                return pmfMode != 2 && pmfMode != 3;
            }
        }
        return true;
    }

    private static OperationResponse validateDhcpOption82(SsidVO ssidVO) {
        DhcpOption82SettingVO dhcpOption82Setting = ssidVO.getDhcpOption82();
        if (dhcpOption82Setting == null) {
            return OperationResponse.SUCCESS;
        }
        if (Boolean.TRUE.equals(dhcpOption82Setting.getDhcpEnable())) {
            if (Objects.isNull(dhcpOption82Setting.getFormat()) || Objects.isNull(dhcpOption82Setting.getDelimiter())) {
                return OperationResponse.PARAM_ERROR;
            }
            if (CollectionUtils.isEmpty(dhcpOption82Setting.getCircuitId()) || CollectionUtils.isEmpty(dhcpOption82Setting.getRemoteId())) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean deviceTypeContainsEap(Integer deviceType) {
        if (deviceType == null) {
            return true;
        }
        return (deviceType & 1) > 0;
    }

    public static boolean deviceTypeContainsGateway(Integer deviceType) {
        if (deviceType == null) {
            return true;
        }
        return (deviceType & 2) > 0;
    }

    public static OperationResponse validateHotspotV2(SsidVO ssidVO) {
        HotspotV2SettingVO hotspotV2Setting = ssidVO.getHotspotV2Setting();
        if (SsidVO.ssidSupportHotspotV2(ssidVO)) {
            if (Objects.nonNull((Object)hotspotV2Setting)) {
                if (Objects.equals(hotspotV2Setting.getHotspotV2Enable(), Boolean.TRUE)) {
                    f venueInfoEnum;
                    List plmnIds = Optional.ofNullable(hotspotV2Setting.getPlmnId()).map(plmnIdVOS -> plmnIdVOS.stream().filter(Objects::nonNull).map(PlmnIdVO::getValue).toList()).orElse(new ArrayList());
                    if (plmnIds.stream().anyMatch(Objects::isNull) || !plmnIds.stream().map(Integer::valueOf).allMatch(value -> value >= 10000 && value <= 999999)) {
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.gQ);
                    }
                    if ((long)plmnIds.size() != plmnIds.stream().distinct().count()) {
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.gy);
                    }
                    Optional.ofNullable(hotspotV2Setting.getRoamingConsortiumOi()).map(roamingConsortiumOiVOList -> roamingConsortiumOiVOList.stream().filter(Objects::nonNull).map(roamingConsortiumOiVO -> {
                        roamingConsortiumOiVO.setValue(roamingConsortiumOiVO.getValue().toUpperCase(Locale.ROOT));
                        return roamingConsortiumOiVO;
                    }));
                    List roamingConsortiumOis = Optional.ofNullable(hotspotV2Setting.getRoamingConsortiumOi()).map(roamingConsortiumOiVOList -> roamingConsortiumOiVOList.stream().map(RoamingConsortiumOiVO::getValue).collect(Collectors.toList())).orElse(new ArrayList());
                    if ((long)roamingConsortiumOis.size() != roamingConsortiumOis.stream().distinct().count()) {
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.gz);
                    }
                    if (!(Objects.isNull(hotspotV2Setting.getVenueInfo()) || Objects.isNull(hotspotV2Setting.getVenueInfo().getGroup()) || !Objects.isNull((Object)(venueInfoEnum = f.a(hotspotV2Setting.getVenueInfo().getGroup()))) && (Objects.isNull(hotspotV2Setting.getVenueInfo().getType()) || venueInfoEnum.b().contains(hotspotV2Setting.getVenueInfo().getType())))) {
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.gA);
                    }
                    if (!Objects.isNull(hotspotV2Setting.getRealmList()) && !hotspotV2Setting.getRealmList().isEmpty()) {
                        hotspotV2Setting.setRealmList(hotspotV2Setting.getRealmList().stream().filter(Objects::nonNull).toList());
                        if (hotspotV2Setting.getRealmList().stream().map(RealmVO::getName).collect(Collectors.toSet()).size() < hotspotV2Setting.getRealmList().size()) {
                            return new OperationResponse(com.tplink.smb.omada.common.g.b.gD);
                        }
                        for (RealmVO realmVO : hotspotV2Setting.getRealmList()) {
                            if (b.a((String)realmVO.getName(), (int)1, (int)64, (String)"UTF-8")) continue;
                            return new OperationResponse(com.tplink.smb.omada.common.g.b.gE);
                        }
                        for (RealmVO realmVO : hotspotV2Setting.getRealmList()) {
                            for (EapMethodVO eapMethodVO : realmVO.getEap()) {
                                for (AuthenticationParamVO authenticationParamVO : eapMethodVO.getParam()) {
                                    d authParamEnum = d.a(authenticationParamVO.getId());
                                    if (Objects.nonNull((Object)authParamEnum) && authParamEnum.b().contains(authenticationParamVO.getValue())) continue;
                                    return new OperationResponse(com.tplink.smb.omada.common.g.b.gB);
                                }
                            }
                        }
                    }
                }
            } else {
                ssidVO.setHotspotV2Setting(new HotspotV2SettingVO());
                ssidVO.getHotspotV2Setting().setHotspotV2Enable(false);
            }
        } else if (!Objects.isNull((Object)hotspotV2Setting)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gC);
        }
        return OperationResponse.ok();
    }

    private static boolean ssidSupportHotspotV2(SsidVO ssidVO) {
        Integer wpaVersion = ssidVO.getWpaSetting().getVersionEnt();
        Integer wpaEncryption = ssidVO.getWpaSetting().getEncryptionEnt();
        return Objects.equals(wpaVersion, 2) && Objects.equals(wpaEncryption, 3) || Objects.equals(wpaVersion, 4);
    }

    public static SsidVO createSsidVOWithSimpleParam(Integer security, String ssidName, String ssidPwd, Integer band, Integer deviceType, boolean guestNetEnable, @Nullable SsidVlanDTO vlan, @Nullable String radiusProfileId) {
        switch (security) {
            case 0: {
                return SsidVO.createNoneSsidVOWithSimpleParam(ssidName, band, deviceType, guestNetEnable, vlan);
            }
            case 3: {
                return SsidVO.createPersonalSsidVOWithSimpleParam(ssidName, ssidPwd, band, deviceType, guestNetEnable, vlan);
            }
            case 2: {
                return SsidVO.createEnterpriseSsidVOWithSimpleParam(ssidName, ssidPwd, band, deviceType, guestNetEnable, vlan, radiusProfileId);
            }
        }
        return null;
    }

    public static SsidVO createEnterpriseSsidVOWithSimpleParam(String ssidName, String ssidPwd, Integer band, Integer deviceType, boolean guestNetEnable, SsidVlanDTO vlan, String radiusProfileId) {
        int pmfMode;
        int versionEnt;
        SsidVlanSettingVO ssidVlanSettingVO = new SsidVlanSettingVO();
        if (Objects.isNull(vlan)) {
            ssidVlanSettingVO.setMode(0);
        } else {
            ssidVlanSettingVO.setMode(1);
            ssidVlanSettingVO.setCustomConfig((SsidVlanCustomSettingVO)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)SsidVlanCustomSettingVO.builder().customMode(0))).lanNetworkId(vlan.getLanNetworkId()))).bridgeVlan(vlan.getBridgeVlan()))).build());
        }
        if ((band & 4) > 0) {
            versionEnt = 4;
            pmfMode = 2;
        } else {
            versionEnt = 2;
            pmfMode = 3;
        }
        return ((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)SsidVO.builder().name(ssidName))).band(band))).guestNetEnable(guestNetEnable))).security(2))).broadcast(true))).rateLimit((RateLimitSettingVO)((RateLimitSettingVO.RateLimitSettingVOBuilder)((Object)((RateLimitSettingVO.RateLimitSettingVOBuilder)((Object)RateLimitSettingVO.builder().downLimitEnable(false))).upLimitEnable(false))).build()))).wlanScheduleEnable(false))).macFilterEnable(false))).rateAndBeaconCtrl((RateAndBeaconCtrlVO)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)RateAndBeaconCtrlVO.builder().rate2gCtrlEnable(false))).rate5gCtrlEnable(false))).rate6gCtrlEnable(false))).build()))).wpaSetting((WpaSettingVO)((WpaSettingVO.WpaSettingVOBuilder)((Object)((WpaSettingVO.WpaSettingVOBuilder)((Object)((WpaSettingVO.WpaSettingVOBuilder)((Object)((WpaSettingVO.WpaSettingVOBuilder)((Object)((WpaSettingVO.WpaSettingVOBuilder)((Object)WpaSettingVO.builder().gikRekeyEnable(false))).versionEnt(versionEnt))).encryptionEnt(3))).radiusProfileId(radiusProfileId))).mode(0))).build()))).pmfMode(pmfMode))).multiCastSetting(MultiCastSettingVO.buildDefaultVO()))).greEnable(false))).dhcpOption82((DhcpOption82SettingVO)((DhcpOption82SettingVO.DhcpOption82SettingVOBuilder)((Object)DhcpOption82SettingVO.builder().dhcpEnable(false))).build()))).deviceType(deviceType))).vlanSetting(ssidVlanSettingVO))).oweEnable(false))).build();
    }

    public static SsidVO createNoneSsidVOWithSimpleParam(String ssidName, Integer band, Integer deviceType, boolean guestNetEnable, @Nullable SsidVlanDTO vlan) {
        SsidVlanSettingVO ssidVlanSettingVO = new SsidVlanSettingVO();
        if (Objects.isNull(vlan)) {
            ssidVlanSettingVO.setMode(0);
        } else {
            ssidVlanSettingVO.setMode(1);
            ssidVlanSettingVO.setCustomConfig((SsidVlanCustomSettingVO)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)SsidVlanCustomSettingVO.builder().customMode(0))).lanNetworkId(vlan.getLanNetworkId()))).bridgeVlan(vlan.getBridgeVlan()))).build());
        }
        return ((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)SsidVO.builder().name(ssidName))).band(band))).guestNetEnable(guestNetEnable))).security(0))).broadcast(true))).rateLimit((RateLimitSettingVO)((RateLimitSettingVO.RateLimitSettingVOBuilder)((Object)((RateLimitSettingVO.RateLimitSettingVOBuilder)((Object)RateLimitSettingVO.builder().downLimitEnable(false))).upLimitEnable(false))).build()))).wlanScheduleEnable(false))).macFilterEnable(false))).rateAndBeaconCtrl((RateAndBeaconCtrlVO)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)RateAndBeaconCtrlVO.builder().rate2gCtrlEnable(false))).rate5gCtrlEnable(false))).rate6gCtrlEnable(false))).build()))).multiCastSetting(MultiCastSettingVO.buildDefaultVO()))).greEnable(false))).dhcpOption82((DhcpOption82SettingVO)((DhcpOption82SettingVO.DhcpOption82SettingVOBuilder)((Object)DhcpOption82SettingVO.builder().dhcpEnable(false))).build()))).deviceType(deviceType))).vlanSetting(ssidVlanSettingVO))).oweEnable(false))).build();
    }

    public static SsidVO createPersonalSsidVOWithSimpleParam(String ssidName, String ssidPwd, Integer band, Integer deviceType, boolean guestNetEnable, @Nullable SsidVlanDTO vlan) {
        int pmfMode;
        int versionPsk;
        if ((band & 4) > 0) {
            versionPsk = 4;
            pmfMode = 2;
        } else {
            versionPsk = 2;
            pmfMode = 3;
        }
        SsidVlanSettingVO ssidVlanSettingVO = new SsidVlanSettingVO();
        if (Objects.isNull(vlan)) {
            ssidVlanSettingVO.setMode(0);
        } else {
            ssidVlanSettingVO.setMode(1);
            ssidVlanSettingVO.setCustomConfig((SsidVlanCustomSettingVO)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)((SsidVlanCustomSettingVO.SsidVlanCustomSettingVOBuilder)((Object)SsidVlanCustomSettingVO.builder().customMode(0))).lanNetworkId(vlan.getLanNetworkId()))).bridgeVlan(vlan.getBridgeVlan()))).build());
        }
        return ((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)((SsidVOBuilder)((Object)SsidVO.builder().name(ssidName))).band(band))).guestNetEnable(guestNetEnable))).security(3))).broadcast(true))).rateLimit((RateLimitSettingVO)((RateLimitSettingVO.RateLimitSettingVOBuilder)((Object)((RateLimitSettingVO.RateLimitSettingVOBuilder)((Object)RateLimitSettingVO.builder().downLimitEnable(false))).upLimitEnable(false))).build()))).wlanScheduleEnable(false))).macFilterEnable(false))).rateAndBeaconCtrl((RateAndBeaconCtrlVO)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)((RateAndBeaconCtrlVO.RateAndBeaconCtrlVOBuilder)((Object)RateAndBeaconCtrlVO.builder().rate2gCtrlEnable(false))).rate5gCtrlEnable(false))).rate6gCtrlEnable(false))).build()))).pskSetting((PskSettingVO)((PskSettingVO.PskSettingVOBuilder)((Object)((PskSettingVO.PskSettingVOBuilder)((Object)((PskSettingVO.PskSettingVOBuilder)((Object)((PskSettingVO.PskSettingVOBuilder)((Object)PskSettingVO.builder().securityKey(ssidPwd))).gikRekeyPskEnable(false))).versionPsk(versionPsk))).encryptionPsk(3))).build()))).pmfMode(pmfMode))).multiCastSetting(MultiCastSettingVO.buildDefaultVO()))).greEnable(false))).dhcpOption82((DhcpOption82SettingVO)((DhcpOption82SettingVO.DhcpOption82SettingVOBuilder)((Object)DhcpOption82SettingVO.builder().dhcpEnable(false))).build()))).deviceType(deviceType))).vlanSetting(ssidVlanSettingVO))).oweEnable(false))).build();
    }

    @Generated
    protected SsidVO(SsidVOBuilder<?, ?> b2) {
        super(b2);
        this.id = b2.id;
        this.idInt = b2.idInt;
        this.index = b2.index;
        this.name = b2.name;
        this.site = b2.site;
        this.wlanId = b2.wlanId;
        this.band = b2.band;
        this.guestNetEnable = b2.guestNetEnable;
        this.security = b2.security;
        this.broadcast = b2.broadcast;
        this.vlanEnable = b2.vlanEnable;
        this.vlanId = b2.vlanId;
        this.portalEnable = b2.portalEnable;
        this.portalId = b2.portalId;
        this.portalName = b2.portalName;
        this.accessEnable = b2.accessEnable;
        this.rateLimit = b2.rateLimit;
        this.ssidRateLimit = b2.ssidRateLimit;
        this.wpaSetting = b2.wpaSetting;
        this.pskSetting = b2.pskSetting;
        this.wlanScheduleEnable = b2.wlanScheduleEnable;
        this.action = b2.action;
        this.scheduleId = b2.scheduleId;
        this.macFilterType = b2.macFilterType;
        this.macFilterEnable = b2.macFilterEnable;
        this.policy = b2.policy;
        this.macFilterId = b2.macFilterId;
        this.ouiProfileIdList = b2.ouiProfileIdList;
        this.rateAndBeaconCtrl = b2.rateAndBeaconCtrl;
        this.ppskSetting = b2.ppskSetting;
        this.enable11r = b2.enable11r;
        this.pmfMode = b2.pmfMode;
        this.multiCastSetting = b2.multiCastSetting;
        this.greEnable = b2.greEnable;
        this.mloEnable = b2.mloEnable;
        this.dhcpOption82 = b2.dhcpOption82;
        this.hidePwd = b2.hidePwd;
        this.deviceType = b2.deviceType;
        this.wanAccess = b2.wanAccess;
        this.prohibitWifiShare = b2.prohibitWifiShare;
        this.resource = b2.resource;
        this.oweEnable = b2.oweEnable;
        this.vlanSetting = b2.vlanSetting;
        this.hotspotV2Setting = b2.hotspotV2Setting;
    }

    @Generated
    public static SsidVOBuilder<?, ?> builder() {
        return new SsidVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIdInt() {
        return this.idInt;
    }

    @Generated
    public Long getIndex() {
        return this.index;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getWlanId() {
        return this.wlanId;
    }

    @Generated
    public Integer getBand() {
        return this.band;
    }

    @Generated
    public Boolean getGuestNetEnable() {
        return this.guestNetEnable;
    }

    @Generated
    public Integer getSecurity() {
        return this.security;
    }

    @Generated
    public Boolean getBroadcast() {
        return this.broadcast;
    }

    @Deprecated
    @Generated
    public Boolean getVlanEnable() {
        return this.vlanEnable;
    }

    @Deprecated
    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Boolean getPortalEnable() {
        return this.portalEnable;
    }

    @Generated
    public String getPortalId() {
        return this.portalId;
    }

    @Generated
    public String getPortalName() {
        return this.portalName;
    }

    @Generated
    public Boolean getAccessEnable() {
        return this.accessEnable;
    }

    @Generated
    public RateLimitSettingVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public RateLimitSettingVO getSsidRateLimit() {
        return this.ssidRateLimit;
    }

    @Generated
    public WpaSettingVO getWpaSetting() {
        return this.wpaSetting;
    }

    @Generated
    public PskSettingVO getPskSetting() {
        return this.pskSetting;
    }

    @Generated
    public Boolean getWlanScheduleEnable() {
        return this.wlanScheduleEnable;
    }

    @Generated
    public Integer getAction() {
        return this.action;
    }

    @Generated
    public String getScheduleId() {
        return this.scheduleId;
    }

    @Generated
    public Integer getMacFilterType() {
        return this.macFilterType;
    }

    @Generated
    public Boolean getMacFilterEnable() {
        return this.macFilterEnable;
    }

    @Generated
    public Integer getPolicy() {
        return this.policy;
    }

    @Generated
    public String getMacFilterId() {
        return this.macFilterId;
    }

    @Generated
    public List<String> getOuiProfileIdList() {
        return this.ouiProfileIdList;
    }

    @Generated
    public RateAndBeaconCtrlVO getRateAndBeaconCtrl() {
        return this.rateAndBeaconCtrl;
    }

    @Generated
    public PPSKSettingVO getPpskSetting() {
        return this.ppskSetting;
    }

    @Generated
    public Boolean getEnable11r() {
        return this.enable11r;
    }

    @Generated
    public Integer getPmfMode() {
        return this.pmfMode;
    }

    @Generated
    public MultiCastSettingVO getMultiCastSetting() {
        return this.multiCastSetting;
    }

    @Generated
    public Boolean getGreEnable() {
        return this.greEnable;
    }

    @Generated
    public Boolean getMloEnable() {
        return this.mloEnable;
    }

    @Generated
    public DhcpOption82SettingVO getDhcpOption82() {
        return this.dhcpOption82;
    }

    @Generated
    public Boolean getHidePwd() {
        return this.hidePwd;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Boolean getWanAccess() {
        return this.wanAccess;
    }

    @Generated
    public Boolean getProhibitWifiShare() {
        return this.prohibitWifiShare;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public Boolean getOweEnable() {
        return this.oweEnable;
    }

    @Generated
    public SsidVlanSettingVO getVlanSetting() {
        return this.vlanSetting;
    }

    @Generated
    public HotspotV2SettingVO getHotspotV2Setting() {
        return this.hotspotV2Setting;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdInt(Integer idInt) {
        this.idInt = idInt;
    }

    @Generated
    public void setIndex(Long index) {
        this.index = index;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setWlanId(String wlanId) {
        this.wlanId = wlanId;
    }

    @Generated
    public void setBand(Integer band) {
        this.band = band;
    }

    @Generated
    public void setGuestNetEnable(Boolean guestNetEnable) {
        this.guestNetEnable = guestNetEnable;
    }

    @Generated
    public void setSecurity(Integer security) {
        this.security = security;
    }

    @Generated
    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Deprecated
    @Generated
    public void setVlanEnable(Boolean vlanEnable) {
        this.vlanEnable = vlanEnable;
    }

    @Deprecated
    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setPortalEnable(Boolean portalEnable) {
        this.portalEnable = portalEnable;
    }

    @Generated
    public void setPortalId(String portalId) {
        this.portalId = portalId;
    }

    @Generated
    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    @Generated
    public void setAccessEnable(Boolean accessEnable) {
        this.accessEnable = accessEnable;
    }

    @Generated
    public void setRateLimit(RateLimitSettingVO rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Generated
    public void setSsidRateLimit(RateLimitSettingVO ssidRateLimit) {
        this.ssidRateLimit = ssidRateLimit;
    }

    @Generated
    public void setWpaSetting(WpaSettingVO wpaSetting) {
        this.wpaSetting = wpaSetting;
    }

    @Generated
    public void setPskSetting(PskSettingVO pskSetting) {
        this.pskSetting = pskSetting;
    }

    @Generated
    public void setWlanScheduleEnable(Boolean wlanScheduleEnable) {
        this.wlanScheduleEnable = wlanScheduleEnable;
    }

    @Generated
    public void setAction(Integer action) {
        this.action = action;
    }

    @Generated
    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    @Generated
    public void setMacFilterType(Integer macFilterType) {
        this.macFilterType = macFilterType;
    }

    @Generated
    public void setMacFilterEnable(Boolean macFilterEnable) {
        this.macFilterEnable = macFilterEnable;
    }

    @Generated
    public void setPolicy(Integer policy) {
        this.policy = policy;
    }

    @Generated
    public void setMacFilterId(String macFilterId) {
        this.macFilterId = macFilterId;
    }

    @Generated
    public void setOuiProfileIdList(List<String> ouiProfileIdList) {
        this.ouiProfileIdList = ouiProfileIdList;
    }

    @Generated
    public void setRateAndBeaconCtrl(RateAndBeaconCtrlVO rateAndBeaconCtrl) {
        this.rateAndBeaconCtrl = rateAndBeaconCtrl;
    }

    @Generated
    public void setPpskSetting(PPSKSettingVO ppskSetting) {
        this.ppskSetting = ppskSetting;
    }

    @Generated
    public void setEnable11r(Boolean enable11r) {
        this.enable11r = enable11r;
    }

    @Generated
    public void setPmfMode(Integer pmfMode) {
        this.pmfMode = pmfMode;
    }

    @Generated
    public void setMultiCastSetting(MultiCastSettingVO multiCastSetting) {
        this.multiCastSetting = multiCastSetting;
    }

    @Generated
    public void setGreEnable(Boolean greEnable) {
        this.greEnable = greEnable;
    }

    @Generated
    public void setMloEnable(Boolean mloEnable) {
        this.mloEnable = mloEnable;
    }

    @Generated
    public void setDhcpOption82(DhcpOption82SettingVO dhcpOption82) {
        this.dhcpOption82 = dhcpOption82;
    }

    @Generated
    public void setHidePwd(Boolean hidePwd) {
        this.hidePwd = hidePwd;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setWanAccess(Boolean wanAccess) {
        this.wanAccess = wanAccess;
    }

    @Generated
    public void setProhibitWifiShare(Boolean prohibitWifiShare) {
        this.prohibitWifiShare = prohibitWifiShare;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public void setOweEnable(Boolean oweEnable) {
        this.oweEnable = oweEnable;
    }

    @Generated
    public void setVlanSetting(SsidVlanSettingVO vlanSetting) {
        this.vlanSetting = vlanSetting;
    }

    @Generated
    public void setHotspotV2Setting(HotspotV2SettingVO hotspotV2Setting) {
        this.hotspotV2Setting = hotspotV2Setting;
    }

    @Generated
    public SsidVO(String id, Integer idInt, Long index, String name, String site, String wlanId, Integer band, Boolean guestNetEnable, Integer security, Boolean broadcast, Boolean vlanEnable, Integer vlanId, Boolean portalEnable, String portalId, String portalName, Boolean accessEnable, RateLimitSettingVO rateLimit, RateLimitSettingVO ssidRateLimit, WpaSettingVO wpaSetting, PskSettingVO pskSetting, Boolean wlanScheduleEnable, Integer action, String scheduleId, Integer macFilterType, Boolean macFilterEnable, Integer policy, String macFilterId, List<String> ouiProfileIdList, RateAndBeaconCtrlVO rateAndBeaconCtrl, PPSKSettingVO ppskSetting, Boolean enable11r, Integer pmfMode, MultiCastSettingVO multiCastSetting, Boolean greEnable, Boolean mloEnable, DhcpOption82SettingVO dhcpOption82, Boolean hidePwd, Integer deviceType, Boolean wanAccess, Boolean prohibitWifiShare, Integer resource, Boolean oweEnable, SsidVlanSettingVO vlanSetting, HotspotV2SettingVO hotspotV2Setting) {
        this.id = id;
        this.idInt = idInt;
        this.index = index;
        this.name = name;
        this.site = site;
        this.wlanId = wlanId;
        this.band = band;
        this.guestNetEnable = guestNetEnable;
        this.security = security;
        this.broadcast = broadcast;
        this.vlanEnable = vlanEnable;
        this.vlanId = vlanId;
        this.portalEnable = portalEnable;
        this.portalId = portalId;
        this.portalName = portalName;
        this.accessEnable = accessEnable;
        this.rateLimit = rateLimit;
        this.ssidRateLimit = ssidRateLimit;
        this.wpaSetting = wpaSetting;
        this.pskSetting = pskSetting;
        this.wlanScheduleEnable = wlanScheduleEnable;
        this.action = action;
        this.scheduleId = scheduleId;
        this.macFilterType = macFilterType;
        this.macFilterEnable = macFilterEnable;
        this.policy = policy;
        this.macFilterId = macFilterId;
        this.ouiProfileIdList = ouiProfileIdList;
        this.rateAndBeaconCtrl = rateAndBeaconCtrl;
        this.ppskSetting = ppskSetting;
        this.enable11r = enable11r;
        this.pmfMode = pmfMode;
        this.multiCastSetting = multiCastSetting;
        this.greEnable = greEnable;
        this.mloEnable = mloEnable;
        this.dhcpOption82 = dhcpOption82;
        this.hidePwd = hidePwd;
        this.deviceType = deviceType;
        this.wanAccess = wanAccess;
        this.prohibitWifiShare = prohibitWifiShare;
        this.resource = resource;
        this.oweEnable = oweEnable;
        this.vlanSetting = vlanSetting;
        this.hotspotV2Setting = hotspotV2Setting;
    }

    @Generated
    public SsidVO() {
    }

    @Generated
    public String toString() {
        return "SsidVO(id=" + this.getId() + ", idInt=" + this.getIdInt() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", site=" + this.getSite() + ", wlanId=" + this.getWlanId() + ", band=" + this.getBand() + ", guestNetEnable=" + this.getGuestNetEnable() + ", security=" + this.getSecurity() + ", broadcast=" + this.getBroadcast() + ", vlanEnable=" + this.getVlanEnable() + ", vlanId=" + this.getVlanId() + ", portalEnable=" + this.getPortalEnable() + ", portalId=" + this.getPortalId() + ", portalName=" + this.getPortalName() + ", accessEnable=" + this.getAccessEnable() + ", rateLimit=" + this.getRateLimit() + ", ssidRateLimit=" + this.getSsidRateLimit() + ", wpaSetting=" + this.getWpaSetting() + ", pskSetting=" + this.getPskSetting() + ", wlanScheduleEnable=" + this.getWlanScheduleEnable() + ", action=" + this.getAction() + ", scheduleId=" + this.getScheduleId() + ", macFilterType=" + this.getMacFilterType() + ", macFilterEnable=" + this.getMacFilterEnable() + ", policy=" + this.getPolicy() + ", macFilterId=" + this.getMacFilterId() + ", ouiProfileIdList=" + this.getOuiProfileIdList() + ", rateAndBeaconCtrl=" + this.getRateAndBeaconCtrl() + ", ppskSetting=" + this.getPpskSetting() + ", enable11r=" + this.getEnable11r() + ", pmfMode=" + this.getPmfMode() + ", multiCastSetting=" + this.getMultiCastSetting() + ", greEnable=" + this.getGreEnable() + ", mloEnable=" + this.getMloEnable() + ", dhcpOption82=" + this.getDhcpOption82() + ", hidePwd=" + this.getHidePwd() + ", deviceType=" + this.getDeviceType() + ", wanAccess=" + this.getWanAccess() + ", prohibitWifiShare=" + this.getProhibitWifiShare() + ", resource=" + this.getResource() + ", oweEnable=" + this.getOweEnable() + ", vlanSetting=" + this.getVlanSetting() + ", hotspotV2Setting=" + this.getHotspotV2Setting() + ")";
    }

    @Generated
    public static abstract class SsidVOBuilder<C extends SsidVO, B extends SsidVOBuilder<C, B>>
    extends b.a<C, B> {
        @Generated
        private String id;
        @Generated
        private Integer idInt;
        @Generated
        private Long index;
        @Generated
        private String name;
        @Generated
        private String site;
        @Generated
        private String wlanId;
        @Generated
        private Integer band;
        @Generated
        private Boolean guestNetEnable;
        @Generated
        private Integer security;
        @Generated
        private Boolean broadcast;
        @Generated
        private Boolean vlanEnable;
        @Generated
        private Integer vlanId;
        @Generated
        private Boolean portalEnable;
        @Generated
        private String portalId;
        @Generated
        private String portalName;
        @Generated
        private Boolean accessEnable;
        @Generated
        private RateLimitSettingVO rateLimit;
        @Generated
        private RateLimitSettingVO ssidRateLimit;
        @Generated
        private WpaSettingVO wpaSetting;
        @Generated
        private PskSettingVO pskSetting;
        @Generated
        private Boolean wlanScheduleEnable;
        @Generated
        private Integer action;
        @Generated
        private String scheduleId;
        @Generated
        private Integer macFilterType;
        @Generated
        private Boolean macFilterEnable;
        @Generated
        private Integer policy;
        @Generated
        private String macFilterId;
        @Generated
        private List<String> ouiProfileIdList;
        @Generated
        private RateAndBeaconCtrlVO rateAndBeaconCtrl;
        @Generated
        private PPSKSettingVO ppskSetting;
        @Generated
        private Boolean enable11r;
        @Generated
        private Integer pmfMode;
        @Generated
        private MultiCastSettingVO multiCastSetting;
        @Generated
        private Boolean greEnable;
        @Generated
        private Boolean mloEnable;
        @Generated
        private DhcpOption82SettingVO dhcpOption82;
        @Generated
        private Boolean hidePwd;
        @Generated
        private Integer deviceType;
        @Generated
        private Boolean wanAccess;
        @Generated
        private Boolean prohibitWifiShare;
        @Generated
        private Integer resource;
        @Generated
        private Boolean oweEnable;
        @Generated
        private SsidVlanSettingVO vlanSetting;
        @Generated
        private HotspotV2SettingVO hotspotV2Setting;

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B idInt(Integer idInt) {
            this.idInt = idInt;
            return (B)this.self();
        }

        @Generated
        public B index(Long index) {
            this.index = index;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B site(String site) {
            this.site = site;
            return (B)this.self();
        }

        @Generated
        public B wlanId(String wlanId) {
            this.wlanId = wlanId;
            return (B)this.self();
        }

        @Generated
        public B band(Integer band) {
            this.band = band;
            return (B)this.self();
        }

        @Generated
        public B guestNetEnable(Boolean guestNetEnable) {
            this.guestNetEnable = guestNetEnable;
            return (B)this.self();
        }

        @Generated
        public B security(Integer security) {
            this.security = security;
            return (B)this.self();
        }

        @Generated
        public B broadcast(Boolean broadcast) {
            this.broadcast = broadcast;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B vlanEnable(Boolean vlanEnable) {
            this.vlanEnable = vlanEnable;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return (B)this.self();
        }

        @Generated
        public B portalEnable(Boolean portalEnable) {
            this.portalEnable = portalEnable;
            return (B)this.self();
        }

        @Generated
        public B portalId(String portalId) {
            this.portalId = portalId;
            return (B)this.self();
        }

        @Generated
        public B portalName(String portalName) {
            this.portalName = portalName;
            return (B)this.self();
        }

        @Generated
        public B accessEnable(Boolean accessEnable) {
            this.accessEnable = accessEnable;
            return (B)this.self();
        }

        @Generated
        public B rateLimit(RateLimitSettingVO rateLimit) {
            this.rateLimit = rateLimit;
            return (B)this.self();
        }

        @Generated
        public B ssidRateLimit(RateLimitSettingVO ssidRateLimit) {
            this.ssidRateLimit = ssidRateLimit;
            return (B)this.self();
        }

        @Generated
        public B wpaSetting(WpaSettingVO wpaSetting) {
            this.wpaSetting = wpaSetting;
            return (B)this.self();
        }

        @Generated
        public B pskSetting(PskSettingVO pskSetting) {
            this.pskSetting = pskSetting;
            return (B)this.self();
        }

        @Generated
        public B wlanScheduleEnable(Boolean wlanScheduleEnable) {
            this.wlanScheduleEnable = wlanScheduleEnable;
            return (B)this.self();
        }

        @Generated
        public B action(Integer action) {
            this.action = action;
            return (B)this.self();
        }

        @Generated
        public B scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return (B)this.self();
        }

        @Generated
        public B macFilterType(Integer macFilterType) {
            this.macFilterType = macFilterType;
            return (B)this.self();
        }

        @Generated
        public B macFilterEnable(Boolean macFilterEnable) {
            this.macFilterEnable = macFilterEnable;
            return (B)this.self();
        }

        @Generated
        public B policy(Integer policy) {
            this.policy = policy;
            return (B)this.self();
        }

        @Generated
        public B macFilterId(String macFilterId) {
            this.macFilterId = macFilterId;
            return (B)this.self();
        }

        @Generated
        public B ouiProfileIdList(List<String> ouiProfileIdList) {
            this.ouiProfileIdList = ouiProfileIdList;
            return (B)this.self();
        }

        @Generated
        public B rateAndBeaconCtrl(RateAndBeaconCtrlVO rateAndBeaconCtrl) {
            this.rateAndBeaconCtrl = rateAndBeaconCtrl;
            return (B)this.self();
        }

        @Generated
        public B ppskSetting(PPSKSettingVO ppskSetting) {
            this.ppskSetting = ppskSetting;
            return (B)this.self();
        }

        @Generated
        public B enable11r(Boolean enable11r) {
            this.enable11r = enable11r;
            return (B)this.self();
        }

        @Generated
        public B pmfMode(Integer pmfMode) {
            this.pmfMode = pmfMode;
            return (B)this.self();
        }

        @Generated
        public B multiCastSetting(MultiCastSettingVO multiCastSetting) {
            this.multiCastSetting = multiCastSetting;
            return (B)this.self();
        }

        @Generated
        public B greEnable(Boolean greEnable) {
            this.greEnable = greEnable;
            return (B)this.self();
        }

        @Generated
        public B mloEnable(Boolean mloEnable) {
            this.mloEnable = mloEnable;
            return (B)this.self();
        }

        @Generated
        public B dhcpOption82(DhcpOption82SettingVO dhcpOption82) {
            this.dhcpOption82 = dhcpOption82;
            return (B)this.self();
        }

        @Generated
        public B hidePwd(Boolean hidePwd) {
            this.hidePwd = hidePwd;
            return (B)this.self();
        }

        @Generated
        public B deviceType(Integer deviceType) {
            this.deviceType = deviceType;
            return (B)this.self();
        }

        @Generated
        public B wanAccess(Boolean wanAccess) {
            this.wanAccess = wanAccess;
            return (B)this.self();
        }

        @Generated
        public B prohibitWifiShare(Boolean prohibitWifiShare) {
            this.prohibitWifiShare = prohibitWifiShare;
            return (B)this.self();
        }

        @Generated
        public B resource(Integer resource) {
            this.resource = resource;
            return (B)this.self();
        }

        @Generated
        public B oweEnable(Boolean oweEnable) {
            this.oweEnable = oweEnable;
            return (B)this.self();
        }

        @Generated
        public B vlanSetting(SsidVlanSettingVO vlanSetting) {
            this.vlanSetting = vlanSetting;
            return (B)this.self();
        }

        @Generated
        public B hotspotV2Setting(HotspotV2SettingVO hotspotV2Setting) {
            this.hotspotV2Setting = hotspotV2Setting;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SsidVO.SsidVOBuilder(super=" + super.toString() + ", id=" + this.id + ", idInt=" + this.idInt + ", index=" + this.index + ", name=" + this.name + ", site=" + this.site + ", wlanId=" + this.wlanId + ", band=" + this.band + ", guestNetEnable=" + this.guestNetEnable + ", security=" + this.security + ", broadcast=" + this.broadcast + ", vlanEnable=" + this.vlanEnable + ", vlanId=" + this.vlanId + ", portalEnable=" + this.portalEnable + ", portalId=" + this.portalId + ", portalName=" + this.portalName + ", accessEnable=" + this.accessEnable + ", rateLimit=" + this.rateLimit + ", ssidRateLimit=" + this.ssidRateLimit + ", wpaSetting=" + this.wpaSetting + ", pskSetting=" + this.pskSetting + ", wlanScheduleEnable=" + this.wlanScheduleEnable + ", action=" + this.action + ", scheduleId=" + this.scheduleId + ", macFilterType=" + this.macFilterType + ", macFilterEnable=" + this.macFilterEnable + ", policy=" + this.policy + ", macFilterId=" + this.macFilterId + ", ouiProfileIdList=" + this.ouiProfileIdList + ", rateAndBeaconCtrl=" + this.rateAndBeaconCtrl + ", ppskSetting=" + this.ppskSetting + ", enable11r=" + this.enable11r + ", pmfMode=" + this.pmfMode + ", multiCastSetting=" + this.multiCastSetting + ", greEnable=" + this.greEnable + ", mloEnable=" + this.mloEnable + ", dhcpOption82=" + this.dhcpOption82 + ", hidePwd=" + this.hidePwd + ", deviceType=" + this.deviceType + ", wanAccess=" + this.wanAccess + ", prohibitWifiShare=" + this.prohibitWifiShare + ", resource=" + this.resource + ", oweEnable=" + this.oweEnable + ", vlanSetting=" + this.vlanSetting + ", hotspotV2Setting=" + this.hotspotV2Setting + ")";
        }
    }

    @Generated
    private static final class SsidVOBuilderImpl
    extends SsidVOBuilder<SsidVO, SsidVOBuilderImpl> {
        @Generated
        private SsidVOBuilderImpl() {
        }

        @Override
        @Generated
        protected SsidVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SsidVO build() {
            return new SsidVO(this);
        }
    }
}

