/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.BandCtrlVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.DhcpL2RelayVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.StormCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class LanProfileVO {
    private String id;
    private String site;
    private Integer flag;
    private Boolean prohibitModify;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Range(min=0L, max=2L, message="Value of poe is from 0 to 2.")
    private @NotNull @Range(min=0L, max=2L, message="Value of poe is from 0 to 2.") Integer poe;
    private String nativeNetworkId;
    private Integer nativeBridgeVlan;
    private List<String> tagNetworkIds;
    private Map<String, Set<Integer>> tagBridgeVlanMap;
    private List<String> esEnableTaggedNetworkIds;
    private List<String> untagNetworkIds;
    private Map<String, Set<Integer>> untagBridgeVlanMap;
    private Boolean voiceNetworkEnable;
    private String voiceNetworkId;
    private Integer voiceBridgeVlan;
    @Range(min=0L, max=63L, message="Value of voice DSCP is from 0 to 63.")
    private @Range(min=0L, max=63L, message="Value of voice DSCP is from 0 to 63.") Integer voiceDscp;
    @Range(min=0L, max=2L, message="Value of dot1x is from 0 to 2.")
    private @Range(min=0L, max=2L, message="Value of dot1x is from 0 to 2.") Integer dot1x;
    @NotNull
    private Boolean portIsolationEnable;
    private Boolean lldpMedEnable;
    private Boolean topoNotifyEnable;
    @NotNull
    @Range(min=0L, max=2L)
    private @NotNull @Range(min=0L, max=2L) Integer bandWidthCtrlType;
    @Valid
    private StormCtrlVO stormCtrl;
    @Valid
    private BandCtrlVO bandCtrl;
    @NotNull
    private Boolean spanningTreeEnable;
    @Valid
    private SpanningTreeSettingVO spanningTreeSetting;
    @NotNull
    private Boolean loopbackDetectEnable;
    private Boolean eeeEnable;
    private Boolean flowControlEnable;
    private Boolean fastLeaveEnable;
    private Boolean loopbackDetectVlanBasedEnable;
    private Boolean igmpFastLeaveEnable;
    private Boolean mldFastLeaveEnable;
    private DhcpL2RelayVO dhcpL2RelaySettings;
    @Range(min=0L, max=7L)
    @Nullable
    private @Range(min=0L, max=7L) Integer dot1pPriority;
    @Nullable
    private Integer trustMode;
    @Deprecated
    private Integer queueId;
    private Integer type;
    private Boolean supportESEnable;
    private Boolean esEnable;
    private Boolean esTaggedModified;
    private List<String> validVlans;
    private Boolean modifyAllProfileEsEnableOnly;
    private Boolean createByNewUI;
    private Boolean networkConflict;
    private Integer resource;
    public static final String BRIDGE_VLAN_SEPARATOR = "_";

    public void transformBridgeVlanId() {
        this.transformBridgeVlan();
        if (!CollectionUtils.isEmpty(this.getTagNetworkIds())) {
            this.tagBridgeVlanMap = this.transformBridgeVlanMap(this.getTagNetworkIds());
        }
        if (!CollectionUtils.isEmpty(this.getUntagNetworkIds())) {
            this.untagBridgeVlanMap = this.transformBridgeVlanMap(this.getUntagNetworkIds());
        }
    }

    public Set<String> getNetworkIdsAndBridgeVlan(Boolean esAllProfile) {
        HashSet<String> networkSet = new HashSet<String>();
        Optional.ofNullable(this.untagNetworkIds).ifPresent(networkSet::addAll);
        if (!esAllProfile.booleanValue()) {
            Optional.ofNullable(this.tagNetworkIds).ifPresent(networkSet::addAll);
        } else {
            Optional.ofNullable(this.esEnableTaggedNetworkIds).ifPresent(idVlans -> {
                for (String idVlan : idVlans) {
                    if (idVlan.contains(BRIDGE_VLAN_SEPARATOR)) {
                        networkSet.add(idVlan.split(BRIDGE_VLAN_SEPARATOR)[1]);
                        continue;
                    }
                    networkSet.add(idVlan);
                }
            });
        }
        Optional.ofNullable(this.nativeNetworkId).ifPresent(networkSet::add);
        Optional.ofNullable(this.untagBridgeVlanMap).ifPresent(map -> map.forEach((networkId, bridgeVlanIdSet) -> {
            networkSet.remove(networkId);
            networkSet.addAll(bridgeVlanIdSet.stream().map(String::valueOf).collect(Collectors.toSet()));
        }));
        if (!esAllProfile.booleanValue()) {
            Optional.ofNullable(this.tagBridgeVlanMap).ifPresent(map -> map.forEach((networkId, bridgeVlanIdSet) -> {
                networkSet.remove(networkId);
                networkSet.addAll(bridgeVlanIdSet.stream().map(String::valueOf).collect(Collectors.toSet()));
            }));
        }
        Optional.ofNullable(this.nativeBridgeVlan).ifPresent(vlan -> {
            networkSet.remove(this.nativeNetworkId);
            networkSet.add(String.valueOf(vlan));
        });
        return networkSet;
    }

    private void transformBridgeVlan() {
        Integer vlan;
        String[] splits;
        if (this.getNativeNetworkId() != null && this.getNativeNetworkId().contains(BRIDGE_VLAN_SEPARATOR)) {
            splits = this.getNativeNetworkId().split(BRIDGE_VLAN_SEPARATOR);
            vlan = Integer.parseInt(splits[1]);
            this.nativeNetworkId = splits[0];
            this.nativeBridgeVlan = vlan;
        }
        if (this.getVoiceNetworkId() != null && this.getVoiceNetworkId().contains(BRIDGE_VLAN_SEPARATOR)) {
            splits = this.getVoiceNetworkId().split(BRIDGE_VLAN_SEPARATOR);
            vlan = Integer.parseInt(splits[1]);
            this.voiceNetworkId = splits[0];
            this.voiceBridgeVlan = vlan;
        }
    }

    private Map<String, Set<Integer>> transformBridgeVlanMap(List<String> networkIdsWithVlan) {
        HashMap<String, Set<Integer>> bridgeVlanMap = new HashMap<String, Set<Integer>>(networkIdsWithVlan.size());
        networkIdsWithVlan.removeIf(netId -> {
            if (netId.contains(BRIDGE_VLAN_SEPARATOR)) {
                String[] splits = netId.split(BRIDGE_VLAN_SEPARATOR);
                this.addBridgeVlanMap(splits, bridgeVlanMap);
                return true;
            }
            return false;
        });
        networkIdsWithVlan.addAll(bridgeVlanMap.keySet());
        return bridgeVlanMap;
    }

    private void addBridgeVlanMap(String[] splits, Map<String, Set<Integer>> bridgeVlanMap) {
        Integer vlan = Integer.parseInt(splits[1]);
        if (null == bridgeVlanMap.computeIfPresent(splits[0], (netId, vlans) -> {
            vlans.add(vlan);
            return vlans;
        })) {
            bridgeVlanMap.put(splits[0], Sets.newHashSet((Object[])new Integer[]{vlan}));
        }
    }

    public LanProfileVO clearExtraParam() {
        this.setType(null);
        this.setFlag(null);
        this.setResource(null);
        if (Objects.equals(0, this.getBandWidthCtrlType())) {
            this.setStormCtrl(null);
            this.setBandCtrl(null);
        } else if (Objects.equals(1, this.getBandWidthCtrlType())) {
            this.setStormCtrl(null);
        } else if (Objects.equals(2, this.getBandWidthCtrlType())) {
            this.setBandCtrl(null);
        }
        this.setTagBridgeVlanMap(null);
        this.setUntagBridgeVlanMap(null);
        return this;
    }

    public static LanProfileVO clone(LanProfileVO lanProfileVO) {
        LanProfileVO newLanProfileVO = new LanProfileVO();
        newLanProfileVO.setId(lanProfileVO.getId());
        newLanProfileVO.setSite(lanProfileVO.getSite());
        newLanProfileVO.setFlag(lanProfileVO.getFlag());
        newLanProfileVO.setName(lanProfileVO.getName());
        newLanProfileVO.setPoe(lanProfileVO.getPoe());
        newLanProfileVO.setNativeNetworkId(lanProfileVO.getNativeNetworkId());
        newLanProfileVO.setNativeBridgeVlan(lanProfileVO.getNativeBridgeVlan());
        newLanProfileVO.setTagNetworkIds(lanProfileVO.getTagNetworkIds());
        newLanProfileVO.setTagBridgeVlanMap(lanProfileVO.getTagBridgeVlanMap());
        newLanProfileVO.setEsEnableTaggedNetworkIds(lanProfileVO.getEsEnableTaggedNetworkIds());
        newLanProfileVO.setUntagNetworkIds(lanProfileVO.getUntagNetworkIds());
        newLanProfileVO.setUntagBridgeVlanMap(lanProfileVO.getUntagBridgeVlanMap());
        newLanProfileVO.setVoiceNetworkId(lanProfileVO.getVoiceNetworkId());
        newLanProfileVO.setVoiceBridgeVlan(lanProfileVO.getVoiceBridgeVlan());
        newLanProfileVO.setDot1x(lanProfileVO.getDot1x());
        newLanProfileVO.setPortIsolationEnable(lanProfileVO.getPortIsolationEnable());
        newLanProfileVO.setLldpMedEnable(lanProfileVO.getLldpMedEnable());
        newLanProfileVO.setTopoNotifyEnable(lanProfileVO.getTopoNotifyEnable());
        newLanProfileVO.setBandWidthCtrlType(lanProfileVO.getBandWidthCtrlType());
        newLanProfileVO.setStormCtrl(lanProfileVO.getStormCtrl());
        newLanProfileVO.setBandCtrl(lanProfileVO.getBandCtrl());
        newLanProfileVO.setSpanningTreeEnable(lanProfileVO.getSpanningTreeEnable());
        newLanProfileVO.setSpanningTreeSetting(lanProfileVO.getSpanningTreeSetting());
        newLanProfileVO.setLoopbackDetectEnable(lanProfileVO.getLoopbackDetectEnable());
        newLanProfileVO.setIgmpFastLeaveEnable(lanProfileVO.getIgmpFastLeaveEnable());
        newLanProfileVO.setMldFastLeaveEnable(lanProfileVO.getMldFastLeaveEnable());
        newLanProfileVO.setEeeEnable(lanProfileVO.getEeeEnable());
        newLanProfileVO.setFlowControlEnable(lanProfileVO.getFlowControlEnable());
        newLanProfileVO.setFastLeaveEnable(lanProfileVO.getFastLeaveEnable());
        newLanProfileVO.setLoopbackDetectVlanBasedEnable(lanProfileVO.getLoopbackDetectVlanBasedEnable());
        newLanProfileVO.setDhcpL2RelaySettings(lanProfileVO.getDhcpL2RelaySettings());
        newLanProfileVO.setDot1pPriority(lanProfileVO.getDot1pPriority());
        newLanProfileVO.setTrustMode(lanProfileVO.getTrustMode());
        newLanProfileVO.setEsEnable(Boolean.TRUE.equals(lanProfileVO.getEsEnable()));
        newLanProfileVO.setModifyAllProfileEsEnableOnly(Boolean.TRUE.equals(lanProfileVO.getModifyAllProfileEsEnableOnly()));
        newLanProfileVO.setType(lanProfileVO.getType());
        newLanProfileVO.setResource(lanProfileVO.getResource());
        return newLanProfileVO;
    }

    public void fillDefaultValue() {
        if (this.getDot1x() == null) {
            this.setDot1x(2);
        }
        if (this.getLldpMedEnable() == null) {
            this.setLldpMedEnable(true);
        }
    }

    public void transformTagBridgeNetworkId(String networkId, Set<Integer> vlans) {
        for (Integer vlan : vlans) {
            this.tagNetworkIds.add(networkId + BRIDGE_VLAN_SEPARATOR + vlan);
        }
    }

    public void transformUnTagBridgeNetworkId(String networkId, Set<Integer> vlans) {
        for (Integer vlan : vlans) {
            this.untagNetworkIds.add(networkId + BRIDGE_VLAN_SEPARATOR + vlan);
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public Integer getFlag() {
        return this.flag;
    }

    @Generated
    public Boolean getProhibitModify() {
        return this.prohibitModify;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPoe() {
        return this.poe;
    }

    @Generated
    public String getNativeNetworkId() {
        return this.nativeNetworkId;
    }

    @Generated
    public Integer getNativeBridgeVlan() {
        return this.nativeBridgeVlan;
    }

    @Generated
    public List<String> getTagNetworkIds() {
        return this.tagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getTagBridgeVlanMap() {
        return this.tagBridgeVlanMap;
    }

    @Generated
    public List<String> getEsEnableTaggedNetworkIds() {
        return this.esEnableTaggedNetworkIds;
    }

    @Generated
    public List<String> getUntagNetworkIds() {
        return this.untagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getUntagBridgeVlanMap() {
        return this.untagBridgeVlanMap;
    }

    @Generated
    public Boolean getVoiceNetworkEnable() {
        return this.voiceNetworkEnable;
    }

    @Generated
    public String getVoiceNetworkId() {
        return this.voiceNetworkId;
    }

    @Generated
    public Integer getVoiceBridgeVlan() {
        return this.voiceBridgeVlan;
    }

    @Generated
    public Integer getVoiceDscp() {
        return this.voiceDscp;
    }

    @Generated
    public Integer getDot1x() {
        return this.dot1x;
    }

    @Generated
    public Boolean getPortIsolationEnable() {
        return this.portIsolationEnable;
    }

    @Generated
    public Boolean getLldpMedEnable() {
        return this.lldpMedEnable;
    }

    @Generated
    public Boolean getTopoNotifyEnable() {
        return this.topoNotifyEnable;
    }

    @Generated
    public Integer getBandWidthCtrlType() {
        return this.bandWidthCtrlType;
    }

    @Generated
    public StormCtrlVO getStormCtrl() {
        return this.stormCtrl;
    }

    @Generated
    public BandCtrlVO getBandCtrl() {
        return this.bandCtrl;
    }

    @Generated
    public Boolean getSpanningTreeEnable() {
        return this.spanningTreeEnable;
    }

    @Generated
    public SpanningTreeSettingVO getSpanningTreeSetting() {
        return this.spanningTreeSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Boolean getEeeEnable() {
        return this.eeeEnable;
    }

    @Generated
    public Boolean getFlowControlEnable() {
        return this.flowControlEnable;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public Boolean getLoopbackDetectVlanBasedEnable() {
        return this.loopbackDetectVlanBasedEnable;
    }

    @Generated
    public Boolean getIgmpFastLeaveEnable() {
        return this.igmpFastLeaveEnable;
    }

    @Generated
    public Boolean getMldFastLeaveEnable() {
        return this.mldFastLeaveEnable;
    }

    @Generated
    public DhcpL2RelayVO getDhcpL2RelaySettings() {
        return this.dhcpL2RelaySettings;
    }

    @Nullable
    @Generated
    public Integer getDot1pPriority() {
        return this.dot1pPriority;
    }

    @Nullable
    @Generated
    public Integer getTrustMode() {
        return this.trustMode;
    }

    @Deprecated
    @Generated
    public Integer getQueueId() {
        return this.queueId;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Boolean getSupportESEnable() {
        return this.supportESEnable;
    }

    @Generated
    public Boolean getEsEnable() {
        return this.esEnable;
    }

    @Generated
    public Boolean getEsTaggedModified() {
        return this.esTaggedModified;
    }

    @Generated
    public List<String> getValidVlans() {
        return this.validVlans;
    }

    @Generated
    public Boolean getModifyAllProfileEsEnableOnly() {
        return this.modifyAllProfileEsEnableOnly;
    }

    @Generated
    public Boolean getCreateByNewUI() {
        return this.createByNewUI;
    }

    @Generated
    public Boolean getNetworkConflict() {
        return this.networkConflict;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public LanProfileVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public LanProfileVO setSite(String site) {
        this.site = site;
        return this;
    }

    @Generated
    public LanProfileVO setFlag(Integer flag) {
        this.flag = flag;
        return this;
    }

    @Generated
    public LanProfileVO setProhibitModify(Boolean prohibitModify) {
        this.prohibitModify = prohibitModify;
        return this;
    }

    @Generated
    public LanProfileVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public LanProfileVO setPoe(Integer poe) {
        this.poe = poe;
        return this;
    }

    @Generated
    public LanProfileVO setNativeNetworkId(String nativeNetworkId) {
        this.nativeNetworkId = nativeNetworkId;
        return this;
    }

    @Generated
    public LanProfileVO setNativeBridgeVlan(Integer nativeBridgeVlan) {
        this.nativeBridgeVlan = nativeBridgeVlan;
        return this;
    }

    @Generated
    public LanProfileVO setTagNetworkIds(List<String> tagNetworkIds) {
        this.tagNetworkIds = tagNetworkIds;
        return this;
    }

    @Generated
    public LanProfileVO setTagBridgeVlanMap(Map<String, Set<Integer>> tagBridgeVlanMap) {
        this.tagBridgeVlanMap = tagBridgeVlanMap;
        return this;
    }

    @Generated
    public LanProfileVO setEsEnableTaggedNetworkIds(List<String> esEnableTaggedNetworkIds) {
        this.esEnableTaggedNetworkIds = esEnableTaggedNetworkIds;
        return this;
    }

    @Generated
    public LanProfileVO setUntagNetworkIds(List<String> untagNetworkIds) {
        this.untagNetworkIds = untagNetworkIds;
        return this;
    }

    @Generated
    public LanProfileVO setUntagBridgeVlanMap(Map<String, Set<Integer>> untagBridgeVlanMap) {
        this.untagBridgeVlanMap = untagBridgeVlanMap;
        return this;
    }

    @Generated
    public LanProfileVO setVoiceNetworkEnable(Boolean voiceNetworkEnable) {
        this.voiceNetworkEnable = voiceNetworkEnable;
        return this;
    }

    @Generated
    public LanProfileVO setVoiceNetworkId(String voiceNetworkId) {
        this.voiceNetworkId = voiceNetworkId;
        return this;
    }

    @Generated
    public LanProfileVO setVoiceBridgeVlan(Integer voiceBridgeVlan) {
        this.voiceBridgeVlan = voiceBridgeVlan;
        return this;
    }

    @Generated
    public LanProfileVO setVoiceDscp(Integer voiceDscp) {
        this.voiceDscp = voiceDscp;
        return this;
    }

    @Generated
    public LanProfileVO setDot1x(Integer dot1x) {
        this.dot1x = dot1x;
        return this;
    }

    @Generated
    public LanProfileVO setPortIsolationEnable(Boolean portIsolationEnable) {
        this.portIsolationEnable = portIsolationEnable;
        return this;
    }

    @Generated
    public LanProfileVO setLldpMedEnable(Boolean lldpMedEnable) {
        this.lldpMedEnable = lldpMedEnable;
        return this;
    }

    @Generated
    public LanProfileVO setTopoNotifyEnable(Boolean topoNotifyEnable) {
        this.topoNotifyEnable = topoNotifyEnable;
        return this;
    }

    @Generated
    public LanProfileVO setBandWidthCtrlType(Integer bandWidthCtrlType) {
        this.bandWidthCtrlType = bandWidthCtrlType;
        return this;
    }

    @Generated
    public LanProfileVO setStormCtrl(StormCtrlVO stormCtrl) {
        this.stormCtrl = stormCtrl;
        return this;
    }

    @Generated
    public LanProfileVO setBandCtrl(BandCtrlVO bandCtrl) {
        this.bandCtrl = bandCtrl;
        return this;
    }

    @Generated
    public LanProfileVO setSpanningTreeEnable(Boolean spanningTreeEnable) {
        this.spanningTreeEnable = spanningTreeEnable;
        return this;
    }

    @Generated
    public LanProfileVO setSpanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
        this.spanningTreeSetting = spanningTreeSetting;
        return this;
    }

    @Generated
    public LanProfileVO setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
        return this;
    }

    @Generated
    public LanProfileVO setEeeEnable(Boolean eeeEnable) {
        this.eeeEnable = eeeEnable;
        return this;
    }

    @Generated
    public LanProfileVO setFlowControlEnable(Boolean flowControlEnable) {
        this.flowControlEnable = flowControlEnable;
        return this;
    }

    @Generated
    public LanProfileVO setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
        return this;
    }

    @Generated
    public LanProfileVO setLoopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
        return this;
    }

    @Generated
    public LanProfileVO setIgmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
        return this;
    }

    @Generated
    public LanProfileVO setMldFastLeaveEnable(Boolean mldFastLeaveEnable) {
        this.mldFastLeaveEnable = mldFastLeaveEnable;
        return this;
    }

    @Generated
    public LanProfileVO setDhcpL2RelaySettings(DhcpL2RelayVO dhcpL2RelaySettings) {
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
        return this;
    }

    @Generated
    public LanProfileVO setDot1pPriority(@Nullable Integer dot1pPriority) {
        this.dot1pPriority = dot1pPriority;
        return this;
    }

    @Generated
    public LanProfileVO setTrustMode(@Nullable Integer trustMode) {
        this.trustMode = trustMode;
        return this;
    }

    @Deprecated
    @Generated
    public LanProfileVO setQueueId(Integer queueId) {
        this.queueId = queueId;
        return this;
    }

    @Generated
    public LanProfileVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public LanProfileVO setSupportESEnable(Boolean supportESEnable) {
        this.supportESEnable = supportESEnable;
        return this;
    }

    @Generated
    public LanProfileVO setEsEnable(Boolean esEnable) {
        this.esEnable = esEnable;
        return this;
    }

    @Generated
    public LanProfileVO setEsTaggedModified(Boolean esTaggedModified) {
        this.esTaggedModified = esTaggedModified;
        return this;
    }

    @Generated
    public LanProfileVO setValidVlans(List<String> validVlans) {
        this.validVlans = validVlans;
        return this;
    }

    @Generated
    public LanProfileVO setModifyAllProfileEsEnableOnly(Boolean modifyAllProfileEsEnableOnly) {
        this.modifyAllProfileEsEnableOnly = modifyAllProfileEsEnableOnly;
        return this;
    }

    @Generated
    public LanProfileVO setCreateByNewUI(Boolean createByNewUI) {
        this.createByNewUI = createByNewUI;
        return this;
    }

    @Generated
    public LanProfileVO setNetworkConflict(Boolean networkConflict) {
        this.networkConflict = networkConflict;
        return this;
    }

    @Generated
    public LanProfileVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public String toString() {
        return "LanProfileVO(id=" + this.getId() + ", site=" + this.getSite() + ", flag=" + this.getFlag() + ", prohibitModify=" + this.getProhibitModify() + ", name=" + this.getName() + ", poe=" + this.getPoe() + ", nativeNetworkId=" + this.getNativeNetworkId() + ", nativeBridgeVlan=" + this.getNativeBridgeVlan() + ", tagNetworkIds=" + this.getTagNetworkIds() + ", tagBridgeVlanMap=" + this.getTagBridgeVlanMap() + ", esEnableTaggedNetworkIds=" + this.getEsEnableTaggedNetworkIds() + ", untagNetworkIds=" + this.getUntagNetworkIds() + ", untagBridgeVlanMap=" + this.getUntagBridgeVlanMap() + ", voiceNetworkEnable=" + this.getVoiceNetworkEnable() + ", voiceNetworkId=" + this.getVoiceNetworkId() + ", voiceBridgeVlan=" + this.getVoiceBridgeVlan() + ", voiceDscp=" + this.getVoiceDscp() + ", dot1x=" + this.getDot1x() + ", portIsolationEnable=" + this.getPortIsolationEnable() + ", lldpMedEnable=" + this.getLldpMedEnable() + ", topoNotifyEnable=" + this.getTopoNotifyEnable() + ", bandWidthCtrlType=" + this.getBandWidthCtrlType() + ", stormCtrl=" + this.getStormCtrl() + ", bandCtrl=" + this.getBandCtrl() + ", spanningTreeEnable=" + this.getSpanningTreeEnable() + ", spanningTreeSetting=" + this.getSpanningTreeSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", eeeEnable=" + this.getEeeEnable() + ", flowControlEnable=" + this.getFlowControlEnable() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", loopbackDetectVlanBasedEnable=" + this.getLoopbackDetectVlanBasedEnable() + ", igmpFastLeaveEnable=" + this.getIgmpFastLeaveEnable() + ", mldFastLeaveEnable=" + this.getMldFastLeaveEnable() + ", dhcpL2RelaySettings=" + this.getDhcpL2RelaySettings() + ", dot1pPriority=" + this.getDot1pPriority() + ", trustMode=" + this.getTrustMode() + ", queueId=" + this.getQueueId() + ", type=" + this.getType() + ", supportESEnable=" + this.getSupportESEnable() + ", esEnable=" + this.getEsEnable() + ", esTaggedModified=" + this.getEsTaggedModified() + ", validVlans=" + this.getValidVlans() + ", modifyAllProfileEsEnableOnly=" + this.getModifyAllProfileEsEnableOnly() + ", createByNewUI=" + this.getCreateByNewUI() + ", networkConflict=" + this.getNetworkConflict() + ", resource=" + this.getResource() + ")";
    }
}

