/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork;

import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

public class VlanLanNetworkVO {
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    private String site;
    @NotNull(message="Parameter [vlan] should not be null.")
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    private @NotNull(message="Parameter [vlan] should not be null.") @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    private Boolean dhcpL2RelayEnable;
    @Valid
    private DhcpGuardVO dhcpGuard;
    private Boolean mldSnoopEnable;
    private Dhcpv6GuardVO dhcpv6Guard;
    private List<String> interfaceIds;
    private Integer application;
    private Boolean qosQueueEnable;
    private Integer queueId;

    public static VlanLanNetworkVO createDefault(String name, String vlans) {
        VlanLanNetworkVO vlanLanNetworkVO = new VlanLanNetworkVO();
        vlanLanNetworkVO.setName(name);
        vlanLanNetworkVO.setVlans(vlans);
        vlanLanNetworkVO.setApplication(1);
        vlanLanNetworkVO.setIgmpSnoopEnable(false);
        vlanLanNetworkVO.setMldSnoopEnable(false);
        vlanLanNetworkVO.setQosQueueEnable(false);
        vlanLanNetworkVO.setDhcpL2RelayEnable(false);
        vlanLanNetworkVO.setDhcpGuard(new DhcpGuardVO().setEnable(false));
        vlanLanNetworkVO.setDhcpv6Guard(new Dhcpv6GuardVO().setEnable(false));
        return vlanLanNetworkVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Dhcpv6GuardVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public List<String> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Generated
    public Integer getApplication() {
        return this.application;
    }

    @Generated
    public Boolean getQosQueueEnable() {
        return this.qosQueueEnable;
    }

    @Generated
    public Integer getQueueId() {
        return this.queueId;
    }

    @Generated
    public VlanLanNetworkVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setSite(String site) {
        this.site = site;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setVlans(String vlans) {
        this.vlans = vlans;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setDhcpGuard(DhcpGuardVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setDhcpv6Guard(Dhcpv6GuardVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setInterfaceIds(List<String> interfaceIds) {
        this.interfaceIds = interfaceIds;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setApplication(Integer application) {
        this.application = application;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setQosQueueEnable(Boolean qosQueueEnable) {
        this.qosQueueEnable = qosQueueEnable;
        return this;
    }

    @Generated
    public VlanLanNetworkVO setQueueId(Integer queueId) {
        this.queueId = queueId;
        return this;
    }

    @Generated
    public String toString() {
        return "VlanLanNetworkVO(name=" + this.getName() + ", site=" + this.getSite() + ", vlans=" + this.getVlans() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", interfaceIds=" + this.getInterfaceIds() + ", application=" + this.getApplication() + ", qosQueueEnable=" + this.getQosQueueEnable() + ", queueId=" + this.getQueueId() + ")";
    }
}

