/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpSettingsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkIpv6ConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswDhcpRelayVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswDhcpServerVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswIpSettingVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class LanNetworkVO
extends com.tplink.smb.omada.common.cache.a.a {
    private String id;
    private String site;
    @JsonProperty(value="primary")
    private Boolean primary;
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    private String purpose;
    private List<String> interfaceIds;
    @Range(min=0L, max=1L)
    private @Range(min=0L, max=1L) Integer vlanType;
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    private @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    private Integer application;
    private Boolean isolation;
    @Range(min=1L, max=4094L, message="Value of vlan is from 1 to 4094.")
    private @Range(min=1L, max=4094L, message="Value of vlan is from 1 to 4094.") Integer vlan;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.") String gatewaySubnet;
    @Valid
    private DhcpSettingsVO dhcpSettings;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.") String domain;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    private Boolean fastLeaveEnable;
    private Boolean mldSnoopEnable;
    private Dhcpv6GuardVO dhcpv6Guard;
    private Boolean dhcpL2RelayEnable;
    @Valid
    private DhcpGuardVO dhcpGuard;
    private Boolean portal;
    private String portalId;
    private String portalName;
    private Boolean accessControlRule;
    private Boolean rateLimit;
    @Valid
    private LanNetworkIpv6ConfigVO lanNetworkIpv6Config;
    private Boolean allLan;
    private Integer resource;
    private String origName;
    private Boolean arpDetectionEnable;
    private Boolean qosQueueEnable;
    private Integer queueId;
    boolean existMultiVlan;
    boolean existRA;
    boolean existCustomDhcpOption;
    boolean existDhcpNextServer;
    boolean existArpDetection;
    boolean existNetworkIsolation;
    private Integer deviceType;
    @a
    private String deviceMac;
    private String stackId;
    private String vrfId;
    private OswIpSettingVO ip;
    @NumberSet(value={0, 1}, message="Illegal parameter [mode], should be 0 or 1 ")
    private Integer mode;
    private OswDhcpServerVO dhcpServer;
    private OswDhcpRelayVO dhcpRelay;
    private Integer state;
    private Long totalIpNum;
    private Integer dhcpServerNum;
    private Boolean subnetOverrideEnable;
    private Boolean subnetOverride;

    public OperationResponse validate() {
        if ("interface".equals(this.purpose) && !Boolean.TRUE.equals(this.allLan) && CollectionUtils.isEmpty(this.interfaceIds)) {
            return new OperationResponse(b.iJ);
        }
        if (this.getLanNetworkIpv6Config() != null && this.getLanNetworkIpv6Config().getRa() != null && this.getLanNetworkIpv6Config().getRa().getValidLifetime() != null && this.getLanNetworkIpv6Config().getRa().getPreferredLifetime() != null) {
            return this.getLanNetworkIpv6Config().getRa().getValidLifetime() > this.getLanNetworkIpv6Config().getRa().getPreferredLifetime() ? new OperationResponse(b.a) : new OperationResponse(b.d);
        }
        return new OperationResponse(b.a);
    }

    public boolean isInterface() {
        return "interface".equals(this.purpose);
    }

    public String queryIpAddress() {
        if (this.gatewaySubnet == null || !this.gatewaySubnet.contains("/")) {
            return "";
        }
        return this.gatewaySubnet.split("/")[0];
    }

    public LanNetworkVO clearExtraParam() {
        if (this.getLanNetworkIpv6Config() != null && Objects.equals(this.getLanNetworkIpv6Config().getEnable(), 0)) {
            this.getLanNetworkIpv6Config().setDhcpv6(null);
            this.getLanNetworkIpv6Config().setPassthrough(null);
            this.getLanNetworkIpv6Config().setProto(null);
            this.getLanNetworkIpv6Config().setRa(null);
            this.getLanNetworkIpv6Config().setRdnss(null);
            this.getLanNetworkIpv6Config().setSlaac(null);
        }
        this.setPrimary(null);
        if (Boolean.TRUE.equals(this.getAllLan()) && CollectionUtils.isEmpty(this.getInterfaceIds())) {
            this.setInterfaceIds(null);
        }
        return this;
    }

    public static LanNetworkVO createDefault(String name, String vlans) {
        LanNetworkVO lanNetworkVO = new LanNetworkVO();
        lanNetworkVO.setName(name);
        lanNetworkVO.setVlans(vlans);
        lanNetworkVO.setVlanType(0);
        lanNetworkVO.setDeviceType(0);
        lanNetworkVO.setIgmpSnoopEnable(false);
        lanNetworkVO.setMldSnoopEnable(false);
        lanNetworkVO.setQosQueueEnable(false);
        lanNetworkVO.setDhcpGuard(new DhcpGuardVO().setEnable(false));
        lanNetworkVO.setDhcpv6Guard(new Dhcpv6GuardVO().setEnable(false));
        return lanNetworkVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPurpose() {
        return this.purpose;
    }

    @Generated
    public List<String> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Generated
    public Integer getVlanType() {
        return this.vlanType;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Integer getApplication() {
        return this.application;
    }

    @Generated
    public Boolean getIsolation() {
        return this.isolation;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public String getGatewaySubnet() {
        return this.gatewaySubnet;
    }

    @Generated
    public DhcpSettingsVO getDhcpSettings() {
        return this.dhcpSettings;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Dhcpv6GuardVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Boolean getPortal() {
        return this.portal;
    }

    @Generated
    public String getPortalId() {
        return this.portalId;
    }

    @Generated
    public String getPortalName() {
        return this.portalName;
    }

    @Generated
    public Boolean getAccessControlRule() {
        return this.accessControlRule;
    }

    @Generated
    public Boolean getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public LanNetworkIpv6ConfigVO getLanNetworkIpv6Config() {
        return this.lanNetworkIpv6Config;
    }

    @Generated
    public Boolean getAllLan() {
        return this.allLan;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public String getOrigName() {
        return this.origName;
    }

    @Generated
    public Boolean getArpDetectionEnable() {
        return this.arpDetectionEnable;
    }

    @Generated
    public Boolean getQosQueueEnable() {
        return this.qosQueueEnable;
    }

    @Generated
    public Integer getQueueId() {
        return this.queueId;
    }

    @Generated
    public boolean isExistMultiVlan() {
        return this.existMultiVlan;
    }

    @Generated
    public boolean isExistRA() {
        return this.existRA;
    }

    @Generated
    public boolean isExistCustomDhcpOption() {
        return this.existCustomDhcpOption;
    }

    @Generated
    public boolean isExistDhcpNextServer() {
        return this.existDhcpNextServer;
    }

    @Generated
    public boolean isExistArpDetection() {
        return this.existArpDetection;
    }

    @Generated
    public boolean isExistNetworkIsolation() {
        return this.existNetworkIsolation;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public String getVrfId() {
        return this.vrfId;
    }

    @Generated
    public OswIpSettingVO getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public OswDhcpServerVO getDhcpServer() {
        return this.dhcpServer;
    }

    @Generated
    public OswDhcpRelayVO getDhcpRelay() {
        return this.dhcpRelay;
    }

    @Generated
    public Integer getState() {
        return this.state;
    }

    @Generated
    public Long getTotalIpNum() {
        return this.totalIpNum;
    }

    @Generated
    public Integer getDhcpServerNum() {
        return this.dhcpServerNum;
    }

    @Generated
    public Boolean getSubnetOverrideEnable() {
        return this.subnetOverrideEnable;
    }

    @Generated
    public Boolean getSubnetOverride() {
        return this.subnetOverride;
    }

    @Generated
    public LanNetworkVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public LanNetworkVO setSite(String site) {
        this.site = site;
        return this;
    }

    @JsonProperty(value="primary")
    @Generated
    public LanNetworkVO setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Generated
    public LanNetworkVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public LanNetworkVO setPurpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @Generated
    public LanNetworkVO setInterfaceIds(List<String> interfaceIds) {
        this.interfaceIds = interfaceIds;
        return this;
    }

    @Generated
    public LanNetworkVO setVlanType(Integer vlanType) {
        this.vlanType = vlanType;
        return this;
    }

    @Generated
    public LanNetworkVO setVlans(String vlans) {
        this.vlans = vlans;
        return this;
    }

    @Generated
    public LanNetworkVO setApplication(Integer application) {
        this.application = application;
        return this;
    }

    @Generated
    public LanNetworkVO setIsolation(Boolean isolation) {
        this.isolation = isolation;
        return this;
    }

    @Generated
    public LanNetworkVO setVlan(Integer vlan) {
        this.vlan = vlan;
        return this;
    }

    @Generated
    public LanNetworkVO setGatewaySubnet(String gatewaySubnet) {
        this.gatewaySubnet = gatewaySubnet;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpSettings(DhcpSettingsVO dhcpSettings) {
        this.dhcpSettings = dhcpSettings;
        return this;
    }

    @Generated
    public LanNetworkVO setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Generated
    public LanNetworkVO setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpv6Guard(Dhcpv6GuardVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpGuard(DhcpGuardVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
        return this;
    }

    @Generated
    public LanNetworkVO setPortal(Boolean portal) {
        this.portal = portal;
        return this;
    }

    @Generated
    public LanNetworkVO setPortalId(String portalId) {
        this.portalId = portalId;
        return this;
    }

    @Generated
    public LanNetworkVO setPortalName(String portalName) {
        this.portalName = portalName;
        return this;
    }

    @Generated
    public LanNetworkVO setAccessControlRule(Boolean accessControlRule) {
        this.accessControlRule = accessControlRule;
        return this;
    }

    @Generated
    public LanNetworkVO setRateLimit(Boolean rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public LanNetworkVO setLanNetworkIpv6Config(LanNetworkIpv6ConfigVO lanNetworkIpv6Config) {
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
        return this;
    }

    @Generated
    public LanNetworkVO setAllLan(Boolean allLan) {
        this.allLan = allLan;
        return this;
    }

    @Generated
    public LanNetworkVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public LanNetworkVO setOrigName(String origName) {
        this.origName = origName;
        return this;
    }

    @Generated
    public LanNetworkVO setArpDetectionEnable(Boolean arpDetectionEnable) {
        this.arpDetectionEnable = arpDetectionEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setQosQueueEnable(Boolean qosQueueEnable) {
        this.qosQueueEnable = qosQueueEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setQueueId(Integer queueId) {
        this.queueId = queueId;
        return this;
    }

    @Generated
    public LanNetworkVO setExistMultiVlan(boolean existMultiVlan) {
        this.existMultiVlan = existMultiVlan;
        return this;
    }

    @Generated
    public LanNetworkVO setExistRA(boolean existRA) {
        this.existRA = existRA;
        return this;
    }

    @Generated
    public LanNetworkVO setExistCustomDhcpOption(boolean existCustomDhcpOption) {
        this.existCustomDhcpOption = existCustomDhcpOption;
        return this;
    }

    @Generated
    public LanNetworkVO setExistDhcpNextServer(boolean existDhcpNextServer) {
        this.existDhcpNextServer = existDhcpNextServer;
        return this;
    }

    @Generated
    public LanNetworkVO setExistArpDetection(boolean existArpDetection) {
        this.existArpDetection = existArpDetection;
        return this;
    }

    @Generated
    public LanNetworkVO setExistNetworkIsolation(boolean existNetworkIsolation) {
        this.existNetworkIsolation = existNetworkIsolation;
        return this;
    }

    @Generated
    public LanNetworkVO setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Generated
    public LanNetworkVO setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
        return this;
    }

    @Generated
    public LanNetworkVO setStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    @Generated
    public LanNetworkVO setVrfId(String vrfId) {
        this.vrfId = vrfId;
        return this;
    }

    @Generated
    public LanNetworkVO setIp(OswIpSettingVO ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public LanNetworkVO setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpServer(OswDhcpServerVO dhcpServer) {
        this.dhcpServer = dhcpServer;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpRelay(OswDhcpRelayVO dhcpRelay) {
        this.dhcpRelay = dhcpRelay;
        return this;
    }

    @Generated
    public LanNetworkVO setState(Integer state) {
        this.state = state;
        return this;
    }

    @Generated
    public LanNetworkVO setTotalIpNum(Long totalIpNum) {
        this.totalIpNum = totalIpNum;
        return this;
    }

    @Generated
    public LanNetworkVO setDhcpServerNum(Integer dhcpServerNum) {
        this.dhcpServerNum = dhcpServerNum;
        return this;
    }

    @Generated
    public LanNetworkVO setSubnetOverrideEnable(Boolean subnetOverrideEnable) {
        this.subnetOverrideEnable = subnetOverrideEnable;
        return this;
    }

    @Generated
    public LanNetworkVO setSubnetOverride(Boolean subnetOverride) {
        this.subnetOverride = subnetOverride;
        return this;
    }

    @Generated
    public String toString() {
        return "LanNetworkVO(id=" + this.getId() + ", site=" + this.getSite() + ", primary=" + this.getPrimary() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", interfaceIds=" + this.getInterfaceIds() + ", vlanType=" + this.getVlanType() + ", vlans=" + this.getVlans() + ", application=" + this.getApplication() + ", isolation=" + this.getIsolation() + ", vlan=" + this.getVlan() + ", gatewaySubnet=" + this.getGatewaySubnet() + ", dhcpSettings=" + this.getDhcpSettings() + ", domain=" + this.getDomain() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", portal=" + this.getPortal() + ", portalId=" + this.getPortalId() + ", portalName=" + this.getPortalName() + ", accessControlRule=" + this.getAccessControlRule() + ", rateLimit=" + this.getRateLimit() + ", lanNetworkIpv6Config=" + this.getLanNetworkIpv6Config() + ", allLan=" + this.getAllLan() + ", resource=" + this.getResource() + ", origName=" + this.getOrigName() + ", arpDetectionEnable=" + this.getArpDetectionEnable() + ", qosQueueEnable=" + this.getQosQueueEnable() + ", queueId=" + this.getQueueId() + ", existMultiVlan=" + this.isExistMultiVlan() + ", existRA=" + this.isExistRA() + ", existCustomDhcpOption=" + this.isExistCustomDhcpOption() + ", existDhcpNextServer=" + this.isExistDhcpNextServer() + ", existArpDetection=" + this.isExistArpDetection() + ", existNetworkIsolation=" + this.isExistNetworkIsolation() + ", deviceType=" + this.getDeviceType() + ", deviceMac=" + this.getDeviceMac() + ", stackId=" + this.getStackId() + ", vrfId=" + this.getVrfId() + ", ip=" + this.getIp() + ", mode=" + this.getMode() + ", dhcpServer=" + this.getDhcpServer() + ", dhcpRelay=" + this.getDhcpRelay() + ", state=" + this.getState() + ", totalIpNum=" + this.getTotalIpNum() + ", dhcpServerNum=" + this.getDhcpServerNum() + ", subnetOverrideEnable=" + this.getSubnetOverrideEnable() + ", subnetOverride=" + this.getSubnetOverride() + ")";
    }
}

