/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.OswStackInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class MldConfigVO {
    @Schema(name="networkId", description="The primary id of the network.")
    private String networkId;
    @Schema(name="networkName", description="The name of the network.Name should contain 1 to 128 characters.")
    private String networkName;
    @Schema(name="vlan", description="The vlan of the network.The vlan should be within the range of 1 to 4090.")
    @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.")
    private @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.") Integer vlan;
    @Schema(name="mac", description="The unique identification of the device.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(name="deviceName", description="The name of the device.")
    private String deviceName;
    @Schema(name="deviceType", description="Device type:ap\u3001gateway\u3001switch\u3001olt")
    private String deviceType;
    @Schema(name="deviceModel", description="Model of device,for example:EAP225")
    private String deviceModel;
    @Schema(name="deviceModelVersion", description="Model version of device,for example:3.0")
    private String deviceModelVersion;
    @Schema(name="stackId", description="The id of the stacking devices.")
    private String stackId;
    @Schema(name="stackName", description="The name of the stacking devices.")
    private String stackName;
    @Schema(name="oswStack", description="The osw stack.")
    private OswStackInfoVO oswStack;
    @Range(min=10L, max=300L, message="queryInterval should be in {min}-{max}")
    @Schema(name="queryInterval", description="The time interval for the MLD query to send query messages (unit: s).")
    private @Range(min=10L, max=300L, message="queryInterval should be in {min}-{max}") Integer queryInterval;
    @Range(min=1L, max=25L, message="maximumResponseTime should be in {min}-{max}")
    @Schema(name="maximumResponseTime", description="The maximum response time of the host to the general query message (unit: s).")
    private @Range(min=1L, max=25L, message="maximumResponseTime should be in {min}-{max}") Integer maximumResponseTime;
    @Range(min=1L, max=5L, message="lastMemberQueryInterval should be in {min}-{max}")
    @Schema(name="lastMemberQueryInterval", description="The time interval for the device to send a specific group of query messages (unit: s).")
    private @Range(min=1L, max=5L, message="lastMemberQueryInterval should be in {min}-{max}") Integer lastMemberQueryInterval;
    @Range(min=1L, max=5L, message="lastMemberQueryCount should be in {min}-{max}")
    @Schema(name="lastMemberQueryCount", description="The number of specific group query messages sent by the device.")
    private @Range(min=1L, max=5L, message="lastMemberQueryCount should be in {min}-{max}") Integer lastMemberQueryCount;
    @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", message="Incorrect GeneralQuerySourceIP,please input the right IP address")
    @Schema(name="generalQuerySourceIp", description="The source IP of the general query message sent.")
    private @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", message="Incorrect GeneralQuerySourceIP,please input the right IP address") String generalQuerySourceIp;

    @Generated
    public static MldConfigVOBuilder builder() {
        return new MldConfigVOBuilder();
    }

    @Generated
    public String getNetworkId() {
        return this.networkId;
    }

    @Generated
    public String getNetworkName() {
        return this.networkName;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Generated
    public String getDeviceModelVersion() {
        return this.deviceModelVersion;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public String getStackName() {
        return this.stackName;
    }

    @Generated
    public OswStackInfoVO getOswStack() {
        return this.oswStack;
    }

    @Generated
    public Integer getQueryInterval() {
        return this.queryInterval;
    }

    @Generated
    public Integer getMaximumResponseTime() {
        return this.maximumResponseTime;
    }

    @Generated
    public Integer getLastMemberQueryInterval() {
        return this.lastMemberQueryInterval;
    }

    @Generated
    public Integer getLastMemberQueryCount() {
        return this.lastMemberQueryCount;
    }

    @Generated
    public String getGeneralQuerySourceIp() {
        return this.generalQuerySourceIp;
    }

    @Generated
    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    @Generated
    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    @Generated
    public void setDeviceModelVersion(String deviceModelVersion) {
        this.deviceModelVersion = deviceModelVersion;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    @Generated
    public void setOswStack(OswStackInfoVO oswStack) {
        this.oswStack = oswStack;
    }

    @Generated
    public void setQueryInterval(Integer queryInterval) {
        this.queryInterval = queryInterval;
    }

    @Generated
    public void setMaximumResponseTime(Integer maximumResponseTime) {
        this.maximumResponseTime = maximumResponseTime;
    }

    @Generated
    public void setLastMemberQueryInterval(Integer lastMemberQueryInterval) {
        this.lastMemberQueryInterval = lastMemberQueryInterval;
    }

    @Generated
    public void setLastMemberQueryCount(Integer lastMemberQueryCount) {
        this.lastMemberQueryCount = lastMemberQueryCount;
    }

    @Generated
    public void setGeneralQuerySourceIp(String generalQuerySourceIp) {
        this.generalQuerySourceIp = generalQuerySourceIp;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof MldConfigVO)) {
            return false;
        }
        MldConfigVO other = (MldConfigVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$vlan = this.getVlan();
        Integer other$vlan = other.getVlan();
        if (this$vlan == null ? other$vlan != null : !((Object)this$vlan).equals(other$vlan)) {
            return false;
        }
        Integer this$queryInterval = this.getQueryInterval();
        Integer other$queryInterval = other.getQueryInterval();
        if (this$queryInterval == null ? other$queryInterval != null : !((Object)this$queryInterval).equals(other$queryInterval)) {
            return false;
        }
        Integer this$maximumResponseTime = this.getMaximumResponseTime();
        Integer other$maximumResponseTime = other.getMaximumResponseTime();
        if (this$maximumResponseTime == null ? other$maximumResponseTime != null : !((Object)this$maximumResponseTime).equals(other$maximumResponseTime)) {
            return false;
        }
        Integer this$lastMemberQueryInterval = this.getLastMemberQueryInterval();
        Integer other$lastMemberQueryInterval = other.getLastMemberQueryInterval();
        if (this$lastMemberQueryInterval == null ? other$lastMemberQueryInterval != null : !((Object)this$lastMemberQueryInterval).equals(other$lastMemberQueryInterval)) {
            return false;
        }
        Integer this$lastMemberQueryCount = this.getLastMemberQueryCount();
        Integer other$lastMemberQueryCount = other.getLastMemberQueryCount();
        if (this$lastMemberQueryCount == null ? other$lastMemberQueryCount != null : !((Object)this$lastMemberQueryCount).equals(other$lastMemberQueryCount)) {
            return false;
        }
        String this$networkId = this.getNetworkId();
        String other$networkId = other.getNetworkId();
        if (this$networkId == null ? other$networkId != null : !this$networkId.equals(other$networkId)) {
            return false;
        }
        String this$networkName = this.getNetworkName();
        String other$networkName = other.getNetworkName();
        if (this$networkName == null ? other$networkName != null : !this$networkName.equals(other$networkName)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        if (this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel)) {
            return false;
        }
        String this$deviceModelVersion = this.getDeviceModelVersion();
        String other$deviceModelVersion = other.getDeviceModelVersion();
        if (this$deviceModelVersion == null ? other$deviceModelVersion != null : !this$deviceModelVersion.equals(other$deviceModelVersion)) {
            return false;
        }
        String this$stackId = this.getStackId();
        String other$stackId = other.getStackId();
        if (this$stackId == null ? other$stackId != null : !this$stackId.equals(other$stackId)) {
            return false;
        }
        String this$stackName = this.getStackName();
        String other$stackName = other.getStackName();
        if (this$stackName == null ? other$stackName != null : !this$stackName.equals(other$stackName)) {
            return false;
        }
        OswStackInfoVO this$oswStack = this.getOswStack();
        OswStackInfoVO other$oswStack = other.getOswStack();
        if (this$oswStack == null ? other$oswStack != null : !((Object)this$oswStack).equals(other$oswStack)) {
            return false;
        }
        String this$generalQuerySourceIp = this.getGeneralQuerySourceIp();
        String other$generalQuerySourceIp = other.getGeneralQuerySourceIp();
        return !(this$generalQuerySourceIp == null ? other$generalQuerySourceIp != null : !this$generalQuerySourceIp.equals(other$generalQuerySourceIp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MldConfigVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $vlan = this.getVlan();
        result = result * 59 + ($vlan == null ? 43 : ((Object)$vlan).hashCode());
        Integer $queryInterval = this.getQueryInterval();
        result = result * 59 + ($queryInterval == null ? 43 : ((Object)$queryInterval).hashCode());
        Integer $maximumResponseTime = this.getMaximumResponseTime();
        result = result * 59 + ($maximumResponseTime == null ? 43 : ((Object)$maximumResponseTime).hashCode());
        Integer $lastMemberQueryInterval = this.getLastMemberQueryInterval();
        result = result * 59 + ($lastMemberQueryInterval == null ? 43 : ((Object)$lastMemberQueryInterval).hashCode());
        Integer $lastMemberQueryCount = this.getLastMemberQueryCount();
        result = result * 59 + ($lastMemberQueryCount == null ? 43 : ((Object)$lastMemberQueryCount).hashCode());
        String $networkId = this.getNetworkId();
        result = result * 59 + ($networkId == null ? 43 : $networkId.hashCode());
        String $networkName = this.getNetworkName();
        result = result * 59 + ($networkName == null ? 43 : $networkName.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        String $deviceModelVersion = this.getDeviceModelVersion();
        result = result * 59 + ($deviceModelVersion == null ? 43 : $deviceModelVersion.hashCode());
        String $stackId = this.getStackId();
        result = result * 59 + ($stackId == null ? 43 : $stackId.hashCode());
        String $stackName = this.getStackName();
        result = result * 59 + ($stackName == null ? 43 : $stackName.hashCode());
        OswStackInfoVO $oswStack = this.getOswStack();
        result = result * 59 + ($oswStack == null ? 43 : ((Object)$oswStack).hashCode());
        String $generalQuerySourceIp = this.getGeneralQuerySourceIp();
        result = result * 59 + ($generalQuerySourceIp == null ? 43 : $generalQuerySourceIp.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MldConfigVO(networkId=" + this.getNetworkId() + ", networkName=" + this.getNetworkName() + ", vlan=" + this.getVlan() + ", mac=" + this.getMac() + ", deviceName=" + this.getDeviceName() + ", deviceType=" + this.getDeviceType() + ", deviceModel=" + this.getDeviceModel() + ", deviceModelVersion=" + this.getDeviceModelVersion() + ", stackId=" + this.getStackId() + ", stackName=" + this.getStackName() + ", oswStack=" + this.getOswStack() + ", queryInterval=" + this.getQueryInterval() + ", maximumResponseTime=" + this.getMaximumResponseTime() + ", lastMemberQueryInterval=" + this.getLastMemberQueryInterval() + ", lastMemberQueryCount=" + this.getLastMemberQueryCount() + ", generalQuerySourceIp=" + this.getGeneralQuerySourceIp() + ")";
    }

    @Generated
    public MldConfigVO() {
    }

    @Generated
    public MldConfigVO(String networkId, String networkName, Integer vlan, String mac, String deviceName, String deviceType, String deviceModel, String deviceModelVersion, String stackId, String stackName, OswStackInfoVO oswStack, Integer queryInterval, Integer maximumResponseTime, Integer lastMemberQueryInterval, Integer lastMemberQueryCount, String generalQuerySourceIp) {
        this.networkId = networkId;
        this.networkName = networkName;
        this.vlan = vlan;
        this.mac = mac;
        this.deviceName = deviceName;
        this.deviceType = deviceType;
        this.deviceModel = deviceModel;
        this.deviceModelVersion = deviceModelVersion;
        this.stackId = stackId;
        this.stackName = stackName;
        this.oswStack = oswStack;
        this.queryInterval = queryInterval;
        this.maximumResponseTime = maximumResponseTime;
        this.lastMemberQueryInterval = lastMemberQueryInterval;
        this.lastMemberQueryCount = lastMemberQueryCount;
        this.generalQuerySourceIp = generalQuerySourceIp;
    }

    @Generated
    public static class MldConfigVOBuilder {
        @Generated
        private String networkId;
        @Generated
        private String networkName;
        @Generated
        private Integer vlan;
        @Generated
        private String mac;
        @Generated
        private String deviceName;
        @Generated
        private String deviceType;
        @Generated
        private String deviceModel;
        @Generated
        private String deviceModelVersion;
        @Generated
        private String stackId;
        @Generated
        private String stackName;
        @Generated
        private OswStackInfoVO oswStack;
        @Generated
        private Integer queryInterval;
        @Generated
        private Integer maximumResponseTime;
        @Generated
        private Integer lastMemberQueryInterval;
        @Generated
        private Integer lastMemberQueryCount;
        @Generated
        private String generalQuerySourceIp;

        @Generated
        MldConfigVOBuilder() {
        }

        @Generated
        public MldConfigVOBuilder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        @Generated
        public MldConfigVOBuilder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        @Generated
        public MldConfigVOBuilder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        @Generated
        public MldConfigVOBuilder mac(String mac) {
            this.mac = mac;
            return this;
        }

        @Generated
        public MldConfigVOBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        @Generated
        public MldConfigVOBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Generated
        public MldConfigVOBuilder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            return this;
        }

        @Generated
        public MldConfigVOBuilder deviceModelVersion(String deviceModelVersion) {
            this.deviceModelVersion = deviceModelVersion;
            return this;
        }

        @Generated
        public MldConfigVOBuilder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        @Generated
        public MldConfigVOBuilder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        @Generated
        public MldConfigVOBuilder oswStack(OswStackInfoVO oswStack) {
            this.oswStack = oswStack;
            return this;
        }

        @Generated
        public MldConfigVOBuilder queryInterval(Integer queryInterval) {
            this.queryInterval = queryInterval;
            return this;
        }

        @Generated
        public MldConfigVOBuilder maximumResponseTime(Integer maximumResponseTime) {
            this.maximumResponseTime = maximumResponseTime;
            return this;
        }

        @Generated
        public MldConfigVOBuilder lastMemberQueryInterval(Integer lastMemberQueryInterval) {
            this.lastMemberQueryInterval = lastMemberQueryInterval;
            return this;
        }

        @Generated
        public MldConfigVOBuilder lastMemberQueryCount(Integer lastMemberQueryCount) {
            this.lastMemberQueryCount = lastMemberQueryCount;
            return this;
        }

        @Generated
        public MldConfigVOBuilder generalQuerySourceIp(String generalQuerySourceIp) {
            this.generalQuerySourceIp = generalQuerySourceIp;
            return this;
        }

        @Generated
        public MldConfigVO build() {
            return new MldConfigVO(this.networkId, this.networkName, this.vlan, this.mac, this.deviceName, this.deviceType, this.deviceModel, this.deviceModelVersion, this.stackId, this.stackName, this.oswStack, this.queryInterval, this.maximumResponseTime, this.lastMemberQueryInterval, this.lastMemberQueryCount, this.generalQuerySourceIp);
        }

        @Generated
        public String toString() {
            return "MldConfigVO.MldConfigVOBuilder(networkId=" + this.networkId + ", networkName=" + this.networkName + ", vlan=" + this.vlan + ", mac=" + this.mac + ", deviceName=" + this.deviceName + ", deviceType=" + this.deviceType + ", deviceModel=" + this.deviceModel + ", deviceModelVersion=" + this.deviceModelVersion + ", stackId=" + this.stackId + ", stackName=" + this.stackName + ", oswStack=" + this.oswStack + ", queryInterval=" + this.queryInterval + ", maximumResponseTime=" + this.maximumResponseTime + ", lastMemberQueryInterval=" + this.lastMemberQueryInterval + ", lastMemberQueryCount=" + this.lastMemberQueryCount + ", generalQuerySourceIp=" + this.generalQuerySourceIp + ")";
        }
    }
}

