/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.IgmpConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.MldConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.NetworkVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.RouterPortVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.SnoopConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanmulticast.dto.UnknownMulticastConfigVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Range;

public class LanMulticastVO {
    @Schema(name="id", description="The primary id of the multicast snooping.")
    private String id;
    @Schema(name="name", description="The name of the multicast snooping.")
    private String name;
    @Schema(name="omadacId", description="The id of the omada the multicast snooping belongs to.")
    private String omadacId;
    @Schema(name="siteId", description="The id of the site the multicast snooping belongs to.")
    private String siteId;
    @Schema(name="networks", description="The collection of snooping network ids related to this multicast snooping config.")
    private List<NetworkVO> networks;
    @Schema(name="protocol", description="When multicast snooping value 0,then represents the IGMP snooping type,else if value 1,then represents MLD snooping type.")
    @Range(min=0L, max=1L)
    private @Range(min=0L, max=1L) Integer protocol;
    @Schema(name="unknownMulticastRule", description="When it selects 0,then send forward, it selects 1,then discard info, it selects 2,then route port first.")
    @Range(min=0L, max=2L)
    private @Range(min=0L, max=2L) Integer unknownMulticastRule;
    @Schema(name="unknownMulticastExceptDevice", description="UnknownMulticastConfigVO.")
    private UnknownMulticastConfigVO unknownMulticastExceptDevice;
    @Schema(name="querierEnable", description="Whether open querier.")
    private Boolean querierEnable;
    @Schema(name="routerPortEnable", description="Whether open manual router port config.")
    private Boolean routerPortEnable;
    @Schema(name="resource", description="resource")
    private Integer resource;
    @Schema(name="routerPorts", description="The specific list of router ports info,including network, devices and the ports on them.")
    private List<RouterPortVO> routerPorts;
    @Schema(name="snoopConfig", description="The snoop config model.")
    private SnoopConfigVO snoopConfig;
    @Schema(name="igmpQueriers", description="The querier configs for IGMP snooping(ipv4).")
    private List<IgmpConfigVO> igmpQueriers;
    @Schema(name="mldQueriers", description="The querier configs for MLD snooping(ipv6).")
    private List<MldConfigVO> mldQueriers;

    public LanMulticastVO clearExtraParam() {
        CollectionUtils.emptyIfNull(this.getRouterPorts()).forEach(it -> {
            it.setNetworkName(null);
            it.setStaticRouterPortsNum(null);
            it.setForbiddenRouterPortsNum(null);
            CollectionUtils.emptyIfNull(it.getDevices()).forEach(ir -> ir.setDeviceName(null));
        });
        CollectionUtils.emptyIfNull(this.getIgmpQueriers()).forEach(it -> it.setNetworkName(null));
        CollectionUtils.emptyIfNull(this.getIgmpQueriers()).forEach(it -> it.setNetworkName(null));
        return this;
    }

    @Generated
    public static LanMulticastVOBuilder builder() {
        return new LanMulticastVOBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public List<NetworkVO> getNetworks() {
        return this.networks;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getUnknownMulticastRule() {
        return this.unknownMulticastRule;
    }

    @Generated
    public UnknownMulticastConfigVO getUnknownMulticastExceptDevice() {
        return this.unknownMulticastExceptDevice;
    }

    @Generated
    public Boolean getQuerierEnable() {
        return this.querierEnable;
    }

    @Generated
    public Boolean getRouterPortEnable() {
        return this.routerPortEnable;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public List<RouterPortVO> getRouterPorts() {
        return this.routerPorts;
    }

    @Generated
    public SnoopConfigVO getSnoopConfig() {
        return this.snoopConfig;
    }

    @Generated
    public List<IgmpConfigVO> getIgmpQueriers() {
        return this.igmpQueriers;
    }

    @Generated
    public List<MldConfigVO> getMldQueriers() {
        return this.mldQueriers;
    }

    @Generated
    public LanMulticastVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public LanMulticastVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public LanMulticastVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public LanMulticastVO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public LanMulticastVO setNetworks(List<NetworkVO> networks) {
        this.networks = networks;
        return this;
    }

    @Generated
    public LanMulticastVO setProtocol(Integer protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public LanMulticastVO setUnknownMulticastRule(Integer unknownMulticastRule) {
        this.unknownMulticastRule = unknownMulticastRule;
        return this;
    }

    @Generated
    public LanMulticastVO setUnknownMulticastExceptDevice(UnknownMulticastConfigVO unknownMulticastExceptDevice) {
        this.unknownMulticastExceptDevice = unknownMulticastExceptDevice;
        return this;
    }

    @Generated
    public LanMulticastVO setQuerierEnable(Boolean querierEnable) {
        this.querierEnable = querierEnable;
        return this;
    }

    @Generated
    public LanMulticastVO setRouterPortEnable(Boolean routerPortEnable) {
        this.routerPortEnable = routerPortEnable;
        return this;
    }

    @Generated
    public LanMulticastVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public LanMulticastVO setRouterPorts(List<RouterPortVO> routerPorts) {
        this.routerPorts = routerPorts;
        return this;
    }

    @Generated
    public LanMulticastVO setSnoopConfig(SnoopConfigVO snoopConfig) {
        this.snoopConfig = snoopConfig;
        return this;
    }

    @Generated
    public LanMulticastVO setIgmpQueriers(List<IgmpConfigVO> igmpQueriers) {
        this.igmpQueriers = igmpQueriers;
        return this;
    }

    @Generated
    public LanMulticastVO setMldQueriers(List<MldConfigVO> mldQueriers) {
        this.mldQueriers = mldQueriers;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof LanMulticastVO)) {
            return false;
        }
        LanMulticastVO other = (LanMulticastVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$protocol = this.getProtocol();
        Integer other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)this$protocol).equals(other$protocol)) {
            return false;
        }
        Integer this$unknownMulticastRule = this.getUnknownMulticastRule();
        Integer other$unknownMulticastRule = other.getUnknownMulticastRule();
        if (this$unknownMulticastRule == null ? other$unknownMulticastRule != null : !((Object)this$unknownMulticastRule).equals(other$unknownMulticastRule)) {
            return false;
        }
        Boolean this$querierEnable = this.getQuerierEnable();
        Boolean other$querierEnable = other.getQuerierEnable();
        if (this$querierEnable == null ? other$querierEnable != null : !((Object)this$querierEnable).equals(other$querierEnable)) {
            return false;
        }
        Boolean this$routerPortEnable = this.getRouterPortEnable();
        Boolean other$routerPortEnable = other.getRouterPortEnable();
        if (this$routerPortEnable == null ? other$routerPortEnable != null : !((Object)this$routerPortEnable).equals(other$routerPortEnable)) {
            return false;
        }
        Integer this$resource = this.getResource();
        Integer other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        List<NetworkVO> this$networks = this.getNetworks();
        List<NetworkVO> other$networks = other.getNetworks();
        if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
            return false;
        }
        UnknownMulticastConfigVO this$unknownMulticastExceptDevice = this.getUnknownMulticastExceptDevice();
        UnknownMulticastConfigVO other$unknownMulticastExceptDevice = other.getUnknownMulticastExceptDevice();
        if (this$unknownMulticastExceptDevice == null ? other$unknownMulticastExceptDevice != null : !((Object)this$unknownMulticastExceptDevice).equals(other$unknownMulticastExceptDevice)) {
            return false;
        }
        List<RouterPortVO> this$routerPorts = this.getRouterPorts();
        List<RouterPortVO> other$routerPorts = other.getRouterPorts();
        if (this$routerPorts == null ? other$routerPorts != null : !((Object)this$routerPorts).equals(other$routerPorts)) {
            return false;
        }
        SnoopConfigVO this$snoopConfig = this.getSnoopConfig();
        SnoopConfigVO other$snoopConfig = other.getSnoopConfig();
        if (this$snoopConfig == null ? other$snoopConfig != null : !((Object)this$snoopConfig).equals(other$snoopConfig)) {
            return false;
        }
        List<IgmpConfigVO> this$igmpQueriers = this.getIgmpQueriers();
        List<IgmpConfigVO> other$igmpQueriers = other.getIgmpQueriers();
        if (this$igmpQueriers == null ? other$igmpQueriers != null : !((Object)this$igmpQueriers).equals(other$igmpQueriers)) {
            return false;
        }
        List<MldConfigVO> this$mldQueriers = this.getMldQueriers();
        List<MldConfigVO> other$mldQueriers = other.getMldQueriers();
        return !(this$mldQueriers == null ? other$mldQueriers != null : !((Object)this$mldQueriers).equals(other$mldQueriers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LanMulticastVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)$protocol).hashCode());
        Integer $unknownMulticastRule = this.getUnknownMulticastRule();
        result = result * 59 + ($unknownMulticastRule == null ? 43 : ((Object)$unknownMulticastRule).hashCode());
        Boolean $querierEnable = this.getQuerierEnable();
        result = result * 59 + ($querierEnable == null ? 43 : ((Object)$querierEnable).hashCode());
        Boolean $routerPortEnable = this.getRouterPortEnable();
        result = result * 59 + ($routerPortEnable == null ? 43 : ((Object)$routerPortEnable).hashCode());
        Integer $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        List<NetworkVO> $networks = this.getNetworks();
        result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
        UnknownMulticastConfigVO $unknownMulticastExceptDevice = this.getUnknownMulticastExceptDevice();
        result = result * 59 + ($unknownMulticastExceptDevice == null ? 43 : ((Object)$unknownMulticastExceptDevice).hashCode());
        List<RouterPortVO> $routerPorts = this.getRouterPorts();
        result = result * 59 + ($routerPorts == null ? 43 : ((Object)$routerPorts).hashCode());
        SnoopConfigVO $snoopConfig = this.getSnoopConfig();
        result = result * 59 + ($snoopConfig == null ? 43 : ((Object)$snoopConfig).hashCode());
        List<IgmpConfigVO> $igmpQueriers = this.getIgmpQueriers();
        result = result * 59 + ($igmpQueriers == null ? 43 : ((Object)$igmpQueriers).hashCode());
        List<MldConfigVO> $mldQueriers = this.getMldQueriers();
        result = result * 59 + ($mldQueriers == null ? 43 : ((Object)$mldQueriers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LanMulticastVO(id=" + this.getId() + ", name=" + this.getName() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", networks=" + this.getNetworks() + ", protocol=" + this.getProtocol() + ", unknownMulticastRule=" + this.getUnknownMulticastRule() + ", unknownMulticastExceptDevice=" + this.getUnknownMulticastExceptDevice() + ", querierEnable=" + this.getQuerierEnable() + ", routerPortEnable=" + this.getRouterPortEnable() + ", resource=" + this.getResource() + ", routerPorts=" + this.getRouterPorts() + ", snoopConfig=" + this.getSnoopConfig() + ", igmpQueriers=" + this.getIgmpQueriers() + ", mldQueriers=" + this.getMldQueriers() + ")";
    }

    @Generated
    public LanMulticastVO() {
    }

    @Generated
    public LanMulticastVO(String id, String name, String omadacId, String siteId, List<NetworkVO> networks, Integer protocol, Integer unknownMulticastRule, UnknownMulticastConfigVO unknownMulticastExceptDevice, Boolean querierEnable, Boolean routerPortEnable, Integer resource, List<RouterPortVO> routerPorts, SnoopConfigVO snoopConfig, List<IgmpConfigVO> igmpQueriers, List<MldConfigVO> mldQueriers) {
        this.id = id;
        this.name = name;
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.networks = networks;
        this.protocol = protocol;
        this.unknownMulticastRule = unknownMulticastRule;
        this.unknownMulticastExceptDevice = unknownMulticastExceptDevice;
        this.querierEnable = querierEnable;
        this.routerPortEnable = routerPortEnable;
        this.resource = resource;
        this.routerPorts = routerPorts;
        this.snoopConfig = snoopConfig;
        this.igmpQueriers = igmpQueriers;
        this.mldQueriers = mldQueriers;
    }

    @Generated
    public static class LanMulticastVOBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String omadacId;
        @Generated
        private String siteId;
        @Generated
        private List<NetworkVO> networks;
        @Generated
        private Integer protocol;
        @Generated
        private Integer unknownMulticastRule;
        @Generated
        private UnknownMulticastConfigVO unknownMulticastExceptDevice;
        @Generated
        private Boolean querierEnable;
        @Generated
        private Boolean routerPortEnable;
        @Generated
        private Integer resource;
        @Generated
        private List<RouterPortVO> routerPorts;
        @Generated
        private SnoopConfigVO snoopConfig;
        @Generated
        private List<IgmpConfigVO> igmpQueriers;
        @Generated
        private List<MldConfigVO> mldQueriers;

        @Generated
        LanMulticastVOBuilder() {
        }

        @Generated
        public LanMulticastVOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder networks(List<NetworkVO> networks) {
            this.networks = networks;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder unknownMulticastRule(Integer unknownMulticastRule) {
            this.unknownMulticastRule = unknownMulticastRule;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder unknownMulticastExceptDevice(UnknownMulticastConfigVO unknownMulticastExceptDevice) {
            this.unknownMulticastExceptDevice = unknownMulticastExceptDevice;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder querierEnable(Boolean querierEnable) {
            this.querierEnable = querierEnable;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder routerPortEnable(Boolean routerPortEnable) {
            this.routerPortEnable = routerPortEnable;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder routerPorts(List<RouterPortVO> routerPorts) {
            this.routerPorts = routerPorts;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder snoopConfig(SnoopConfigVO snoopConfig) {
            this.snoopConfig = snoopConfig;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder igmpQueriers(List<IgmpConfigVO> igmpQueriers) {
            this.igmpQueriers = igmpQueriers;
            return this;
        }

        @Generated
        public LanMulticastVOBuilder mldQueriers(List<MldConfigVO> mldQueriers) {
            this.mldQueriers = mldQueriers;
            return this;
        }

        @Generated
        public LanMulticastVO build() {
            return new LanMulticastVO(this.id, this.name, this.omadacId, this.siteId, this.networks, this.protocol, this.unknownMulticastRule, this.unknownMulticastExceptDevice, this.querierEnable, this.routerPortEnable, this.resource, this.routerPorts, this.snoopConfig, this.igmpQueriers, this.mldQueriers);
        }

        @Generated
        public String toString() {
            return "LanMulticastVO.LanMulticastVOBuilder(id=" + this.id + ", name=" + this.name + ", omadacId=" + this.omadacId + ", siteId=" + this.siteId + ", networks=" + this.networks + ", protocol=" + this.protocol + ", unknownMulticastRule=" + this.unknownMulticastRule + ", unknownMulticastExceptDevice=" + this.unknownMulticastExceptDevice + ", querierEnable=" + this.querierEnable + ", routerPortEnable=" + this.routerPortEnable + ", resource=" + this.resource + ", routerPorts=" + this.routerPorts + ", snoopConfig=" + this.snoopConfig + ", igmpQueriers=" + this.igmpQueriers + ", mldQueriers=" + this.mldQueriers + ")";
        }
    }
}

