/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess;

import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessAreaVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OspfProcessVO {
    private String id;
    @NotNull(message="Ospf Process parameter [deviceName] should not be null")
    private @NotNull(message="Ospf Process parameter [deviceName] should not be null") String deviceName;
    private Boolean isStack;
    @NotNull(message="Ospf Process parameter [mac] should not be null")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @com.tplink.smb.omada.a.a
    private @NotNull(message="Ospf Process parameter [mac] should not be null") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    private String model;
    private String modelVersion;
    private String stackId;
    @NotNull(message="Ospf Process parameter [processId] should not be null")
    @Range(min=1L, max=65535L, message="Value of processId is from 1 to 65535.")
    private @NotNull(message="Ospf Process parameter [processId] should not be null") @Range(min=1L, max=65535L, message="Value of processId is from 1 to 65535.") Integer processId;
    @NotNull(message="Ospf Process parameter [routerMode] should not be null")
    @Range(min=0L, max=1L, message="Value of routerMode is from 0 to 1.")
    private @NotNull(message="Ospf Process parameter [routerMode] should not be null") @Range(min=0L, max=1L, message="Value of routerMode is from 0 to 1.") Integer routerMode;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [routerId] Invalid.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [routerId] Invalid.") String routerId;
    @NotNull(message="Ospf Process parameter [staticEnable] should not be null")
    private @NotNull(message="Ospf Process parameter [staticEnable] should not be null") Boolean staticEnable;
    @Range(min=1L, max=0xFFFFFEL, message="Value of staticMetric is from 1 to 16777214.")
    private @Range(min=1L, max=0xFFFFFEL, message="Value of staticMetric is from 1 to 16777214.") Integer staticMetric;
    @Range(min=1L, max=2L, message="Value of staticMetricType is from 1 to 2.")
    private @Range(min=1L, max=2L, message="Value of staticMetricType is from 1 to 2.") Integer staticMetricType;
    @NotNull(message="Ospf Process parameter [connectedEnable] should not be null")
    private @NotNull(message="Ospf Process parameter [connectedEnable] should not be null") Boolean connectedEnable;
    @Range(min=1L, max=0xFFFFFEL, message="Value of connectedMetric is from 1 to 16777214.")
    private @Range(min=1L, max=0xFFFFFEL, message="Value of connectedMetric is from 1 to 16777214.") Integer connectedMetric;
    @Range(min=1L, max=2L, message="Value of connectedMetricType is from 1 to 2.")
    private @Range(min=1L, max=2L, message="Value of connectedMetricType is from 1 to 2.") Integer connectedMetricType;
    private String vrfId;
    private String vrf;
    @NotNull(message="Ospf Process parameter [areaList] should not be null")
    @Size(max=16, message="Size of areaList should be less than 16")
    private @NotNull(message="Ospf Process parameter [areaList] should not be null") @Size(max=16, message="Size of areaList should be less than 16") List<OspfProcessAreaVO> areaList;

    public boolean validateRouterId() {
        if (!this.routerMode.equals(a.a)) {
            return !v.c((String)this.routerId);
        }
        return true;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public Boolean getIsStack() {
        return this.isStack;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public Integer getProcessId() {
        return this.processId;
    }

    @Generated
    public Integer getRouterMode() {
        return this.routerMode;
    }

    @Generated
    public String getRouterId() {
        return this.routerId;
    }

    @Generated
    public Boolean getStaticEnable() {
        return this.staticEnable;
    }

    @Generated
    public Integer getStaticMetric() {
        return this.staticMetric;
    }

    @Generated
    public Integer getStaticMetricType() {
        return this.staticMetricType;
    }

    @Generated
    public Boolean getConnectedEnable() {
        return this.connectedEnable;
    }

    @Generated
    public Integer getConnectedMetric() {
        return this.connectedMetric;
    }

    @Generated
    public Integer getConnectedMetricType() {
        return this.connectedMetricType;
    }

    @Generated
    public String getVrfId() {
        return this.vrfId;
    }

    @Generated
    public String getVrf() {
        return this.vrf;
    }

    @Generated
    public List<OspfProcessAreaVO> getAreaList() {
        return this.areaList;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setIsStack(Boolean isStack) {
        this.isStack = isStack;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setProcessId(Integer processId) {
        this.processId = processId;
    }

    @Generated
    public void setRouterMode(Integer routerMode) {
        this.routerMode = routerMode;
    }

    @Generated
    public void setRouterId(String routerId) {
        this.routerId = routerId;
    }

    @Generated
    public void setStaticEnable(Boolean staticEnable) {
        this.staticEnable = staticEnable;
    }

    @Generated
    public void setStaticMetric(Integer staticMetric) {
        this.staticMetric = staticMetric;
    }

    @Generated
    public void setStaticMetricType(Integer staticMetricType) {
        this.staticMetricType = staticMetricType;
    }

    @Generated
    public void setConnectedEnable(Boolean connectedEnable) {
        this.connectedEnable = connectedEnable;
    }

    @Generated
    public void setConnectedMetric(Integer connectedMetric) {
        this.connectedMetric = connectedMetric;
    }

    @Generated
    public void setConnectedMetricType(Integer connectedMetricType) {
        this.connectedMetricType = connectedMetricType;
    }

    @Generated
    public void setVrfId(String vrfId) {
        this.vrfId = vrfId;
    }

    @Generated
    public void setVrf(String vrf) {
        this.vrf = vrf;
    }

    @Generated
    public void setAreaList(List<OspfProcessAreaVO> areaList) {
        this.areaList = areaList;
    }

    @Generated
    public String toString() {
        return "OspfProcessVO(id=" + this.getId() + ", deviceName=" + this.getDeviceName() + ", isStack=" + this.getIsStack() + ", mac=" + this.getMac() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", stackId=" + this.getStackId() + ", processId=" + this.getProcessId() + ", routerMode=" + this.getRouterMode() + ", routerId=" + this.getRouterId() + ", staticEnable=" + this.getStaticEnable() + ", staticMetric=" + this.getStaticMetric() + ", staticMetricType=" + this.getStaticMetricType() + ", connectedEnable=" + this.getConnectedEnable() + ", connectedMetric=" + this.getConnectedMetric() + ", connectedMetricType=" + this.getConnectedMetricType() + ", vrfId=" + this.getVrfId() + ", vrf=" + this.getVrf() + ", areaList=" + this.getAreaList() + ")";
    }
}

