/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfinterface;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OspfInterfaceVO {
    private String id;
    @NotNull(message="Ospf Interface parameter [deviceName] should not be null")
    private @NotNull(message="Ospf Interface parameter [deviceName] should not be null") String deviceName;
    private Boolean isStack;
    @NotNull(message="Ospf Interface parameter [mac] should not be null")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @com.tplink.smb.omada.a.a
    private @NotNull(message="Ospf Interface parameter [mac] should not be null") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    private String model;
    private String modelVersion;
    private String stackId;
    @NotNull(message="Ospf Interface parameter [type] should not be null")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="Ospf Interface parameter [type] should not be null") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    private String vlanInterfaceId;
    private String vlanInterfaceName;
    @Range(min=1L, max=4094L, message="Value of vlanInterfaceId is from 1 to 4094.")
    private @Range(min=1L, max=4094L, message="Value of vlanInterfaceId is from 1 to 4094.") Integer vlanId;
    private String loopbackInterfaceId;
    @Range(min=1L, max=64L, message="Value of loopbackInterfaceId is from 1 to 64.")
    private @Range(min=1L, max=64L, message="Value of loopbackInterfaceId is from 1 to 64.") Integer loopbackId;
    @NotNull(message="Ospf Interface parameter [cost] should not be null")
    @Range(min=1L, max=65535L, message="Value of cost is from 1 to 65535.")
    private @NotNull(message="Ospf Interface parameter [cost] should not be null") @Range(min=1L, max=65535L, message="Value of cost is from 1 to 65535.") Integer cost;
    @NotNull(message="Ospf Interface parameter [networkType] should not be null")
    @Range(min=0L, max=3L, message="Value of networkType is from 0 to 3.")
    private @NotNull(message="Ospf Interface parameter [networkType] should not be null") @Range(min=0L, max=3L, message="Value of networkType is from 0 to 3.") Integer networkType;
    @NotNull(message="Ospf Interface parameter [helloInterval] should not be null")
    @Range(min=1L, max=65535L, message="Value of helloInterval is from 1 to 65535.")
    private @NotNull(message="Ospf Interface parameter [helloInterval] should not be null") @Range(min=1L, max=65535L, message="Value of helloInterval is from 1 to 65535.") Integer helloInterval;
    @Range(min=1L, max=65535L, message="Value of deadInterval is from 1 to 65535.")
    private @Range(min=1L, max=65535L, message="Value of deadInterval is from 1 to 65535.") Integer deadInterval;
    @NotNull(message="Ospf Interface parameter [authenticationType] should not be null")
    @Range(min=0L, max=2L, message="Value of authenticationType is from 0 to 2.")
    private @NotNull(message="Ospf Interface parameter [authenticationType] should not be null") @Range(min=0L, max=2L, message="Value of authenticationType is from 0 to 2.") Integer authenticationType;
    @Size(min=1, max=8, message="Size of md5Key is from 1 to 8.")
    private @Size(min=1, max=8, message="Size of md5Key is from 1 to 8.") String simpleKey;
    @Range(min=1L, max=255L, message="Value of md5KeyId is from 1 to 255.")
    private @Range(min=1L, max=255L, message="Value of md5KeyId is from 1 to 255.") Integer md5KeyId;
    @Size(min=1, max=16, message="Size of md5Key is from 1 to 16.")
    private @Size(min=1, max=16, message="Size of md5Key is from 1 to 16.") String md5Key;

    public boolean validate() {
        if (this.getType().equals(a.g)) {
            return this.getVlanInterfaceName() != null && this.getVlanId() != null;
        }
        if (this.getType().equals(a.h)) {
            return this.getLoopbackInterfaceId() != null && this.getLoopbackId() != null;
        }
        if (this.getAuthenticationType().equals(a.j)) {
            return this.getSimpleKey() != null;
        }
        if (this.getAuthenticationType().equals(a.k)) {
            return this.getMd5KeyId() != null && this.getMd5Key() != null;
        }
        return true;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public Boolean getIsStack() {
        return this.isStack;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getVlanInterfaceId() {
        return this.vlanInterfaceId;
    }

    @Generated
    public String getVlanInterfaceName() {
        return this.vlanInterfaceName;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public String getLoopbackInterfaceId() {
        return this.loopbackInterfaceId;
    }

    @Generated
    public Integer getLoopbackId() {
        return this.loopbackId;
    }

    @Generated
    public Integer getCost() {
        return this.cost;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public Integer getHelloInterval() {
        return this.helloInterval;
    }

    @Generated
    public Integer getDeadInterval() {
        return this.deadInterval;
    }

    @Generated
    public Integer getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public String getSimpleKey() {
        return this.simpleKey;
    }

    @Generated
    public Integer getMd5KeyId() {
        return this.md5KeyId;
    }

    @Generated
    public String getMd5Key() {
        return this.md5Key;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setIsStack(Boolean isStack) {
        this.isStack = isStack;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setVlanInterfaceId(String vlanInterfaceId) {
        this.vlanInterfaceId = vlanInterfaceId;
    }

    @Generated
    public void setVlanInterfaceName(String vlanInterfaceName) {
        this.vlanInterfaceName = vlanInterfaceName;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setLoopbackInterfaceId(String loopbackInterfaceId) {
        this.loopbackInterfaceId = loopbackInterfaceId;
    }

    @Generated
    public void setLoopbackId(Integer loopbackId) {
        this.loopbackId = loopbackId;
    }

    @Generated
    public void setCost(Integer cost) {
        this.cost = cost;
    }

    @Generated
    public void setNetworkType(Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setHelloInterval(Integer helloInterval) {
        this.helloInterval = helloInterval;
    }

    @Generated
    public void setDeadInterval(Integer deadInterval) {
        this.deadInterval = deadInterval;
    }

    @Generated
    public void setAuthenticationType(Integer authenticationType) {
        this.authenticationType = authenticationType;
    }

    @Generated
    public void setSimpleKey(String simpleKey) {
        this.simpleKey = simpleKey;
    }

    @Generated
    public void setMd5KeyId(Integer md5KeyId) {
        this.md5KeyId = md5KeyId;
    }

    @Generated
    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    @Generated
    public String toString() {
        return "OspfInterfaceVO(id=" + this.getId() + ", deviceName=" + this.getDeviceName() + ", isStack=" + this.getIsStack() + ", mac=" + this.getMac() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", stackId=" + this.getStackId() + ", type=" + this.getType() + ", vlanInterfaceId=" + this.getVlanInterfaceId() + ", vlanInterfaceName=" + this.getVlanInterfaceName() + ", vlanId=" + this.getVlanId() + ", loopbackInterfaceId=" + this.getLoopbackInterfaceId() + ", loopbackId=" + this.getLoopbackId() + ", cost=" + this.getCost() + ", networkType=" + this.getNetworkType() + ", helloInterval=" + this.getHelloInterval() + ", deadInterval=" + this.getDeadInterval() + ", authenticationType=" + this.getAuthenticationType() + ", simpleKey=" + this.getSimpleKey() + ", md5KeyId=" + this.getMd5KeyId() + ", md5Key=" + this.getMd5Key() + ")";
    }
}

