/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class StaticRoutingVO {
    private String id;
    @NotNull(message="StaticRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    private @NotNull(message="StaticRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="StaticRouting parameter [status] should not be null")
    private @NotNull(message="StaticRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="StaticRouting parameter [destinations] should not be null")
    @Size(min=1, max=16, message="The size of [destinations] should be between 1 and 16.")
    private @NotNull(message="StaticRouting parameter [destinations] should not be null") @Size(min=1, max=16, message="The size of [destinations] should be between 1 and 16.") List<String> destinations;
    @NotNull(message="StaticRouting parameter [routeType] should not be null")
    @Range(min=0L, max=1L)
    private @NotNull(message="StaticRouting parameter [routeType] should not be null") @Range(min=0L, max=1L) Integer routeType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.") String nextHopIp;
    @Range(min=0L, max=5L)
    private @Range(min=0L, max=5L) Integer interfaceType;
    private String interfaceId;
    @NotNull(message="StaticRouting parameter [metric] should not be null")
    @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.")
    private @NotNull(message="StaticRouting parameter [metric] should not be null") @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.") Integer metric;
    private Boolean existVpnClient;
    private Boolean existVirtualWan;
    private Integer resource;

    public OperationResponse validate() {
        if (CollectionUtils.isEmpty(this.getDestinations())) {
            return new OperationResponse(b.kr);
        }
        for (String destination : this.getDestinations()) {
            if (java.util.regex.Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b").matcher(destination).matches()) continue;
            return new OperationResponse(b.Ag);
        }
        return OperationResponse.SUCCESS;
    }

    public StaticRoutingVO clone() {
        return new StaticRoutingVO().setId(this.getId()).setName(this.name).setStatus(this.status).setDestinations(this.destinations).setRouteType(this.routeType).setNextHopIp(this.nextHopIp).setInterfaceId(this.interfaceId).setInterfaceType(this.interfaceType).setMetric(this.metric);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDestinations() {
        return this.destinations;
    }

    @Generated
    public Integer getRouteType() {
        return this.routeType;
    }

    @Generated
    public String getNextHopIp() {
        return this.nextHopIp;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public Integer getMetric() {
        return this.metric;
    }

    @Generated
    public Boolean getExistVpnClient() {
        return this.existVpnClient;
    }

    @Generated
    public Boolean getExistVirtualWan() {
        return this.existVirtualWan;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public StaticRoutingVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public StaticRoutingVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StaticRoutingVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public StaticRoutingVO setDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    @Generated
    public StaticRoutingVO setRouteType(Integer routeType) {
        this.routeType = routeType;
        return this;
    }

    @Generated
    public StaticRoutingVO setNextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
        return this;
    }

    @Generated
    public StaticRoutingVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public StaticRoutingVO setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public StaticRoutingVO setMetric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @Generated
    public StaticRoutingVO setExistVpnClient(Boolean existVpnClient) {
        this.existVpnClient = existVpnClient;
        return this;
    }

    @Generated
    public StaticRoutingVO setExistVirtualWan(Boolean existVirtualWan) {
        this.existVirtualWan = existVirtualWan;
        return this;
    }

    @Generated
    public StaticRoutingVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public String toString() {
        return "StaticRoutingVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", destinations=" + this.getDestinations() + ", routeType=" + this.getRouteType() + ", nextHopIp=" + this.getNextHopIp() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", metric=" + this.getMetric() + ", existVpnClient=" + this.getExistVpnClient() + ", existVirtualWan=" + this.getExistVirtualWan() + ", resource=" + this.getResource() + ")";
    }
}

