/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.web.site.common.PortIpVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class PortForwardingVO {
    private String id;
    private String site;
    @NotNull(message="PortForwarding parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    private @NotNull(message="PortForwarding parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="PortForwarding parameter [status] should not be null")
    private @NotNull(message="PortForwarding parameter [status] should not be null") Boolean status;
    @NotNull(message="PortForwarding parameter [from] should not be null")
    private @NotNull(message="PortForwarding parameter [from] should not be null") Integer from;
    private List<String> limitedAddresses;
    @NotNull(message="PortForwarding parameter [dMZ] should not be null")
    @JsonProperty(value="dMZ")
    private @NotNull(message="PortForwarding parameter [dMZ] should not be null") Boolean dMZ;
    private List<String> interfaceWanPortId;
    private List<String> virtualWanId;
    @Valid
    private List<PortIpVO> wanIps;
    @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [externalPort] should be xx or xx-xx, 1-65535.")
    private @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [externalPort] should be xx or xx-xx, 1-65535.") String externalPort;
    @NotNull(message="PortForwarding parameter [forwardIp] should not be null")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [forwardIp] Invalid.")
    private @NotNull(message="PortForwarding parameter [forwardIp] should not be null") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [forwardIp] Invalid.") String forwardIp;
    @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [forwardPort] should be xx or xx-xx, 1-65535.")
    private @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [forwardPort] should be xx or xx-xx, 1-65535.") String forwardPort;
    @Range(min=0L, max=2L)
    private @Range(min=0L, max=2L) Integer protocol;
    private Integer resource;
    private Boolean existWanIp;
    private Boolean existVirtualWan;

    public PortForwardingVO clone() {
        PortForwardingVO vo = new PortForwardingVO();
        vo.setId(this.id);
        vo.setSite(this.site);
        vo.setName(this.name);
        vo.setStatus(this.status);
        vo.setFrom(this.from);
        if (!CollectionUtils.isEmpty(this.limitedAddresses)) {
            vo.setLimitedAddresses(new ArrayList<String>(this.limitedAddresses));
        }
        vo.setDMZ(this.dMZ);
        if (!CollectionUtils.isEmpty(this.interfaceWanPortId)) {
            vo.setInterfaceWanPortId(new ArrayList<String>(this.interfaceWanPortId));
        }
        if (!CollectionUtils.isEmpty(this.virtualWanId)) {
            vo.setVirtualWanId(new ArrayList<String>(this.virtualWanId));
        }
        vo.setWanIps(CollectionUtils.isEmpty(this.wanIps) ? new ArrayList<PortIpVO>() : this.wanIps.stream().map(PortIpVO::clone).toList());
        vo.setExternalPort(this.externalPort);
        vo.setForwardIp(this.forwardIp);
        vo.setForwardPort(this.forwardPort);
        vo.setProtocol(this.protocol);
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getFrom() {
        return this.from;
    }

    @Generated
    public List<String> getLimitedAddresses() {
        return this.limitedAddresses;
    }

    @Generated
    public Boolean getDMZ() {
        return this.dMZ;
    }

    @Generated
    public List<String> getInterfaceWanPortId() {
        return this.interfaceWanPortId;
    }

    @Generated
    public List<String> getVirtualWanId() {
        return this.virtualWanId;
    }

    @Generated
    public List<PortIpVO> getWanIps() {
        return this.wanIps;
    }

    @Generated
    public String getExternalPort() {
        return this.externalPort;
    }

    @Generated
    public String getForwardIp() {
        return this.forwardIp;
    }

    @Generated
    public String getForwardPort() {
        return this.forwardPort;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public Boolean getExistWanIp() {
        return this.existWanIp;
    }

    @Generated
    public Boolean getExistVirtualWan() {
        return this.existVirtualWan;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setFrom(Integer from) {
        this.from = from;
    }

    @Generated
    public void setLimitedAddresses(List<String> limitedAddresses) {
        this.limitedAddresses = limitedAddresses;
    }

    @JsonProperty(value="dMZ")
    @Generated
    public void setDMZ(Boolean dMZ) {
        this.dMZ = dMZ;
    }

    @Generated
    public void setInterfaceWanPortId(List<String> interfaceWanPortId) {
        this.interfaceWanPortId = interfaceWanPortId;
    }

    @Generated
    public void setVirtualWanId(List<String> virtualWanId) {
        this.virtualWanId = virtualWanId;
    }

    @Generated
    public void setWanIps(List<PortIpVO> wanIps) {
        this.wanIps = wanIps;
    }

    @Generated
    public void setExternalPort(String externalPort) {
        this.externalPort = externalPort;
    }

    @Generated
    public void setForwardIp(String forwardIp) {
        this.forwardIp = forwardIp;
    }

    @Generated
    public void setForwardPort(String forwardPort) {
        this.forwardPort = forwardPort;
    }

    @Generated
    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public void setExistWanIp(Boolean existWanIp) {
        this.existWanIp = existWanIp;
    }

    @Generated
    public void setExistVirtualWan(Boolean existVirtualWan) {
        this.existVirtualWan = existVirtualWan;
    }

    @Generated
    public String toString() {
        return "PortForwardingVO(id=" + this.getId() + ", site=" + this.getSite() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", from=" + this.getFrom() + ", limitedAddresses=" + this.getLimitedAddresses() + ", dMZ=" + this.getDMZ() + ", interfaceWanPortId=" + this.getInterfaceWanPortId() + ", virtualWanId=" + this.getVirtualWanId() + ", wanIps=" + this.getWanIps() + ", externalPort=" + this.getExternalPort() + ", forwardIp=" + this.getForwardIp() + ", forwardPort=" + this.getForwardPort() + ", protocol=" + this.getProtocol() + ", resource=" + this.getResource() + ", existWanIp=" + this.getExistWanIp() + ", existVirtualWan=" + this.getExistVirtualWan() + ")";
    }
}

