/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto;

import com.tplink.smb.omada.common.access.OperationResponse;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PolicyRoutingVO {
    private String id;
    private Integer index;
    @NotNull(message="PolicyRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    private @NotNull(message="PolicyRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="PolicyRouting parameter [status] should not be null")
    private @NotNull(message="PolicyRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="PolicyRouting parameter [protocols] should not be null")
    private @NotNull(message="PolicyRouting parameter [protocols] should not be null") List<Integer> protocols;
    @Range(min=0L, max=4L, message="Parameter [interfaceType] should range from 0 and 4")
    private @Range(min=0L, max=4L, message="Parameter [interfaceType] should range from 0 and 4") Integer interfaceType;
    @Nullable
    private String interfaceId;
    @Nullable
    private List<String> wanPortIds;
    @Nullable
    private List<String> virtualWanIds;
    @Nullable
    private List<String> vpnIds;
    @NotNull(message="PolicyRouting parameter [backupInterface] should not be null")
    private @NotNull(message="PolicyRouting parameter [backupInterface] should not be null") Boolean backupInterface;
    @NotNull(message="PolicyRouting parameter [sourceType] should not be null")
    @Range(min=0L, max=2L)
    private @NotNull(message="PolicyRouting parameter [sourceType] should not be null") @Range(min=0L, max=2L) Integer sourceType;
    @NotNull(message="PolicyRouting parameter [sourceIds] should not be null")
    private @NotNull(message="PolicyRouting parameter [sourceIds] should not be null") List<String> sourceIds;
    @NotNull(message="PolicyRouting parameter [destinationType] should not be null")
    @Range(min=0L, max=10L)
    private @NotNull(message="PolicyRouting parameter [destinationType] should not be null") @Range(min=0L, max=10L) Integer destinationType;
    @NotNull(message="PolicyRouting parameter [destinationIds] should not be null")
    private @NotNull(message="PolicyRouting parameter [destinationIds] should not be null") List<String> destinationIds;
    private Boolean existVpnClient;
    private Boolean existVirtualWan;
    private Boolean existMulti;
    private Boolean existLocationGroupDest;
    private Boolean existDomainGroupDest;
    private Boolean existIpPortGroup;
    private Integer resource;
    private static final Integer DEST_TYPE_NETWORK = 0;
    private static final Integer DEST_TYPE_IP_PORT_GROUP = 2;
    private static final Integer DEST_TYPE_COUNTRY_GROUP = 9;
    private static final Integer DEST_TYPE_DOMAIN_GROUP = 10;
    private static final Integer MAX_SELECTED_DOMAIN_GROUP_NUM = 5;

    public PolicyRoutingVO clone() {
        return new PolicyRoutingVO().setId(this.id).setName(this.name).setIndex(this.index).setStatus(this.status).setProtocols(this.protocols).setInterfaceType(this.interfaceType).setInterfaceId(this.interfaceId).setWanPortIds(this.wanPortIds).setVpnIds(this.vpnIds).setVirtualWanIds(this.virtualWanIds).setBackupInterface(this.backupInterface).setSourceType(this.sourceType).setSourceIds(this.sourceIds).setDestinationType(this.destinationType).setDestinationIds(this.destinationIds);
    }

    public OperationResponse validate() {
        boolean validateDestinationType;
        boolean bl = validateDestinationType = this.getDestinationType() >= DEST_TYPE_NETWORK && this.getDestinationType() <= DEST_TYPE_IP_PORT_GROUP || this.getDestinationType() >= DEST_TYPE_COUNTRY_GROUP && this.getDestinationType() <= DEST_TYPE_DOMAIN_GROUP;
        if (!validateDestinationType) {
            return OperationResponse.PARAM_ERROR;
        }
        if (this.getDestinationType().equals(DEST_TYPE_DOMAIN_GROUP) && this.getDestinationIds().size() > MAX_SELECTED_DOMAIN_GROUP_NUM) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.ok();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<Integer> getProtocols() {
        return this.protocols;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Nullable
    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Nullable
    @Generated
    public List<String> getWanPortIds() {
        return this.wanPortIds;
    }

    @Nullable
    @Generated
    public List<String> getVirtualWanIds() {
        return this.virtualWanIds;
    }

    @Nullable
    @Generated
    public List<String> getVpnIds() {
        return this.vpnIds;
    }

    @Generated
    public Boolean getBackupInterface() {
        return this.backupInterface;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public Integer getDestinationType() {
        return this.destinationType;
    }

    @Generated
    public List<String> getDestinationIds() {
        return this.destinationIds;
    }

    @Generated
    public Boolean getExistVpnClient() {
        return this.existVpnClient;
    }

    @Generated
    public Boolean getExistVirtualWan() {
        return this.existVirtualWan;
    }

    @Generated
    public Boolean getExistMulti() {
        return this.existMulti;
    }

    @Generated
    public Boolean getExistLocationGroupDest() {
        return this.existLocationGroupDest;
    }

    @Generated
    public Boolean getExistDomainGroupDest() {
        return this.existDomainGroupDest;
    }

    @Generated
    public Boolean getExistIpPortGroup() {
        return this.existIpPortGroup;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public PolicyRoutingVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public PolicyRoutingVO setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Generated
    public PolicyRoutingVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public PolicyRoutingVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public PolicyRoutingVO setProtocols(List<Integer> protocols) {
        this.protocols = protocols;
        return this;
    }

    @Generated
    public PolicyRoutingVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public PolicyRoutingVO setInterfaceId(@Nullable String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public PolicyRoutingVO setWanPortIds(@Nullable List<String> wanPortIds) {
        this.wanPortIds = wanPortIds;
        return this;
    }

    @Generated
    public PolicyRoutingVO setVirtualWanIds(@Nullable List<String> virtualWanIds) {
        this.virtualWanIds = virtualWanIds;
        return this;
    }

    @Generated
    public PolicyRoutingVO setVpnIds(@Nullable List<String> vpnIds) {
        this.vpnIds = vpnIds;
        return this;
    }

    @Generated
    public PolicyRoutingVO setBackupInterface(Boolean backupInterface) {
        this.backupInterface = backupInterface;
        return this;
    }

    @Generated
    public PolicyRoutingVO setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Generated
    public PolicyRoutingVO setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
        return this;
    }

    @Generated
    public PolicyRoutingVO setDestinationType(Integer destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Generated
    public PolicyRoutingVO setDestinationIds(List<String> destinationIds) {
        this.destinationIds = destinationIds;
        return this;
    }

    @Generated
    public PolicyRoutingVO setExistVpnClient(Boolean existVpnClient) {
        this.existVpnClient = existVpnClient;
        return this;
    }

    @Generated
    public PolicyRoutingVO setExistVirtualWan(Boolean existVirtualWan) {
        this.existVirtualWan = existVirtualWan;
        return this;
    }

    @Generated
    public PolicyRoutingVO setExistMulti(Boolean existMulti) {
        this.existMulti = existMulti;
        return this;
    }

    @Generated
    public PolicyRoutingVO setExistLocationGroupDest(Boolean existLocationGroupDest) {
        this.existLocationGroupDest = existLocationGroupDest;
        return this;
    }

    @Generated
    public PolicyRoutingVO setExistDomainGroupDest(Boolean existDomainGroupDest) {
        this.existDomainGroupDest = existDomainGroupDest;
        return this;
    }

    @Generated
    public PolicyRoutingVO setExistIpPortGroup(Boolean existIpPortGroup) {
        this.existIpPortGroup = existIpPortGroup;
        return this;
    }

    @Generated
    public PolicyRoutingVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public String toString() {
        return "PolicyRoutingVO(id=" + this.getId() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", protocols=" + this.getProtocols() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", wanPortIds=" + this.getWanPortIds() + ", virtualWanIds=" + this.getVirtualWanIds() + ", vpnIds=" + this.getVpnIds() + ", backupInterface=" + this.getBackupInterface() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", destinationType=" + this.getDestinationType() + ", destinationIds=" + this.getDestinationIds() + ", existVpnClient=" + this.getExistVpnClient() + ", existVirtualWan=" + this.getExistVirtualWan() + ", existMulti=" + this.getExistMulti() + ", existLocationGroupDest=" + this.getExistLocationGroupDest() + ", existDomainGroupDest=" + this.getExistDomainGroupDest() + ", existIpPortGroup=" + this.getExistIpPortGroup() + ", resource=" + this.getResource() + ")";
    }
}

