/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.NtpServerVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.DeviceAccountSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.DstDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.SiteBindTemplateVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.a.a.a;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SiteVO {
    private String key;
    private String omadacId;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private Boolean primary;
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    private Set<String> tagIds;
    @NotNull(message="Parameter [region] is null")
    private @NotNull(message="Parameter [region] is null") String region;
    @NotNull(message="Parameter [timeZone] is null")
    private @NotNull(message="Parameter [timeZone] is null") String timeZone;
    @NotNull(message="Parameter [scenario] is null")
    private @NotNull(message="Parameter [scenario] is null") String scenario;
    @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class})
    @Nullable
    @PII(strategy=PIIMaskStrategy.TRUNC_2)
    private @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class}) Double longitude;
    @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class})
    @Nullable
    @PII(strategy=PIIMaskStrategy.TRUNC_2)
    private @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class}) Double latitude;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String address;
    private Boolean unplaced;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String mapToken;
    private DstDTO dst;
    private Boolean ntpEnable;
    @Valid
    @Size(max=5, message="NTP server address quantity must less than five")
    private @Valid @Size(max=5, message="NTP server address quantity must less than five") List<NtpServerVO> ntpServers;
    @Valid
    private DeviceAccountSettingVO deviceAccountSetting;
    private Boolean useGlobalMapToken;
    @NumberSet(value={0, 1}, message="Parameter [type] should be 0 or 1")
    private Integer type;
    private SiteBindTemplateVO template;
    private Boolean supportES;
    private Boolean supportL2;
    private Boolean supportL3;
    private Integer resource;

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public String getScenario() {
        return this.scenario;
    }

    @Nullable
    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Nullable
    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public Boolean getUnplaced() {
        return this.unplaced;
    }

    @Generated
    public String getMapToken() {
        return this.mapToken;
    }

    @Generated
    public DstDTO getDst() {
        return this.dst;
    }

    @Generated
    public Boolean getNtpEnable() {
        return this.ntpEnable;
    }

    @Generated
    public List<NtpServerVO> getNtpServers() {
        return this.ntpServers;
    }

    @Generated
    public DeviceAccountSettingVO getDeviceAccountSetting() {
        return this.deviceAccountSetting;
    }

    @Generated
    public Boolean getUseGlobalMapToken() {
        return this.useGlobalMapToken;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public SiteBindTemplateVO getTemplate() {
        return this.template;
    }

    @Generated
    public Boolean getSupportES() {
        return this.supportES;
    }

    @Generated
    public Boolean getSupportL2() {
        return this.supportL2;
    }

    @Generated
    public Boolean getSupportL3() {
        return this.supportL3;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public SiteVO setKey(String key) {
        this.key = key;
        return this;
    }

    @Generated
    public SiteVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Generated
    public SiteVO setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Generated
    public SiteVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public SiteVO setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
        return this;
    }

    @Generated
    public SiteVO setRegion(String region) {
        this.region = region;
        return this;
    }

    @Generated
    public SiteVO setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Generated
    public SiteVO setScenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    @Generated
    public SiteVO setLongitude(@Nullable Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @Generated
    public SiteVO setLatitude(@Nullable Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @Generated
    public SiteVO setAddress(String address) {
        this.address = address;
        return this;
    }

    @Generated
    public SiteVO setUnplaced(Boolean unplaced) {
        this.unplaced = unplaced;
        return this;
    }

    @Generated
    public SiteVO setMapToken(String mapToken) {
        this.mapToken = mapToken;
        return this;
    }

    @Generated
    public SiteVO setDst(DstDTO dst) {
        this.dst = dst;
        return this;
    }

    @Generated
    public SiteVO setNtpEnable(Boolean ntpEnable) {
        this.ntpEnable = ntpEnable;
        return this;
    }

    @Generated
    public SiteVO setNtpServers(List<NtpServerVO> ntpServers) {
        this.ntpServers = ntpServers;
        return this;
    }

    @Generated
    public SiteVO setDeviceAccountSetting(DeviceAccountSettingVO deviceAccountSetting) {
        this.deviceAccountSetting = deviceAccountSetting;
        return this;
    }

    @Generated
    public SiteVO setUseGlobalMapToken(Boolean useGlobalMapToken) {
        this.useGlobalMapToken = useGlobalMapToken;
        return this;
    }

    @Generated
    public SiteVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public SiteVO setTemplate(SiteBindTemplateVO template) {
        this.template = template;
        return this;
    }

    @Generated
    public SiteVO setSupportES(Boolean supportES) {
        this.supportES = supportES;
        return this;
    }

    @Generated
    public SiteVO setSupportL2(Boolean supportL2) {
        this.supportL2 = supportL2;
        return this;
    }

    @Generated
    public SiteVO setSupportL3(Boolean supportL3) {
        this.supportL3 = supportL3;
        return this;
    }

    @Generated
    public SiteVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public String toString() {
        return "SiteVO(key=" + this.getKey() + ", omadacId=" + this.getOmadacId() + ", primary=" + this.getPrimary() + ", name=" + this.getName() + ", tagIds=" + this.getTagIds() + ", region=" + this.getRegion() + ", timeZone=" + this.getTimeZone() + ", scenario=" + this.getScenario() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", address=" + this.getAddress() + ", unplaced=" + this.getUnplaced() + ", mapToken=" + this.getMapToken() + ", dst=" + this.getDst() + ", ntpEnable=" + this.getNtpEnable() + ", ntpServers=" + this.getNtpServers() + ", deviceAccountSetting=" + this.getDeviceAccountSetting() + ", useGlobalMapToken=" + this.getUseGlobalMapToken() + ", type=" + this.getType() + ", template=" + this.getTemplate() + ", supportES=" + this.getSupportES() + ", supportL2=" + this.getSupportL2() + ", supportL3=" + this.getSupportL3() + ", resource=" + this.getResource() + ")";
    }
}

