/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.a.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class DstTimeDTO {
    @NotNull(message="Daylight saving parameter [month] should not be null.", groups={a.a.class})
    @Range(min=1L, max=12L, message="Daylight saving parameter [month] should between 1 and 12.", groups={a.a.class})
    @Schema(name="month", description="Month of the DST config should be a value as follows: 1: January; 2: February; 3: March; 4: April; 5: May; 6: June; 7: July; 8: August; 9: September; 10: October; 11: November; 12: December.")
    private @NotNull(message="Daylight saving parameter [month] should not be null.", groups={a.a.class}) @Range(min=1L, max=12L, message="Daylight saving parameter [month] should between 1 and 12.", groups={a.a.class}) Integer month;
    @NotNull(message="Daylight saving parameter [serial] should not be null.", groups={a.a.class})
    @Range(min=1L, max=5L, message="Daylight saving parameter [serial] should between 1 and 5.", groups={a.a.class})
    @Schema(name="serial", description="Week of the DST config should be a value as follows: 1: 1st; 2: 2nd; 3: 3rd; 4: 4th; 5: Last.")
    private @NotNull(message="Daylight saving parameter [serial] should not be null.", groups={a.a.class}) @Range(min=1L, max=5L, message="Daylight saving parameter [serial] should between 1 and 5.", groups={a.a.class}) Integer serial;
    @NotNull(message="Daylight saving parameter [day] should not be null.", groups={a.a.class})
    @Range(min=1L, max=7L, message="Daylight saving parameter [day] should between 1 and 7.", groups={a.a.class})
    @Schema(name="day", description="Day of the DST config should be a value as follows: 1: Monday; 2: Tuesday; 3: Wednesday; 4: Thursday; 5: Friday; 6: Saturday; 7: Sunday.")
    private @NotNull(message="Daylight saving parameter [day] should not be null.", groups={a.a.class}) @Range(min=1L, max=7L, message="Daylight saving parameter [day] should between 1 and 7.", groups={a.a.class}) Integer day;
    @NotNull(message="Daylight saving parameter [hour] should not be null.", groups={a.a.class})
    @Range(min=0L, max=23L, message="Daylight saving parameter [hour] should between 0 and 23.", groups={a.a.class})
    @Schema(name="hour", description="Hour of the DST config should be within the range of 0\u201323.")
    private @NotNull(message="Daylight saving parameter [hour] should not be null.", groups={a.a.class}) @Range(min=0L, max=23L, message="Daylight saving parameter [hour] should between 0 and 23.", groups={a.a.class}) Integer hour;
    @NotNull(message="Daylight saving parameter [minute] should not be null.", groups={a.a.class})
    @Range(min=0L, max=59L, message="Daylight saving parameter [minute] should between 0 and 59.", groups={a.a.class})
    @Schema(name="minute", description="Minute of the DST config should be within the range of 0\u201359.")
    private @NotNull(message="Daylight saving parameter [minute] should not be null.", groups={a.a.class}) @Range(min=0L, max=59L, message="Daylight saving parameter [minute] should between 0 and 59.", groups={a.a.class}) Integer minute;

    public static DstTimeDTO buildByGlobal(com.tplink.smb.omada.global.common.dto.DstTimeDTO start) {
        return DstTimeDTO.builder().month(start.getMonth()).serial(start.getSerial()).day(start.getDay()).hour(start.getHour()).minute(start.getMinute()).build();
    }

    @Generated
    public static DstTimeDTOBuilder builder() {
        return new DstTimeDTOBuilder();
    }

    @Generated
    public Integer getMonth() {
        return this.month;
    }

    @Generated
    public Integer getSerial() {
        return this.serial;
    }

    @Generated
    public Integer getDay() {
        return this.day;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public DstTimeDTO setMonth(Integer month) {
        this.month = month;
        return this;
    }

    @Generated
    public DstTimeDTO setSerial(Integer serial) {
        this.serial = serial;
        return this;
    }

    @Generated
    public DstTimeDTO setDay(Integer day) {
        this.day = day;
        return this;
    }

    @Generated
    public DstTimeDTO setHour(Integer hour) {
        this.hour = hour;
        return this;
    }

    @Generated
    public DstTimeDTO setMinute(Integer minute) {
        this.minute = minute;
        return this;
    }

    @Generated
    public String toString() {
        return "DstTimeDTO(month=" + this.getMonth() + ", serial=" + this.getSerial() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ")";
    }

    @Generated
    public DstTimeDTO(Integer month, Integer serial, Integer day, Integer hour, Integer minute) {
        this.month = month;
        this.serial = serial;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
    }

    @Generated
    public DstTimeDTO() {
    }

    @Generated
    public static class DstTimeDTOBuilder {
        @Generated
        private Integer month;
        @Generated
        private Integer serial;
        @Generated
        private Integer day;
        @Generated
        private Integer hour;
        @Generated
        private Integer minute;

        @Generated
        DstTimeDTOBuilder() {
        }

        @Generated
        public DstTimeDTOBuilder month(Integer month) {
            this.month = month;
            return this;
        }

        @Generated
        public DstTimeDTOBuilder serial(Integer serial) {
            this.serial = serial;
            return this;
        }

        @Generated
        public DstTimeDTOBuilder day(Integer day) {
            this.day = day;
            return this;
        }

        @Generated
        public DstTimeDTOBuilder hour(Integer hour) {
            this.hour = hour;
            return this;
        }

        @Generated
        public DstTimeDTOBuilder minute(Integer minute) {
            this.minute = minute;
            return this;
        }

        @Generated
        public DstTimeDTO build() {
            return new DstTimeDTO(this.month, this.serial, this.day, this.hour, this.minute);
        }

        @Generated
        public String toString() {
            return "DstTimeDTO.DstTimeDTOBuilder(month=" + this.month + ", serial=" + this.serial + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ")";
        }
    }
}

