/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.dst.DstEnableAndModeDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.dst.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.DstTimeDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DstDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DstDTO.class);
    @Schema(name="enable", description="DST config status; If false, other parameters are not required.")
    private Boolean enable;
    @Schema(name="mode", description="DST config mode; If disable, other parameters are not required. 0: disable, 1: auto, 2: manually")
    private Integer mode;
    @Schema(name="start", description="DST start time config")
    private DstTimeDTO start;
    @Schema(name="end", description="DST end time config")
    private DstTimeDTO end;
    @Schema(name="status", description="DST available status")
    private Boolean status;
    @Schema(name="startTime", description="The timeStamp of the DST available start time")
    private Long startTime;
    @Schema(name="endTime", description="The timeStamp of the DST available end time")
    private Long endTime;
    @Schema(name="offset", description="DST offset config(Unit: ms); It should be a value as follows: [1800000, 3600000, 5400000, 7200000].")
    private Long offset;
    @Schema(name="nextStart", description="The timeStamp of the DST start time of the next year(Unit: ms)")
    private Long nextStart;
    @Schema(name="nextEnd", description="The timeStamp of the DST end time of the next year(Unit: ms)")
    private Long nextEnd;
    @Schema(name="timeZone", description="Timezone of the site")
    private String timeZone;
    @Schema(name="lastStart", description="The timeStamp of the DST start time of the last year(Unit: ms)")
    private Long lastStart;
    @Schema(name="lastEnd", description="The timeStamp of the DST end time of the last year(Unit: ms)")
    private Long lastEnd;

    public static DstDTO handleVO(DstDTO dstDTO) {
        log.debug("before handle the dstVO {}", (Object)dstDTO);
        if (dstDTO == null || Objects.isNull(dstDTO.getMode()) && Objects.isNull(dstDTO.getEnable())) {
            return dstDTO;
        }
        DstEnableAndModeDTO dstEnableAndModeDTO = a.a(dstDTO.getEnable(), dstDTO.getMode(), dstDTO.nullDataResolve());
        dstDTO.setEnable(dstEnableAndModeDTO.getEnable());
        dstDTO.setMode(dstEnableAndModeDTO.getMode());
        log.debug("End handle the dstVO {}", (Object)dstDTO);
        return dstDTO;
    }

    public boolean nullDataResolve() {
        boolean endNullData;
        if (this.getStart() == null || this.getEnd() == null || this.getOffset() == null) {
            return false;
        }
        boolean startNullData = this.getStart().getDay() == null || this.getStart().getMonth() == null || this.getStart().getMinute() == null || this.getStart().getSerial() == null || this.getStart().getHour() == null;
        boolean bl = endNullData = this.getEnd().getDay() == null || this.getEnd().getMonth() == null || this.getEnd().getMinute() == null || this.getEnd().getSerial() == null || this.getEnd().getHour() == null;
        return !startNullData && !endNullData;
    }

    @Generated
    public static DstDTOBuilder builder() {
        return new DstDTOBuilder();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public DstTimeDTO getStart() {
        return this.start;
    }

    @Generated
    public DstTimeDTO getEnd() {
        return this.end;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public Long getNextStart() {
        return this.nextStart;
    }

    @Generated
    public Long getNextEnd() {
        return this.nextEnd;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public Long getLastStart() {
        return this.lastStart;
    }

    @Generated
    public Long getLastEnd() {
        return this.lastEnd;
    }

    @Generated
    public DstDTO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public DstDTO setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public DstDTO setStart(DstTimeDTO start) {
        this.start = start;
        return this;
    }

    @Generated
    public DstDTO setEnd(DstTimeDTO end) {
        this.end = end;
        return this;
    }

    @Generated
    public DstDTO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public DstDTO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public DstDTO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public DstDTO setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    @Generated
    public DstDTO setNextStart(Long nextStart) {
        this.nextStart = nextStart;
        return this;
    }

    @Generated
    public DstDTO setNextEnd(Long nextEnd) {
        this.nextEnd = nextEnd;
        return this;
    }

    @Generated
    public DstDTO setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Generated
    public DstDTO setLastStart(Long lastStart) {
        this.lastStart = lastStart;
        return this;
    }

    @Generated
    public DstDTO setLastEnd(Long lastEnd) {
        this.lastEnd = lastEnd;
        return this;
    }

    @Generated
    public String toString() {
        return "DstDTO(enable=" + this.getEnable() + ", mode=" + this.getMode() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", status=" + this.getStatus() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", offset=" + this.getOffset() + ", nextStart=" + this.getNextStart() + ", nextEnd=" + this.getNextEnd() + ", timeZone=" + this.getTimeZone() + ", lastStart=" + this.getLastStart() + ", lastEnd=" + this.getLastEnd() + ")";
    }

    @Generated
    public DstDTO(Boolean enable, Integer mode, DstTimeDTO start, DstTimeDTO end, Boolean status, Long startTime, Long endTime, Long offset, Long nextStart, Long nextEnd, String timeZone, Long lastStart, Long lastEnd) {
        this.enable = enable;
        this.mode = mode;
        this.start = start;
        this.end = end;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.offset = offset;
        this.nextStart = nextStart;
        this.nextEnd = nextEnd;
        this.timeZone = timeZone;
        this.lastStart = lastStart;
        this.lastEnd = lastEnd;
    }

    @Generated
    public DstDTO() {
    }

    @Generated
    public static class DstDTOBuilder {
        @Generated
        private Boolean enable;
        @Generated
        private Integer mode;
        @Generated
        private DstTimeDTO start;
        @Generated
        private DstTimeDTO end;
        @Generated
        private Boolean status;
        @Generated
        private Long startTime;
        @Generated
        private Long endTime;
        @Generated
        private Long offset;
        @Generated
        private Long nextStart;
        @Generated
        private Long nextEnd;
        @Generated
        private String timeZone;
        @Generated
        private Long lastStart;
        @Generated
        private Long lastEnd;

        @Generated
        DstDTOBuilder() {
        }

        @Generated
        public DstDTOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public DstDTOBuilder mode(Integer mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public DstDTOBuilder start(DstTimeDTO start) {
            this.start = start;
            return this;
        }

        @Generated
        public DstDTOBuilder end(DstTimeDTO end) {
            this.end = end;
            return this;
        }

        @Generated
        public DstDTOBuilder status(Boolean status) {
            this.status = status;
            return this;
        }

        @Generated
        public DstDTOBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public DstDTOBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        @Generated
        public DstDTOBuilder offset(Long offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public DstDTOBuilder nextStart(Long nextStart) {
            this.nextStart = nextStart;
            return this;
        }

        @Generated
        public DstDTOBuilder nextEnd(Long nextEnd) {
            this.nextEnd = nextEnd;
            return this;
        }

        @Generated
        public DstDTOBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Generated
        public DstDTOBuilder lastStart(Long lastStart) {
            this.lastStart = lastStart;
            return this;
        }

        @Generated
        public DstDTOBuilder lastEnd(Long lastEnd) {
            this.lastEnd = lastEnd;
            return this;
        }

        @Generated
        public DstDTO build() {
            return new DstDTO(this.enable, this.mode, this.start, this.end, this.status, this.startTime, this.endTime, this.offset, this.nextStart, this.nextEnd, this.timeZone, this.lastStart, this.lastEnd);
        }

        @Generated
        public String toString() {
            return "DstDTO.DstDTOBuilder(enable=" + this.enable + ", mode=" + this.mode + ", start=" + this.start + ", end=" + this.end + ", status=" + this.status + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", offset=" + this.offset + ", nextStart=" + this.nextStart + ", nextEnd=" + this.nextEnd + ", timeZone=" + this.timeZone + ", lastStart=" + this.lastStart + ", lastEnd=" + this.lastEnd + ")";
        }
    }
}

