/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.sms.message;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.CallingCodeUtils;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.SimQuotaSettingVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SendMessageVO {
    @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.")
    private @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.") String callingCode;
    @NotNull(message="Message parameter [receiver] should not be null.")
    @Pattern(regexp="\\d{1,20}", message="Parameter [receiver] Invalid.")
    private @NotNull(message="Message parameter [receiver] should not be null.") @Pattern(regexp="\\d{1,20}", message="Parameter [receiver] Invalid.") String receiver;
    @NotNull(message="Message parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="Message parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    private String content;
    private SimQuotaSettingVO test;
    private Integer simCard;

    public OperationResponse validate() {
        if (this.callingCode != null && CallingCodeUtils.a((String)this.callingCode) == null) {
            return new OperationResponse(b.d);
        }
        if (Objects.equals(this.type, a.d)) {
            if (this.content == null) {
                return new OperationResponse(b.d);
            }
            if (!this.validateContent(this.content).booleanValue()) {
                return new OperationResponse(b.xt);
            }
        }
        if (Objects.equals(this.type, a.e) && this.test == null) {
            return new OperationResponse(b.d);
        }
        return OperationResponse.SUCCESS;
    }

    public Boolean validateContent(String content) {
        List<Character> gsm7BasicList = a.a();
        List<Character> gsm7ExtendedList = a.b();
        int length = 0;
        char[] cArray = content.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Character ch = Character.valueOf(cArray[i2]);
            if (!gsm7BasicList.contains(ch) && !gsm7ExtendedList.contains(ch)) {
                return content.length() <= a.g;
            }
            if (gsm7BasicList.contains(ch)) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length <= a.f;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public SimQuotaSettingVO getTest() {
        return this.test;
    }

    @Generated
    public Integer getSimCard() {
        return this.simCard;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTest(SimQuotaSettingVO test) {
        this.test = test;
    }

    @Generated
    public void setSimCard(Integer simCard) {
        this.simCard = simCard;
    }

    @Generated
    public String toString() {
        return "SendMessageVO(callingCode=" + this.getCallingCode() + ", receiver=" + this.getReceiver() + ", type=" + this.getType() + ", content=" + this.getContent() + ", test=" + this.getTest() + ", simCard=" + this.getSimCard() + ")";
    }
}

