/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.CallingCodeUtils;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.a;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QuotaDataSettingVO {
    private Float used;
    @NotNull(message="Data parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="Data parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    @Range(min=1L, max=31L, message="Value of startDate is from 0 to 31.")
    private @Range(min=1L, max=31L, message="Value of startDate is from 0 to 31.") Integer startDate;
    @NotNull(message="Data parameter [limit] should not be null.")
    private @NotNull(message="Data parameter [limit] should not be null.") Boolean limit;
    private Float credit;
    @Range(min=2L, max=3L, message="Value of creditUnit is from 2 to 3.")
    private @Range(min=2L, max=3L, message="Value of creditUnit is from 2 to 3.") Integer creditUnit;
    private Boolean alert;
    @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.") Integer usage;
    @Size(min=2, max=2, message="Value of countryCode is 2.")
    private @Size(min=2, max=2, message="Value of countryCode is 2.") String countryCode;
    @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.")
    private @Pattern(regexp="\\+\\d{1,4}", message="Parameter [callingCode] Invalid.") String callingCode;
    @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.")
    private @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.") String phone;
    private Integer resource;

    public OperationResponse validate() {
        if (Objects.equals(this.type, a.b) && this.startDate == null) {
            return new OperationResponse(b.d);
        }
        if (Boolean.TRUE.equals(this.limit)) {
            if (this.credit == null || this.creditUnit == null) {
                return new OperationResponse(b.d);
            }
            if (this.credit.floatValue() < 0.0f || this.credit.floatValue() > a.c.floatValue()) {
                return new OperationResponse(b.d);
            }
            if (this.alert == null) {
                return new OperationResponse(b.d);
            }
        }
        if (Boolean.TRUE.equals(this.alert)) {
            if (this.usage == null) {
                return new OperationResponse(b.d);
            }
            if (this.callingCode != null && (this.countryCode != null ? CallingCodeUtils.a((String)this.countryCode, (String)this.callingCode) == null : CallingCodeUtils.a((String)this.callingCode) == null)) {
                return new OperationResponse(b.d);
            }
            if (this.phone == null) {
                return new OperationResponse(b.d);
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public static QuotaDataSettingVOBuilder builder() {
        return new QuotaDataSettingVOBuilder();
    }

    @Generated
    public Float getUsed() {
        return this.used;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getStartDate() {
        return this.startDate;
    }

    @Generated
    public Boolean getLimit() {
        return this.limit;
    }

    @Generated
    public Float getCredit() {
        return this.credit;
    }

    @Generated
    public Integer getCreditUnit() {
        return this.creditUnit;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Integer getUsage() {
        return this.usage;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setUsed(Float used) {
        this.used = used;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setStartDate(Integer startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Generated
    public void setCredit(Float credit) {
        this.credit = credit;
    }

    @Generated
    public void setCreditUnit(Integer creditUnit) {
        this.creditUnit = creditUnit;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setUsage(Integer usage) {
        this.usage = usage;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "QuotaDataSettingVO(used=" + this.getUsed() + ", type=" + this.getType() + ", startDate=" + this.getStartDate() + ", limit=" + this.getLimit() + ", credit=" + this.getCredit() + ", creditUnit=" + this.getCreditUnit() + ", alert=" + this.getAlert() + ", usage=" + this.getUsage() + ", countryCode=" + this.getCountryCode() + ", callingCode=" + this.getCallingCode() + ", phone=" + this.getPhone() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public QuotaDataSettingVO() {
    }

    @Generated
    public QuotaDataSettingVO(Float used, Integer type, Integer startDate, Boolean limit, Float credit, Integer creditUnit, Boolean alert, Integer usage, String countryCode, String callingCode, String phone, Integer resource) {
        this.used = used;
        this.type = type;
        this.startDate = startDate;
        this.limit = limit;
        this.credit = credit;
        this.creditUnit = creditUnit;
        this.alert = alert;
        this.usage = usage;
        this.countryCode = countryCode;
        this.callingCode = callingCode;
        this.phone = phone;
        this.resource = resource;
    }

    @Generated
    public static class QuotaDataSettingVOBuilder {
        @Generated
        private Float used;
        @Generated
        private Integer type;
        @Generated
        private Integer startDate;
        @Generated
        private Boolean limit;
        @Generated
        private Float credit;
        @Generated
        private Integer creditUnit;
        @Generated
        private Boolean alert;
        @Generated
        private Integer usage;
        @Generated
        private String countryCode;
        @Generated
        private String callingCode;
        @Generated
        private String phone;
        @Generated
        private Integer resource;

        @Generated
        QuotaDataSettingVOBuilder() {
        }

        @Generated
        public QuotaDataSettingVOBuilder used(Float used) {
            this.used = used;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder startDate(Integer startDate) {
            this.startDate = startDate;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder limit(Boolean limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder credit(Float credit) {
            this.credit = credit;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder creditUnit(Integer creditUnit) {
            this.creditUnit = creditUnit;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder alert(Boolean alert) {
            this.alert = alert;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder usage(Integer usage) {
            this.usage = usage;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder callingCode(String callingCode) {
            this.callingCode = callingCode;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        @Generated
        public QuotaDataSettingVOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public QuotaDataSettingVO build() {
            return new QuotaDataSettingVO(this.used, this.type, this.startDate, this.limit, this.credit, this.creditUnit, this.alert, this.usage, this.countryCode, this.callingCode, this.phone, this.resource);
        }

        @Generated
        public String toString() {
            return "QuotaDataSettingVO.QuotaDataSettingVOBuilder(used=" + this.used + ", type=" + this.type + ", startDate=" + this.startDate + ", limit=" + this.limit + ", credit=" + this.credit + ", creditUnit=" + this.creditUnit + ", alert=" + this.alert + ", usage=" + this.usage + ", countryCode=" + this.countryCode + ", callingCode=" + this.callingCode + ", phone=" + this.phone + ", resource=" + this.resource + ")";
        }
    }
}

