/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.app.quota;

import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.QuotaSmsSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.SimQuotaSettingVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QuotaSmsSettingAppVO {
    private Integer used;
    @NotNull(message="Sms parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="Sms parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    @Range(min=1L, max=31L, message="Value of startDate is from 1 to 31.")
    private @Range(min=1L, max=31L, message="Value of startDate is from 1 to 31.") Integer startDate;
    @NotNull(message="Sms parameter [limit] should not be null.")
    private @NotNull(message="Sms parameter [limit] should not be null.") Boolean limit;
    @Range(min=0L, max=100000L, message="Value of credit is from 0 to 100000.")
    private @Range(min=0L, max=100000L, message="Value of credit is from 0 to 100000.") Integer credit;
    private Boolean alert;
    @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.") Integer usage;
    @Size(min=2, max=2, message="Value of countryCode is 2.")
    private @Size(min=2, max=2, message="Value of countryCode is 2.") String countryCode;
    @Size(min=2, max=5, message="Value of callingCode is from 2 to 5.")
    private @Size(min=2, max=5, message="Value of callingCode is from 2 to 5.") String callingCode;
    @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.")
    private @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.") String phone;

    public static QuotaSmsSettingAppVO toAppVO(SimQuotaSettingVO vo) {
        if (vo == null || vo.getSmsSetting() == null) {
            return new QuotaSmsSettingAppVO();
        }
        QuotaSmsSettingAppVO appVO = new QuotaSmsSettingAppVO();
        appVO.setUsed(vo.getSmsSetting().getUsed());
        appVO.setType(vo.getSmsSetting().getType());
        appVO.setStartDate(vo.getSmsSetting().getStartDate());
        appVO.setLimit(vo.getSmsSetting().getLimit());
        appVO.setCredit(vo.getSmsSetting().getCredit());
        appVO.setAlert(vo.getSmsSetting().getAlert());
        appVO.setUsage(vo.getSmsSetting().getUsage());
        appVO.setCountryCode(vo.getSmsSetting().getCountryCode());
        appVO.setCallingCode(vo.getSmsSetting().getCallingCode());
        appVO.setPhone(vo.getSmsSetting().getPhone());
        return appVO;
    }

    public static SimQuotaSettingVO toVO(QuotaSmsSettingAppVO appVO) {
        if (appVO == null) {
            return SimQuotaSettingVO.builder().smsSetting(QuotaSmsSettingVO.builder().build()).build();
        }
        return SimQuotaSettingVO.builder().smsSetting(QuotaSmsSettingVO.builder().used(appVO.getUsed()).type(appVO.getType()).startDate(appVO.getStartDate()).limit(appVO.getLimit()).credit(appVO.getCredit()).alert(appVO.getAlert()).usage(appVO.getUsage()).countryCode(appVO.getCountryCode()).callingCode(appVO.getCallingCode()).phone(appVO.getPhone()).build()).build();
    }

    @Generated
    public Integer getUsed() {
        return this.used;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getStartDate() {
        return this.startDate;
    }

    @Generated
    public Boolean getLimit() {
        return this.limit;
    }

    @Generated
    public Integer getCredit() {
        return this.credit;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Integer getUsage() {
        return this.usage;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public void setUsed(Integer used) {
        this.used = used;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setStartDate(Integer startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Generated
    public void setCredit(Integer credit) {
        this.credit = credit;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setUsage(Integer usage) {
        this.usage = usage;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public String toString() {
        return "QuotaSmsSettingAppVO(used=" + this.getUsed() + ", type=" + this.getType() + ", startDate=" + this.getStartDate() + ", limit=" + this.getLimit() + ", credit=" + this.getCredit() + ", alert=" + this.getAlert() + ", usage=" + this.getUsage() + ", countryCode=" + this.getCountryCode() + ", callingCode=" + this.getCallingCode() + ", phone=" + this.getPhone() + ")";
    }

    @Generated
    public QuotaSmsSettingAppVO() {
    }

    @Generated
    public QuotaSmsSettingAppVO(Integer used, Integer type, Integer startDate, Boolean limit, Integer credit, Boolean alert, Integer usage, String countryCode, String callingCode, String phone) {
        this.used = used;
        this.type = type;
        this.startDate = startDate;
        this.limit = limit;
        this.credit = credit;
        this.alert = alert;
        this.usage = usage;
        this.countryCode = countryCode;
        this.callingCode = callingCode;
        this.phone = phone;
    }
}

