/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.app.quota;

import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.QuotaDataSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sim.dto.quota.SimQuotaSettingVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QuotaDataSettingAppVO {
    private Float used;
    @NotNull(message="Data parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="Data parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer type;
    @Range(min=1L, max=31L, message="Value of startDate is from 1 to 31.")
    private @Range(min=1L, max=31L, message="Value of startDate is from 1 to 31.") Integer startDate;
    @NotNull(message="Data parameter [limit] should not be null.")
    private @NotNull(message="Data parameter [limit] should not be null.") Boolean limit;
    private Float credit;
    @Range(min=2L, max=3L, message="Value of creditUnit is from 2 to 3.")
    private @Range(min=2L, max=3L, message="Value of creditUnit is from 2 to 3.") Integer creditUnit;
    private Boolean alert;
    @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of usage is from 0 to 100.") Integer usage;
    @Size(min=2, max=2, message="Value of countryCode is 2.")
    private @Size(min=2, max=2, message="Value of countryCode is 2.") String countryCode;
    @Size(min=2, max=5, message="Value of callingCode is from 2 to 5.")
    private @Size(min=2, max=5, message="Value of callingCode is from 2 to 5.") String callingCode;
    @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.")
    private @Pattern(regexp="\\d{1,20}", message="Parameter [phone] Invalid.") String phone;

    public static QuotaDataSettingAppVO toAppVO(SimQuotaSettingVO vo) {
        if (vo == null || vo.getDataSetting() == null) {
            return new QuotaDataSettingAppVO();
        }
        QuotaDataSettingAppVO appVO = new QuotaDataSettingAppVO();
        appVO.setUsed(vo.getDataSetting().getUsed());
        appVO.setType(vo.getDataSetting().getType());
        appVO.setStartDate(vo.getDataSetting().getStartDate());
        appVO.setLimit(vo.getDataSetting().getLimit());
        appVO.setCredit(vo.getDataSetting().getCredit());
        appVO.setCreditUnit(vo.getDataSetting().getCreditUnit());
        appVO.setAlert(vo.getDataSetting().getAlert());
        appVO.setUsage(vo.getDataSetting().getUsage());
        appVO.setCountryCode(vo.getDataSetting().getCountryCode());
        appVO.setCallingCode(vo.getDataSetting().getCallingCode());
        appVO.setPhone(vo.getDataSetting().getPhone());
        return appVO;
    }

    public static SimQuotaSettingVO toVO(QuotaDataSettingAppVO appVO) {
        if (appVO == null) {
            return SimQuotaSettingVO.builder().dataSetting(QuotaDataSettingVO.builder().build()).build();
        }
        return SimQuotaSettingVO.builder().dataSetting(QuotaDataSettingVO.builder().used(appVO.getUsed()).type(appVO.getType()).startDate(appVO.getStartDate()).limit(appVO.getLimit()).credit(appVO.getCredit()).creditUnit(appVO.getCreditUnit()).alert(appVO.getAlert()).usage(appVO.getUsage()).countryCode(appVO.getCountryCode()).callingCode(appVO.getCallingCode()).phone(appVO.getPhone()).build()).build();
    }

    @Generated
    public static QuotaDataSettingAppVOBuilder builder() {
        return new QuotaDataSettingAppVOBuilder();
    }

    @Generated
    public Float getUsed() {
        return this.used;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getStartDate() {
        return this.startDate;
    }

    @Generated
    public Boolean getLimit() {
        return this.limit;
    }

    @Generated
    public Float getCredit() {
        return this.credit;
    }

    @Generated
    public Integer getCreditUnit() {
        return this.creditUnit;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Integer getUsage() {
        return this.usage;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getCallingCode() {
        return this.callingCode;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public void setUsed(Float used) {
        this.used = used;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setStartDate(Integer startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Generated
    public void setCredit(Float credit) {
        this.credit = credit;
    }

    @Generated
    public void setCreditUnit(Integer creditUnit) {
        this.creditUnit = creditUnit;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setUsage(Integer usage) {
        this.usage = usage;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public void setCallingCode(String callingCode) {
        this.callingCode = callingCode;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public String toString() {
        return "QuotaDataSettingAppVO(used=" + this.getUsed() + ", type=" + this.getType() + ", startDate=" + this.getStartDate() + ", limit=" + this.getLimit() + ", credit=" + this.getCredit() + ", creditUnit=" + this.getCreditUnit() + ", alert=" + this.getAlert() + ", usage=" + this.getUsage() + ", countryCode=" + this.getCountryCode() + ", callingCode=" + this.getCallingCode() + ", phone=" + this.getPhone() + ")";
    }

    @Generated
    public QuotaDataSettingAppVO() {
    }

    @Generated
    public QuotaDataSettingAppVO(Float used, Integer type, Integer startDate, Boolean limit, Float credit, Integer creditUnit, Boolean alert, Integer usage, String countryCode, String callingCode, String phone) {
        this.used = used;
        this.type = type;
        this.startDate = startDate;
        this.limit = limit;
        this.credit = credit;
        this.creditUnit = creditUnit;
        this.alert = alert;
        this.usage = usage;
        this.countryCode = countryCode;
        this.callingCode = callingCode;
        this.phone = phone;
    }

    @Generated
    public static class QuotaDataSettingAppVOBuilder {
        @Generated
        private Float used;
        @Generated
        private Integer type;
        @Generated
        private Integer startDate;
        @Generated
        private Boolean limit;
        @Generated
        private Float credit;
        @Generated
        private Integer creditUnit;
        @Generated
        private Boolean alert;
        @Generated
        private Integer usage;
        @Generated
        private String countryCode;
        @Generated
        private String callingCode;
        @Generated
        private String phone;

        @Generated
        QuotaDataSettingAppVOBuilder() {
        }

        @Generated
        public QuotaDataSettingAppVOBuilder used(Float used) {
            this.used = used;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder startDate(Integer startDate) {
            this.startDate = startDate;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder limit(Boolean limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder credit(Float credit) {
            this.credit = credit;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder creditUnit(Integer creditUnit) {
            this.creditUnit = creditUnit;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder alert(Boolean alert) {
            this.alert = alert;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder usage(Integer usage) {
            this.usage = usage;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder callingCode(String callingCode) {
            this.callingCode = callingCode;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVOBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        @Generated
        public QuotaDataSettingAppVO build() {
            return new QuotaDataSettingAppVO(this.used, this.type, this.startDate, this.limit, this.credit, this.creditUnit, this.alert, this.usage, this.countryCode, this.callingCode, this.phone);
        }

        @Generated
        public String toString() {
            return "QuotaDataSettingAppVO.QuotaDataSettingAppVOBuilder(used=" + this.used + ", type=" + this.type + ", startDate=" + this.startDate + ", limit=" + this.limit + ", credit=" + this.credit + ", creditUnit=" + this.creditUnit + ", alert=" + this.alert + ", usage=" + this.usage + ", countryCode=" + this.countryCode + ", callingCode=" + this.callingCode + ", phone=" + this.phone + ")";
        }
    }
}

