/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.embed;

import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class BaseScheduleTimeVO {
    private static Set<Integer> littleMonthSet = new HashSet<Integer>(Arrays.asList(2, 4, 6, 9, 11));
    @NotNull
    @Range(min=1L, max=4L)
    private @NotNull @Range(min=1L, max=4L) Integer timingType;
    @NotNull(message="Operator parameter [hour] should not be null.")
    @Range(min=0L, max=23L)
    private @NotNull(message="Operator parameter [hour] should not be null.") @Range(min=0L, max=23L) Integer hour;
    @NotNull(message="Operator parameter [minute] should not be null.")
    @Range(min=0L, max=59L)
    private @NotNull(message="Operator parameter [minute] should not be null.") @Range(min=0L, max=59L) Integer minute;
    @Range(min=0L, max=6L)
    private @Range(min=0L, max=6L) Integer dayOfWeek;
    @Range(min=1L, max=31L)
    private @Range(min=1L, max=31L) Integer dayOfMonth;
    @Range(min=1L, max=12L)
    private @Range(min=1L, max=12L) Integer monthOfYear;

    public boolean validTime() {
        if (4 == this.timingType) {
            if (littleMonthSet.contains(this.monthOfYear) && 31 == this.dayOfMonth) {
                return false;
            }
            if (2 == this.monthOfYear && (30 == this.dayOfMonth || 31 == this.dayOfMonth)) {
                return false;
            }
        }
        return true;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Generated
    public Integer getMonthOfYear() {
        return this.monthOfYear;
    }

    @Generated
    public void setTimingType(Integer timingType) {
        this.timingType = timingType;
    }

    @Generated
    public void setHour(Integer hour) {
        this.hour = hour;
    }

    @Generated
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @Generated
    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    @Generated
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    @Generated
    public void setMonthOfYear(Integer monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    @Generated
    public String toString() {
        return "BaseScheduleTimeVO(timingType=" + this.getTimingType() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", dayOfWeek=" + this.getDayOfWeek() + ", dayOfMonth=" + this.getDayOfMonth() + ", monthOfYear=" + this.getMonthOfYear() + ")";
    }
}

