/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PPSKRateLimitSettingVO {
    @Schema(name="rateLimitProfileId", description="This field represents Rate limit profile ID. Rate limit profile can be created using 'Create rate limit profile' interface, and Rate limit profile ID can be obtained from 'Get rate limit profile list' interface")
    private String rateLimitId;
    @Schema(name="downLimitEnable", description="Whether to limit downlink speed; This field is required when select custom setting. True: enable, false: disable.")
    private Boolean downLimitEnable;
    @Schema(name="downLimit", description="Downlink speed limit value. When the value of Parameter [downLimitType] is 0(Kbps), downLimit should be within the range of 1\u201310485760; when the value of Parameter [downLimitType] is 1(Mbps), downLimit should be within the range of 1-10240.")
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.") Integer downLimit;
    @Schema(name="downLimitType", description="Downlink speed limit unit config; DownLimitType should be a value as follows: 0: Kbps; 1: Mbps.")
    @NumberSet(value={0, 1}, message="Parameter [downLimitType] should be 0 or 1")
    private Integer downLimitType;
    @Schema(name="upLimitEnable", description="Whether to limit uplink speed; This field is required when select custom setting. True: enable, false: disable.")
    private Boolean upLimitEnable;
    @Schema(name="upLimit", description="Uplink speed limit value. When the value of Parameter [upLimitType] is 0(Kbps), upLimit should be within the range of 1\u201310485760; when the value of Parameter [upLimitType] is 1(Mbps), upLimit should be within the range of 1-10240.")
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.") Integer upLimit;
    @Schema(name="upLimitType", description="Uplink speed limit unit config; UpLimitType should be a value as follows: 0: Kbps; 1: Mbps.")
    @NumberSet(value={0, 1}, message="Parameter [upLimitType] should be 0 or 1")
    private Integer upLimitType;

    public boolean validate() {
        if (this.rateLimitId != null && (Boolean.TRUE.equals(this.downLimitEnable) || Boolean.TRUE.equals(this.upLimitEnable))) {
            return false;
        }
        if (Boolean.TRUE.equals(this.downLimitEnable) && (this.downLimit == null || this.downLimitType == null)) {
            return false;
        }
        if (Boolean.TRUE.equals(this.downLimitEnable) && Objects.equals(this.downLimitType, 1) && this.downLimit > 10240) {
            return false;
        }
        if (Boolean.TRUE.equals(this.upLimitEnable) && (this.upLimit == null || this.upLimitType == null)) {
            return false;
        }
        return !Boolean.TRUE.equals(this.upLimitEnable) || !Objects.equals(this.upLimitType, 1) || this.upLimit <= 10240;
    }

    public static PPSKRateLimitSettingVO buildDefault() {
        return new PPSKRateLimitSettingVO().setDownLimitEnable(false).setUpLimitEnable(false);
    }

    @Generated
    public String getRateLimitId() {
        return this.rateLimitId;
    }

    @Generated
    public Boolean getDownLimitEnable() {
        return this.downLimitEnable;
    }

    @Generated
    public Integer getDownLimit() {
        return this.downLimit;
    }

    @Generated
    public Integer getDownLimitType() {
        return this.downLimitType;
    }

    @Generated
    public Boolean getUpLimitEnable() {
        return this.upLimitEnable;
    }

    @Generated
    public Integer getUpLimit() {
        return this.upLimit;
    }

    @Generated
    public Integer getUpLimitType() {
        return this.upLimitType;
    }

    @Generated
    public PPSKRateLimitSettingVO setRateLimitId(String rateLimitId) {
        this.rateLimitId = rateLimitId;
        return this;
    }

    @Generated
    public PPSKRateLimitSettingVO setDownLimitEnable(Boolean downLimitEnable) {
        this.downLimitEnable = downLimitEnable;
        return this;
    }

    @Generated
    public PPSKRateLimitSettingVO setDownLimit(Integer downLimit) {
        this.downLimit = downLimit;
        return this;
    }

    @Generated
    public PPSKRateLimitSettingVO setDownLimitType(Integer downLimitType) {
        this.downLimitType = downLimitType;
        return this;
    }

    @Generated
    public PPSKRateLimitSettingVO setUpLimitEnable(Boolean upLimitEnable) {
        this.upLimitEnable = upLimitEnable;
        return this;
    }

    @Generated
    public PPSKRateLimitSettingVO setUpLimit(Integer upLimit) {
        this.upLimit = upLimit;
        return this;
    }

    @Generated
    public PPSKRateLimitSettingVO setUpLimitType(Integer upLimitType) {
        this.upLimitType = upLimitType;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKRateLimitSettingVO(rateLimitId=" + this.getRateLimitId() + ", downLimitEnable=" + this.getDownLimitEnable() + ", downLimit=" + this.getDownLimit() + ", downLimitType=" + this.getDownLimitType() + ", upLimitEnable=" + this.getUpLimitEnable() + ", upLimit=" + this.getUpLimit() + ", upLimitType=" + this.getUpLimitType() + ")";
    }

    @Generated
    public PPSKRateLimitSettingVO() {
    }

    @Generated
    public PPSKRateLimitSettingVO(String rateLimitId, Boolean downLimitEnable, Integer downLimit, Integer downLimitType, Boolean upLimitEnable, Integer upLimit, Integer upLimitType) {
        this.rateLimitId = rateLimitId;
        this.downLimitEnable = downLimitEnable;
        this.downLimit = downLimit;
        this.downLimitType = downLimitType;
        this.upLimitEnable = upLimitEnable;
        this.upLimit = upLimit;
        this.upLimitType = upLimitType;
    }
}

