/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.PSKVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKExpirationVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKRateLimitSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PPSKProfileVO {
    @Schema(name="id", description="PPSK Profile ID")
    private String id;
    @Schema(name="profileName", description="PPSK Profile Name")
    @NotNull(message="PPSK Profile name should not be null")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Radius profile name should be 1~64.")
    private @NotNull(message="PPSK Profile name should not be null") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Radius profile name should be 1~64.") String profileName;
    @Schema(name="ssid", description="Ssid List Bound With PPSK Profile")
    @Nullable
    @PII(strategy=PIIMaskStrategy.HASH)
    private List<String> ssid;
    @Schema(name="ppsk", description="PSK List In the PPSK Profile")
    @NotNull
    private List<PSKVO> ppsk;
    @Schema(name="type", description="PPSK Profile type: 0\uff1aPPSK Without RADIUS; 1: PPSK With Built-In RADIUS.")
    @Range(min=0L, max=0L, message="Invalid ppsk profile type")
    private @Range(min=0L, max=0L, message="Invalid ppsk profile type") Integer type;
    @Schema(name="rateLimit", description="PPSK Profile Rate Limit config.")
    @Nullable
    @Valid
    private PPSKRateLimitSettingVO rateLimit;
    @Schema(name="expiration", description="PPSK Profile expiration time config.")
    @Nullable
    @Valid
    private PPSKExpirationVO expiration;
    private Integer resource;

    @JsonIgnore
    public boolean validate() {
        if (this.rateLimit != null && !this.rateLimit.validate()) {
            return false;
        }
        return this.expiration == null || this.expiration.validate();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Nullable
    @Generated
    public List<String> getSsid() {
        return this.ssid;
    }

    @Generated
    public List<PSKVO> getPpsk() {
        return this.ppsk;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public PPSKRateLimitSettingVO getRateLimit() {
        return this.rateLimit;
    }

    @Nullable
    @Generated
    public PPSKExpirationVO getExpiration() {
        return this.expiration;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Generated
    public void setSsid(@Nullable List<String> ssid) {
        this.ssid = ssid;
    }

    @Generated
    public void setPpsk(List<PSKVO> ppsk) {
        this.ppsk = ppsk;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setRateLimit(@Nullable PPSKRateLimitSettingVO rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Generated
    public void setExpiration(@Nullable PPSKExpirationVO expiration) {
        this.expiration = expiration;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "PPSKProfileVO(id=" + this.getId() + ", profileName=" + this.getProfileName() + ", ssid=" + this.getSsid() + ", ppsk=" + this.getPpsk() + ", type=" + this.getType() + ", rateLimit=" + this.getRateLimit() + ", expiration=" + this.getExpiration() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public PPSKProfileVO() {
    }

    @Generated
    public PPSKProfileVO(String id, String profileName, @Nullable List<String> ssid, List<PSKVO> ppsk, Integer type, @Nullable PPSKRateLimitSettingVO rateLimit, @Nullable PPSKExpirationVO expiration, Integer resource) {
        this.id = id;
        this.profileName = profileName;
        this.ssid = ssid;
        this.ppsk = ppsk;
        this.type = type;
        this.rateLimit = rateLimit;
        this.expiration = expiration;
        this.resource = resource;
    }
}

