/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk;

import com.tplink.smb.omada.manager.device.api.web.validation.olt.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PPSKExpirationVO {
    @Schema(name="type", description="Expiration type, should be a value as follows: 0: Never expire. 1: PPSK can be used between the effective time and expiration time. 2: PPSK can be used after a period of time of creation. 3: PPSK can be used during designated time periods every day")
    private Integer type;
    @Schema(name="effectiveTime", description="The timestamp when the PPSK takes effect, unit: millisecond. When parameter [type] is 1, parameter [effectiveTime] is required")
    private Long effectiveTime;
    @Schema(name="expirationTime", description="The timestamp of the expiration of PPSK, unit: millisecond. When parameter [type] is 1, parameter [expirationTime] is required")
    private Long expirationTime;
    @Schema(name="duration", description="Duration of one use. When parameter [type] is 2, parameter [duration] is required")
    @Range(min=1L, max=10000L, message="Parameter [duration], should from 1 to 10000")
    private @Range(min=1L, max=10000L, message="Parameter [duration], should from 1 to 10000") Integer duration;
    @Schema(name="durationUnit", description="Unit of  parameter [duration], should be a value as follows: 0: hour, 1: day, 2: week. When parameter [type] is 2, parameter [duration] is required")
    @NumberSet(value={0, 1, 2}, message="Parameter [durationUnit], should be 0/1/2")
    private Integer durationUnit;
    @Schema(name="dayStartHour", description="The hour of start time, should be within the range of 0-23. When parameter [type] is 3, parameter [dayStartHour] is required")
    @Range(min=0L, max=23L, message="Parameter [dayStartHour], should be from 0 to 23")
    private @Range(min=0L, max=23L, message="Parameter [dayStartHour], should be from 0 to 23") Integer dayStartHour;
    @Schema(name="dayStartMin", description="The minute of start time, should be within the range of 0-59 When parameter [type] is 3, parameter [dayStartMin] is required")
    @Range(min=0L, max=59L, message="Parameter [dayStartMin], should be from 0 to 59")
    private @Range(min=0L, max=59L, message="Parameter [dayStartMin], should be from 0 to 59") Integer dayStartMin;
    @Schema(name="dayEndHour", description="The hour of end time, should be within the range of 0-23 When parameter [type] is 3, parameter [dayEndHour] is required")
    @Range(min=0L, max=23L, message="Parameter [dayEndHour], should be from 0 to 23")
    private @Range(min=0L, max=23L, message="Parameter [dayEndHour], should be from 0 to 23") Integer dayEndHour;
    @Schema(name="dayEndMin", description="The minute of end time, should be within the range of 0-59 When parameter [type] is 3, parameter [dayEndMin] is required")
    @Range(min=0L, max=59L, message="Parameter [dayEndMin], should be from 0 to 59")
    private @Range(min=0L, max=59L, message="Parameter [dayEndMin], should be from 0 to 59") Integer dayEndMin;

    public boolean validate() {
        if (this.type == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return true;
            }
            case 1: {
                return this.expirationTime != null && this.effectiveTime != null && this.expirationTime > this.effectiveTime;
            }
            case 2: {
                return this.duration != null && this.durationUnit != null;
            }
            case 3: {
                if (this.dayStartHour == null || this.dayStartMin == null || this.dayEndHour == null || this.dayEndMin == null) {
                    return false;
                }
                if (this.dayEndHour < this.dayStartHour) {
                    return false;
                }
                return !Objects.equals(this.dayStartHour, this.dayEndHour) || this.dayEndMin >= this.dayStartMin;
            }
        }
        return false;
    }

    public static PPSKExpirationVO buildDefault() {
        return new PPSKExpirationVO().setType(0);
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Long getEffectiveTime() {
        return this.effectiveTime;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Integer getDuration() {
        return this.duration;
    }

    @Generated
    public Integer getDurationUnit() {
        return this.durationUnit;
    }

    @Generated
    public Integer getDayStartHour() {
        return this.dayStartHour;
    }

    @Generated
    public Integer getDayStartMin() {
        return this.dayStartMin;
    }

    @Generated
    public Integer getDayEndHour() {
        return this.dayEndHour;
    }

    @Generated
    public Integer getDayEndMin() {
        return this.dayEndMin;
    }

    @Generated
    public PPSKExpirationVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public PPSKExpirationVO setEffectiveTime(Long effectiveTime) {
        this.effectiveTime = effectiveTime;
        return this;
    }

    @Generated
    public PPSKExpirationVO setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Generated
    public PPSKExpirationVO setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @Generated
    public PPSKExpirationVO setDurationUnit(Integer durationUnit) {
        this.durationUnit = durationUnit;
        return this;
    }

    @Generated
    public PPSKExpirationVO setDayStartHour(Integer dayStartHour) {
        this.dayStartHour = dayStartHour;
        return this;
    }

    @Generated
    public PPSKExpirationVO setDayStartMin(Integer dayStartMin) {
        this.dayStartMin = dayStartMin;
        return this;
    }

    @Generated
    public PPSKExpirationVO setDayEndHour(Integer dayEndHour) {
        this.dayEndHour = dayEndHour;
        return this;
    }

    @Generated
    public PPSKExpirationVO setDayEndMin(Integer dayEndMin) {
        this.dayEndMin = dayEndMin;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKExpirationVO(type=" + this.getType() + ", effectiveTime=" + this.getEffectiveTime() + ", expirationTime=" + this.getExpirationTime() + ", duration=" + this.getDuration() + ", durationUnit=" + this.getDurationUnit() + ", dayStartHour=" + this.getDayStartHour() + ", dayStartMin=" + this.getDayStartMin() + ", dayEndHour=" + this.getDayEndHour() + ", dayEndMin=" + this.getDayEndMin() + ")";
    }

    @Generated
    public PPSKExpirationVO() {
    }

    @Generated
    public PPSKExpirationVO(Integer type, Long effectiveTime, Long expirationTime, Integer duration, Integer durationUnit, Integer dayStartHour, Integer dayStartMin, Integer dayEndHour, Integer dayEndMin) {
        this.type = type;
        this.effectiveTime = effectiveTime;
        this.expirationTime = expirationTime;
        this.duration = duration;
        this.durationUnit = durationUnit;
        this.dayStartHour = dayStartHour;
        this.dayStartMin = dayStartMin;
        this.dayEndHour = dayEndHour;
        this.dayEndMin = dayEndMin;
    }
}

