/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk;

import cn.hutool.core.lang.Pair;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PPSKAutoTypeVO {
    @Range(min=1L, max=1024L, message="PSK number should be 1~1024.")
    @NotNull
    private @Range(min=1L, max=1024L, message="PSK number should be 1~1024.") @NotNull Integer number;
    @NotNull
    @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,59}$", message="PSK should be 1~60 visible ASCII characters.")
    private @NotNull @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,59}$", message="PSK should be 1~60 visible ASCII characters.") String prefix;
    @Max(value=63L)
    @Min(value=8L)
    @NotNull
    private @Max(value=63L) @Min(value=8L) @NotNull Integer length;
    @Max(value=4094L)
    @Min(value=1L)
    @Nullable
    private @Max(value=4094L) @Min(value=1L) Integer vlan;
    @Nullable
    private String vlanPool;
    @Max(value=4093L)
    @Min(value=0L)
    @Nullable
    private @Max(value=4093L) @Min(value=0L) Integer vlanInterval;
    @JsonIgnore
    public static final int DEFAULT_VLAN_INTERVAL = 0;

    @JsonIgnore
    public PPSKAutoTypeVO(Integer number, String prefix, Integer length, Integer vlan) {
        this.number = number;
        this.prefix = prefix;
        this.length = length;
        this.vlan = vlan;
    }

    @JsonIgnore
    public OperationResponse<Pair<Integer, Integer>> validateAndParseVlanPool() {
        if (this.getVlan() != null && !T.a((String)this.getVlanPool())) {
            return new OperationResponse(b.d, "One of parameter [vlan] or [vlanPool] should be null.", null);
        }
        if (!(T.a((String)this.getVlanPool()) || this.getVlanInterval() != null && this.getVlanInterval() != 0)) {
            return new OperationResponse(b.d, "Parameter [vlanInterval] should not be null.", null);
        }
        if (this.getVlanInterval() != null && this.getVlanInterval() != 0 && T.a((String)this.getVlanPool()) && this.getVlan() == null) {
            return new OperationResponse(b.d, "One of parameter [vlan] or [vlanPool] should not be null.", null);
        }
        if (!T.a((String)this.getVlanPool())) {
            if (!this.getVlanPool().matches("^\\d+-\\d+$")) {
                return new OperationResponse(b.d, "Parameter [vlanPool] should be null.", null);
            }
            String[] strings = this.getVlanPool().split("-");
            if (strings.length != 2) {
                return new OperationResponse(b.d, "Parameter [vlanPool] should be like 10-1000.", null);
            }
            try {
                Integer begin = Integer.parseInt(strings[0]);
                Integer end = Integer.parseInt(strings[1]);
                if (begin >= end || begin < 0 || end > 4094) {
                    return new OperationResponse(b.d, "Parameter [vlanPool] should be like 10-1000.", null);
                }
                return OperationResponse.success((Object)new Pair((Object)begin, (Object)end));
            }
            catch (Exception e2) {
                return new OperationResponse(b.d, "Parameter [vlanPool] should be like 10-1000.", null);
            }
        }
        return new OperationResponse(b.a);
    }

    @Generated
    public Integer getNumber() {
        return this.number;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public Integer getLength() {
        return this.length;
    }

    @Nullable
    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Nullable
    @Generated
    public String getVlanPool() {
        return this.vlanPool;
    }

    @Nullable
    @Generated
    public Integer getVlanInterval() {
        return this.vlanInterval;
    }

    @Generated
    public void setNumber(Integer number) {
        this.number = number;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setLength(Integer length) {
        this.length = length;
    }

    @Generated
    public void setVlan(@Nullable Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setVlanPool(@Nullable String vlanPool) {
        this.vlanPool = vlanPool;
    }

    @Generated
    public void setVlanInterval(@Nullable Integer vlanInterval) {
        this.vlanInterval = vlanInterval;
    }

    @Generated
    public String toString() {
        return "PPSKAutoTypeVO(number=" + this.getNumber() + ", prefix=" + this.getPrefix() + ", length=" + this.getLength() + ", vlan=" + this.getVlan() + ", vlanPool=" + this.getVlanPool() + ", vlanInterval=" + this.getVlanInterval() + ")";
    }

    @Generated
    public PPSKAutoTypeVO() {
    }

    @Generated
    public PPSKAutoTypeVO(Integer number, String prefix, Integer length, @Nullable Integer vlan, @Nullable String vlanPool, @Nullable Integer vlanInterval) {
        this.number = number;
        this.prefix = prefix;
        this.length = length;
        this.vlan = vlan;
        this.vlanPool = vlanPool;
        this.vlanInterval = vlanInterval;
    }
}

