/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class RateLimitProfileVO {
    @Schema(name="id", description="Rate limit profile id.")
    private String id;
    @Schema(name="name", description="Rate limit profile name.")
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Schema(name="site", description="Site ID")
    private String site;
    @Schema(name="downLimitEnable", description="Down limit enable.")
    @NotNull(message="downLimitEnable should not be null")
    private @NotNull(message="downLimitEnable should not be null") Boolean downLimitEnable;
    @Schema(name="downLimit", description="Down limit. Unit is Kbps, integer from 1 to 10485760.")
    @Range(min=1L, max=0xA00000L, message="downLimit should be from 1 to 10485760.")
    private @Range(min=1L, max=0xA00000L, message="downLimit should be from 1 to 10485760.") Long downLimit;
    @Schema(name="upLimitEnable", description="Up limit enable.")
    @NotNull(message="upLimitEnable should not be null")
    private @NotNull(message="upLimitEnable should not be null") Boolean upLimitEnable;
    @Schema(name="upLimit", description="Up limit. Unit is Kbps, integer from 1 to 10485760.")
    @Range(min=1L, max=0xA00000L, message="upLimit should be from 1 to 10485760.")
    private @Range(min=1L, max=0xA00000L, message="upLimit should be from 1 to 10485760.") Long upLimit;
    @Schema(name="isDefault", description="Whether it is default profile.")
    private Boolean isDefault;
    private Integer resource;

    public static OperationResponse validate(RateLimitProfileVO vo) {
        if (T.a((String)vo.getName())) {
            return new OperationResponse(b.d);
        }
        if (Boolean.TRUE.equals(vo.getDownLimitEnable()) && Objects.isNull(vo.getDownLimit())) {
            return new OperationResponse(b.d, "Parameter [downLimit] is required when parameter [downLimitEnable] is true", null);
        }
        if (Boolean.TRUE.equals(vo.getUpLimitEnable()) && Objects.isNull(vo.getUpLimit())) {
            return new OperationResponse(b.d, "Parameter [upLimit] is required when parameter [upLimitEnable] is true", null);
        }
        return OperationResponse.SUCCESS;
    }

    public RateLimitProfileVO cloneVO() {
        return RateLimitProfileVO.builder().downLimit(this.downLimit).downLimitEnable(this.downLimitEnable).upLimit(this.upLimit).upLimitEnable(this.upLimitEnable).id(this.id).name(this.name).build();
    }

    @Generated
    public static RateLimitProfileVOBuilder builder() {
        return new RateLimitProfileVOBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public Boolean getDownLimitEnable() {
        return this.downLimitEnable;
    }

    @Generated
    public Long getDownLimit() {
        return this.downLimit;
    }

    @Generated
    public Boolean getUpLimitEnable() {
        return this.upLimitEnable;
    }

    @Generated
    public Long getUpLimit() {
        return this.upLimit;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setDownLimitEnable(Boolean downLimitEnable) {
        this.downLimitEnable = downLimitEnable;
    }

    @Generated
    public void setDownLimit(Long downLimit) {
        this.downLimit = downLimit;
    }

    @Generated
    public void setUpLimitEnable(Boolean upLimitEnable) {
        this.upLimitEnable = upLimitEnable;
    }

    @Generated
    public void setUpLimit(Long upLimit) {
        this.upLimit = upLimit;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "RateLimitProfileVO(id=" + this.getId() + ", name=" + this.getName() + ", site=" + this.getSite() + ", downLimitEnable=" + this.getDownLimitEnable() + ", downLimit=" + this.getDownLimit() + ", upLimitEnable=" + this.getUpLimitEnable() + ", upLimit=" + this.getUpLimit() + ", isDefault=" + this.getIsDefault() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public RateLimitProfileVO() {
    }

    @Generated
    public RateLimitProfileVO(String id, String name, String site, Boolean downLimitEnable, Long downLimit, Boolean upLimitEnable, Long upLimit, Boolean isDefault, Integer resource) {
        this.id = id;
        this.name = name;
        this.site = site;
        this.downLimitEnable = downLimitEnable;
        this.downLimit = downLimit;
        this.upLimitEnable = upLimitEnable;
        this.upLimit = upLimit;
        this.isDefault = isDefault;
        this.resource = resource;
    }

    @Generated
    public static class RateLimitProfileVOBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String site;
        @Generated
        private Boolean downLimitEnable;
        @Generated
        private Long downLimit;
        @Generated
        private Boolean upLimitEnable;
        @Generated
        private Long upLimit;
        @Generated
        private Boolean isDefault;
        @Generated
        private Integer resource;

        @Generated
        RateLimitProfileVOBuilder() {
        }

        @Generated
        public RateLimitProfileVOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder site(String site) {
            this.site = site;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder downLimitEnable(Boolean downLimitEnable) {
            this.downLimitEnable = downLimitEnable;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder downLimit(Long downLimit) {
            this.downLimit = downLimit;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder upLimitEnable(Boolean upLimitEnable) {
            this.upLimitEnable = upLimitEnable;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder upLimit(Long upLimit) {
            this.upLimit = upLimit;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Generated
        public RateLimitProfileVOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public RateLimitProfileVO build() {
            return new RateLimitProfileVO(this.id, this.name, this.site, this.downLimitEnable, this.downLimit, this.upLimitEnable, this.upLimit, this.isDefault, this.resource);
        }

        @Generated
        public String toString() {
            return "RateLimitProfileVO.RateLimitProfileVOBuilder(id=" + this.id + ", name=" + this.name + ", site=" + this.site + ", downLimitEnable=" + this.downLimitEnable + ", downLimit=" + this.downLimit + ", upLimitEnable=" + this.upLimitEnable + ", upLimit=" + this.upLimit + ", isDefault=" + this.isDefault + ", resource=" + this.resource + ")";
        }
    }
}

