/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto;

import com.tplink.smb.omada.common.util.f.b;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

public class MdnsProfileVO {
    private String id;
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Valid
    @Size(min=1, max=3, message="serviceId should be between 1 and 3")
    private @Valid @Size(min=1, max=3, message="serviceId should be between 1 and 3") List<String> serviceId;
    private Boolean defaultProfile;
    private Integer resource;

    public static boolean validateServiceId(List<String> serviceId) {
        for (String id : serviceId) {
            boolean result = b.a((String)id, (int)1, (int)32, (String)"UTF-8");
            if (result) continue;
            return false;
        }
        return true;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getServiceId() {
        return this.serviceId;
    }

    @Generated
    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setServiceId(List<String> serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public MdnsProfileVO() {
    }

    @Generated
    public MdnsProfileVO(String id, String name, List<String> serviceId, Boolean defaultProfile, Integer resource) {
        this.id = id;
        this.name = name;
        this.serviceId = serviceId;
        this.defaultProfile = defaultProfile;
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "MdnsProfileVO(id=" + this.getId() + ", name=" + this.getName() + ", serviceId=" + this.getServiceId() + ", defaultProfile=" + this.getDefaultProfile() + ", resource=" + this.getResource() + ")";
    }
}

