/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.mail.dto;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class GlobalMailServerVO {
    private String centralId;
    @NotNull(message="smtpEnable should not be null")
    private @NotNull(message="smtpEnable should not be null") Boolean smtpEnable;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String smtpServer;
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) Integer port;
    private Boolean sslEnable;
    private Boolean authEnable;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String username;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String password;
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}")
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}") String senderAddress;

    public boolean checkParam() {
        if (Boolean.TRUE.equals(this.getSmtpEnable())) {
            if (this.getPort() == null || this.getSslEnable() == null || this.getAuthEnable() == null) {
                return false;
            }
            if (this.getSmtpServer() == null) {
                return false;
            }
            return this.getAuthEnable() == false || this.getUsername() != null && this.getPassword() != null;
        }
        return true;
    }

    @Generated
    public String getCentralId() {
        return this.centralId;
    }

    @Generated
    public Boolean getSmtpEnable() {
        return this.smtpEnable;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    @Generated
    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSenderAddress() {
        return this.senderAddress;
    }

    @Generated
    public GlobalMailServerVO setCentralId(String centralId) {
        this.centralId = centralId;
        return this;
    }

    @Generated
    public GlobalMailServerVO setSmtpEnable(Boolean smtpEnable) {
        this.smtpEnable = smtpEnable;
        return this;
    }

    @Generated
    public GlobalMailServerVO setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
        return this;
    }

    @Generated
    public GlobalMailServerVO setPort(Integer port) {
        this.port = port;
        return this;
    }

    @Generated
    public GlobalMailServerVO setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
        return this;
    }

    @Generated
    public GlobalMailServerVO setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
        return this;
    }

    @Generated
    public GlobalMailServerVO setUsername(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public GlobalMailServerVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public GlobalMailServerVO setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    @Generated
    public String toString() {
        return "GlobalMailServerVO(centralId=" + this.getCentralId() + ", smtpEnable=" + this.getSmtpEnable() + ", smtpServer=" + this.getSmtpServer() + ", port=" + this.getPort() + ", sslEnable=" + this.getSslEnable() + ", authEnable=" + this.getAuthEnable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", senderAddress=" + this.getSenderAddress() + ")";
    }

    @Generated
    public GlobalMailServerVO() {
    }

    @Generated
    public GlobalMailServerVO(String centralId, Boolean smtpEnable, String smtpServer, Integer port, Boolean sslEnable, Boolean authEnable, String username, String password, String senderAddress) {
        this.centralId = centralId;
        this.smtpEnable = smtpEnable;
        this.smtpServer = smtpServer;
        this.port = port;
        this.sslEnable = sslEnable;
        this.authEnable = authEnable;
        this.username = username;
        this.password = password;
        this.senderAddress = senderAddress;
    }
}

