/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto;

import com.tplink.smb.omada.common.access.OperationResponse;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class IpMacBindingGlobalSettingVO {
    @NotNull
    private Boolean enable;
    private List<String> lanIds;
    private List<String> wanIds;
    private Boolean imbPass;
    private Boolean garp;
    @Range(min=1L, max=10000L, message="Interval is from 1 to 10000.")
    private @Range(min=1L, max=10000L, message="Interval is from 1 to 10000.") Integer interval;
    private Integer resource;
    private Boolean supportIpMacBinding;
    private Boolean supportNewIpMacBinding;

    public OperationResponse validateWhenSupportNewIpMacBinding() {
        if (!Boolean.TRUE.equals(this.garp)) {
            return OperationResponse.SUCCESS;
        }
        if (CollectionUtils.isEmpty(this.lanIds) && CollectionUtils.isEmpty(this.wanIds)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse validateWhenSupportIpMacBinding() {
        if (Boolean.TRUE.equals(this.enable) && CollectionUtils.isEmpty(this.lanIds) && CollectionUtils.isEmpty(this.wanIds)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(this.garp) && Objects.isNull(this.interval)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.ok();
    }

    @Generated
    public static IpMacBindingGlobalSettingVOBuilder builder() {
        return new IpMacBindingGlobalSettingVOBuilder();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getLanIds() {
        return this.lanIds;
    }

    @Generated
    public List<String> getWanIds() {
        return this.wanIds;
    }

    @Generated
    public Boolean getImbPass() {
        return this.imbPass;
    }

    @Generated
    public Boolean getGarp() {
        return this.garp;
    }

    @Generated
    public Integer getInterval() {
        return this.interval;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public Boolean getSupportIpMacBinding() {
        return this.supportIpMacBinding;
    }

    @Generated
    public Boolean getSupportNewIpMacBinding() {
        return this.supportNewIpMacBinding;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setLanIds(List<String> lanIds) {
        this.lanIds = lanIds;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setWanIds(List<String> wanIds) {
        this.wanIds = wanIds;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setImbPass(Boolean imbPass) {
        this.imbPass = imbPass;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setGarp(Boolean garp) {
        this.garp = garp;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setResource(Integer resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setSupportIpMacBinding(Boolean supportIpMacBinding) {
        this.supportIpMacBinding = supportIpMacBinding;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO setSupportNewIpMacBinding(Boolean supportNewIpMacBinding) {
        this.supportNewIpMacBinding = supportNewIpMacBinding;
        return this;
    }

    @Generated
    public IpMacBindingGlobalSettingVO() {
    }

    @Generated
    public IpMacBindingGlobalSettingVO(Boolean enable, List<String> lanIds, List<String> wanIds, Boolean imbPass, Boolean garp, Integer interval, Integer resource, Boolean supportIpMacBinding, Boolean supportNewIpMacBinding) {
        this.enable = enable;
        this.lanIds = lanIds;
        this.wanIds = wanIds;
        this.imbPass = imbPass;
        this.garp = garp;
        this.interval = interval;
        this.resource = resource;
        this.supportIpMacBinding = supportIpMacBinding;
        this.supportNewIpMacBinding = supportNewIpMacBinding;
    }

    @Generated
    public String toString() {
        return "IpMacBindingGlobalSettingVO(enable=" + this.getEnable() + ", lanIds=" + this.getLanIds() + ", wanIds=" + this.getWanIds() + ", imbPass=" + this.getImbPass() + ", garp=" + this.getGarp() + ", interval=" + this.getInterval() + ", resource=" + this.getResource() + ", supportIpMacBinding=" + this.getSupportIpMacBinding() + ", supportNewIpMacBinding=" + this.getSupportNewIpMacBinding() + ")";
    }

    @Generated
    public static class IpMacBindingGlobalSettingVOBuilder {
        @Generated
        private Boolean enable;
        @Generated
        private List<String> lanIds;
        @Generated
        private List<String> wanIds;
        @Generated
        private Boolean imbPass;
        @Generated
        private Boolean garp;
        @Generated
        private Integer interval;
        @Generated
        private Integer resource;
        @Generated
        private Boolean supportIpMacBinding;
        @Generated
        private Boolean supportNewIpMacBinding;

        @Generated
        IpMacBindingGlobalSettingVOBuilder() {
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder lanIds(List<String> lanIds) {
            this.lanIds = lanIds;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder wanIds(List<String> wanIds) {
            this.wanIds = wanIds;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder imbPass(Boolean imbPass) {
            this.imbPass = imbPass;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder garp(Boolean garp) {
            this.garp = garp;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder supportIpMacBinding(Boolean supportIpMacBinding) {
            this.supportIpMacBinding = supportIpMacBinding;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVOBuilder supportNewIpMacBinding(Boolean supportNewIpMacBinding) {
            this.supportNewIpMacBinding = supportNewIpMacBinding;
            return this;
        }

        @Generated
        public IpMacBindingGlobalSettingVO build() {
            return new IpMacBindingGlobalSettingVO(this.enable, this.lanIds, this.wanIds, this.imbPass, this.garp, this.interval, this.resource, this.supportIpMacBinding, this.supportNewIpMacBinding);
        }

        @Generated
        public String toString() {
            return "IpMacBindingGlobalSettingVO.IpMacBindingGlobalSettingVOBuilder(enable=" + this.enable + ", lanIds=" + this.lanIds + ", wanIds=" + this.wanIds + ", imbPass=" + this.imbPass + ", garp=" + this.garp + ", interval=" + this.interval + ", resource=" + this.resource + ", supportIpMacBinding=" + this.supportIpMacBinding + ", supportNewIpMacBinding=" + this.supportNewIpMacBinding + ")";
        }
    }
}

