/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.DeviceCliVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.StackCliVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

public class ModifyCliVO {
    @NotNull(message="name must not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 ~ 64 characters.")
    @Schema(name="name", description="CLI configuration name, it should be within the range of 1 - 64 characters")
    private @NotNull(message="name must not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 ~ 64 characters.") String name;
    @Schema(name="deviceType", description="Device type for CLI configuration application, it should be a value as follows: switch.")
    private String deviceType;
    @Length(max=256, message="Parameter [description] should be 0 ~ 256 characters.")
    @Schema(name="description", description="CLI configuration description, it should be within the range of 0 - 256 characters.")
    private @Length(max=256, message="Parameter [description] should be 0 ~ 256 characters.") String description;
    @NotNull(message="cliConfig must not be null")
    @Schema(name="cliConfig", description="CLI configuration content")
    private @NotNull(message="cliConfig must not be null") String cliConfig;
    @Schema(name="devices", description="List of devices bound to the CLI configuration.")
    private List<DeviceCliVO> devices;
    @Schema(name="stacks", description="List of stacks bound to the CLI configuration, only device CLI has this field.")
    private List<StackCliVO> stacks;
    private String model;
    private String modelVersion;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getCliConfig() {
        return this.cliConfig;
    }

    @Generated
    public List<DeviceCliVO> getDevices() {
        return this.devices;
    }

    @Generated
    public List<StackCliVO> getStacks() {
        return this.stacks;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCliConfig(String cliConfig) {
        this.cliConfig = cliConfig;
    }

    @Generated
    public void setDevices(List<DeviceCliVO> devices) {
        this.devices = devices;
    }

    @Generated
    public void setStacks(List<StackCliVO> stacks) {
        this.stacks = stacks;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public String toString() {
        return "ModifyCliVO(name=" + this.getName() + ", deviceType=" + this.getDeviceType() + ", description=" + this.getDescription() + ", cliConfig=" + this.getCliConfig() + ", devices=" + this.getDevices() + ", stacks=" + this.getStacks() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ")";
    }

    @Generated
    public ModifyCliVO() {
    }

    @Generated
    public ModifyCliVO(String name, String deviceType, String description, String cliConfig, List<DeviceCliVO> devices, List<StackCliVO> stacks, String model, String modelVersion) {
        this.name = name;
        this.deviceType = deviceType;
        this.description = description;
        this.cliConfig = cliConfig;
        this.devices = devices;
        this.stacks = stacks;
        this.model = model;
        this.modelVersion = modelVersion;
    }
}

