/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile;

import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusAcctServerVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusAuthServerVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusCoaServerVO;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class RadiusProfileVO
extends b {
    private String radiusProfileId;
    @NotNull(message="Radius profile name should not be null")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Radius profile name should be 1~64.")
    private @NotNull(message="Radius profile name should not be null") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Radius profile name should be 1~64.") String name;
    @Valid
    private List<RadiusAuthServerVO> authServer;
    @Deprecated
    private String radiusServerIp;
    @Deprecated
    private Integer radiusPort;
    @Deprecated
    private String radiusPwd;
    @NotNull(message="RadiusAccountingEnable should not be null")
    private @NotNull(message="RadiusAccountingEnable should not be null") Boolean radiusAccountingEnable;
    private Boolean interimUpdateEnable;
    private Integer interimUpdateInterval;
    @Valid
    private List<RadiusAcctServerVO> acctServer;
    @NotNull(message="wireVlanAssignment should not be null")
    private @NotNull(message="wireVlanAssignment should not be null") Boolean wirelessVlanAssignment;
    private Boolean domainEnable;
    @Deprecated
    private String accountingServerIp;
    @Deprecated
    private Integer accountingServerPort;
    @Deprecated
    private String accountingServerPwd;
    private Boolean coaEnable;
    private List<RadiusCoaServerVO> coaServer;
    private Boolean proxy;
    @Range(min=1L, max=30L, message="Accounting timeout should be from 1 to 30 s")
    private @Range(min=1L, max=30L, message="Accounting timeout should be from 1 to 30 s") Integer acctTimeout;
    @Nullable
    private Boolean builtInServer;
    @Nullable
    private Boolean serverEnable;
    @Nullable
    private Boolean tunnelReplyEnable;
    @Nullable
    private String builtInServerSecret;
    @Nullable
    private Integer ipType;
    @Nullable
    private String customIp;
    private Integer resource;

    public List<RadiusAuthServerVO> getAuthServer() {
        ArrayList<RadiusAuthServerVO> result = new ArrayList<RadiusAuthServerVO>();
        if (this.authServer != null) {
            result.addAll(this.authServer);
            return result;
        }
        if (this.getRadiusServerIp() != null) {
            RadiusAuthServerVO RadiusAuthServerVO2 = new RadiusAuthServerVO();
            RadiusAuthServerVO2.setRadiusServerIp(this.getRadiusServerIp());
            RadiusAuthServerVO2.setRadiusPort(this.getRadiusPort());
            RadiusAuthServerVO2.setRadiusPwd(this.getRadiusPwd());
            result.add(RadiusAuthServerVO2);
            return result;
        }
        return result;
    }

    public List<RadiusAcctServerVO> getAcctServer() {
        ArrayList<RadiusAcctServerVO> result = new ArrayList<RadiusAcctServerVO>();
        if (this.acctServer != null) {
            result.addAll(this.acctServer);
            return result;
        }
        if (this.getAccountingServerIp() != null) {
            RadiusAcctServerVO RadiusAcctServerVO2 = new RadiusAcctServerVO();
            RadiusAcctServerVO2.setAccountingServerIp(this.getAccountingServerIp());
            RadiusAcctServerVO2.setAccountingServerPort(this.getAccountingServerPort());
            RadiusAcctServerVO2.setAccountingServerPwd(this.getAccountingServerPwd());
            result.add(RadiusAcctServerVO2);
            return result;
        }
        return null;
    }

    public Object clone() {
        List<RadiusCoaServerVO> radiusCoaServerVOS;
        List<RadiusAcctServerVO> radiusAcctServerVOS;
        RadiusProfileVO obj = (RadiusProfileVO)((Object)super.clone());
        List<RadiusAuthServerVO> radiusAuthServerVOS = obj.getAuthServer();
        if (!CollectionUtils.isEmpty(radiusAuthServerVOS)) {
            ArrayList<RadiusAuthServerVO> cloneList = new ArrayList<RadiusAuthServerVO>();
            radiusAuthServerVOS.forEach(radiusAuthServerVO -> cloneList.add((RadiusAuthServerVO)((Object)((Object)radiusAuthServerVO.clone()))));
            obj.setAuthServer(cloneList);
        }
        if (!CollectionUtils.isEmpty(radiusAcctServerVOS = obj.getAcctServer())) {
            ArrayList<RadiusAcctServerVO> cloneList = new ArrayList<RadiusAcctServerVO>();
            radiusAcctServerVOS.forEach(radiusAcctServerVO -> cloneList.add((RadiusAcctServerVO)((Object)((Object)radiusAcctServerVO.clone()))));
            obj.setAcctServer(cloneList);
        }
        if (!CollectionUtils.isEmpty(radiusCoaServerVOS = obj.getCoaServer())) {
            ArrayList<RadiusCoaServerVO> cloneList = new ArrayList<RadiusCoaServerVO>();
            radiusCoaServerVOS.forEach(radiusCoaServerVO -> cloneList.add((RadiusCoaServerVO)((Object)((Object)radiusCoaServerVO.clone()))));
            obj.setCoaServer(cloneList);
        }
        return obj;
    }

    public boolean radsecEnable() {
        for (RadiusAuthServerVO radiusAuthServer : this.getAuthServer()) {
            if (!Boolean.TRUE.equals(radiusAuthServer.getRadSecEnable())) continue;
            return true;
        }
        if (Boolean.TRUE.equals(this.radiusAccountingEnable)) {
            for (RadiusAcctServerVO radiusAcctServer : this.getAcctServer()) {
                if (!Boolean.TRUE.equals(radiusAcctServer.getRadSecEnable())) continue;
                return true;
            }
        }
        return false;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Deprecated
    @Generated
    public String getRadiusServerIp() {
        return this.radiusServerIp;
    }

    @Deprecated
    @Generated
    public Integer getRadiusPort() {
        return this.radiusPort;
    }

    @Deprecated
    @Generated
    public String getRadiusPwd() {
        return this.radiusPwd;
    }

    @Generated
    public Boolean getRadiusAccountingEnable() {
        return this.radiusAccountingEnable;
    }

    @Generated
    public Boolean getInterimUpdateEnable() {
        return this.interimUpdateEnable;
    }

    @Generated
    public Integer getInterimUpdateInterval() {
        return this.interimUpdateInterval;
    }

    @Generated
    public Boolean getWirelessVlanAssignment() {
        return this.wirelessVlanAssignment;
    }

    @Generated
    public Boolean getDomainEnable() {
        return this.domainEnable;
    }

    @Deprecated
    @Generated
    public String getAccountingServerIp() {
        return this.accountingServerIp;
    }

    @Deprecated
    @Generated
    public Integer getAccountingServerPort() {
        return this.accountingServerPort;
    }

    @Deprecated
    @Generated
    public String getAccountingServerPwd() {
        return this.accountingServerPwd;
    }

    @Generated
    public Boolean getCoaEnable() {
        return this.coaEnable;
    }

    @Generated
    public List<RadiusCoaServerVO> getCoaServer() {
        return this.coaServer;
    }

    @Generated
    public Boolean getProxy() {
        return this.proxy;
    }

    @Generated
    public Integer getAcctTimeout() {
        return this.acctTimeout;
    }

    @Nullable
    @Generated
    public Boolean getBuiltInServer() {
        return this.builtInServer;
    }

    @Nullable
    @Generated
    public Boolean getServerEnable() {
        return this.serverEnable;
    }

    @Nullable
    @Generated
    public Boolean getTunnelReplyEnable() {
        return this.tunnelReplyEnable;
    }

    @Nullable
    @Generated
    public String getBuiltInServerSecret() {
        return this.builtInServerSecret;
    }

    @Nullable
    @Generated
    public Integer getIpType() {
        return this.ipType;
    }

    @Nullable
    @Generated
    public String getCustomIp() {
        return this.customIp;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAuthServer(List<RadiusAuthServerVO> authServer) {
        this.authServer = authServer;
    }

    @Deprecated
    @Generated
    public void setRadiusServerIp(String radiusServerIp) {
        this.radiusServerIp = radiusServerIp;
    }

    @Deprecated
    @Generated
    public void setRadiusPort(Integer radiusPort) {
        this.radiusPort = radiusPort;
    }

    @Deprecated
    @Generated
    public void setRadiusPwd(String radiusPwd) {
        this.radiusPwd = radiusPwd;
    }

    @Generated
    public void setRadiusAccountingEnable(Boolean radiusAccountingEnable) {
        this.radiusAccountingEnable = radiusAccountingEnable;
    }

    @Generated
    public void setInterimUpdateEnable(Boolean interimUpdateEnable) {
        this.interimUpdateEnable = interimUpdateEnable;
    }

    @Generated
    public void setInterimUpdateInterval(Integer interimUpdateInterval) {
        this.interimUpdateInterval = interimUpdateInterval;
    }

    @Generated
    public void setAcctServer(List<RadiusAcctServerVO> acctServer) {
        this.acctServer = acctServer;
    }

    @Generated
    public void setWirelessVlanAssignment(Boolean wirelessVlanAssignment) {
        this.wirelessVlanAssignment = wirelessVlanAssignment;
    }

    @Generated
    public void setDomainEnable(Boolean domainEnable) {
        this.domainEnable = domainEnable;
    }

    @Deprecated
    @Generated
    public void setAccountingServerIp(String accountingServerIp) {
        this.accountingServerIp = accountingServerIp;
    }

    @Deprecated
    @Generated
    public void setAccountingServerPort(Integer accountingServerPort) {
        this.accountingServerPort = accountingServerPort;
    }

    @Deprecated
    @Generated
    public void setAccountingServerPwd(String accountingServerPwd) {
        this.accountingServerPwd = accountingServerPwd;
    }

    @Generated
    public void setCoaEnable(Boolean coaEnable) {
        this.coaEnable = coaEnable;
    }

    @Generated
    public void setCoaServer(List<RadiusCoaServerVO> coaServer) {
        this.coaServer = coaServer;
    }

    @Generated
    public void setProxy(Boolean proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setAcctTimeout(Integer acctTimeout) {
        this.acctTimeout = acctTimeout;
    }

    @Generated
    public void setBuiltInServer(@Nullable Boolean builtInServer) {
        this.builtInServer = builtInServer;
    }

    @Generated
    public void setServerEnable(@Nullable Boolean serverEnable) {
        this.serverEnable = serverEnable;
    }

    @Generated
    public void setTunnelReplyEnable(@Nullable Boolean tunnelReplyEnable) {
        this.tunnelReplyEnable = tunnelReplyEnable;
    }

    @Generated
    public void setBuiltInServerSecret(@Nullable String builtInServerSecret) {
        this.builtInServerSecret = builtInServerSecret;
    }

    @Generated
    public void setIpType(@Nullable Integer ipType) {
        this.ipType = ipType;
    }

    @Generated
    public void setCustomIp(@Nullable String customIp) {
        this.customIp = customIp;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "RadiusProfileVO(radiusProfileId=" + this.getRadiusProfileId() + ", name=" + this.getName() + ", authServer=" + this.getAuthServer() + ", radiusServerIp=" + this.getRadiusServerIp() + ", radiusPort=" + this.getRadiusPort() + ", radiusPwd=" + this.getRadiusPwd() + ", radiusAccountingEnable=" + this.getRadiusAccountingEnable() + ", interimUpdateEnable=" + this.getInterimUpdateEnable() + ", interimUpdateInterval=" + this.getInterimUpdateInterval() + ", acctServer=" + this.getAcctServer() + ", wirelessVlanAssignment=" + this.getWirelessVlanAssignment() + ", domainEnable=" + this.getDomainEnable() + ", accountingServerIp=" + this.getAccountingServerIp() + ", accountingServerPort=" + this.getAccountingServerPort() + ", accountingServerPwd=" + this.getAccountingServerPwd() + ", coaEnable=" + this.getCoaEnable() + ", coaServer=" + this.getCoaServer() + ", proxy=" + this.getProxy() + ", acctTimeout=" + this.getAcctTimeout() + ", builtInServer=" + this.getBuiltInServer() + ", serverEnable=" + this.getServerEnable() + ", tunnelReplyEnable=" + this.getTunnelReplyEnable() + ", builtInServerSecret=" + this.getBuiltInServerSecret() + ", ipType=" + this.getIpType() + ", customIp=" + this.getCustomIp() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public RadiusProfileVO() {
    }
}

