/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.c.n;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class GoogleLdapProfileVO {
    private String id;
    @Length(max=64)
    @NotNull(message="Parameter [name] could not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Google LDAP profile name should be 1-64 any character.")
    private @Length(max=64) @NotNull(message="Parameter [name] could not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Google LDAP profile name should be 1-64 any character.") String name;
    @NotNull(message="Parameter [status] could not be null.")
    private @NotNull(message="Parameter [status] could not be null.") Boolean status;
    @NotNull(message="Parameter [bindType] could not be null.")
    @NumberSet(value={0, 2}, message="Parameter [bindType] should be 0 or 2.")
    private @NotNull(message="Parameter [bindType] could not be null.") Integer bindType;
    @NotNull(message="Parameter [server] could not be null.")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})")
    private @NotNull(message="Parameter [server] could not be null.") @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})") String server;
    @NotNull(message="Parameter [port] could not be null.")
    @Range(min=0L, max=65535L, message="Port should be a number ranges from 0 to 65535.")
    private @NotNull(message="Parameter [port] could not be null.") @Range(min=0L, max=65535L, message="Port should be a number ranges from 0 to 65535.") Integer port;
    @Length(max=256)
    private @Length(max=256) String account;
    @Length(max=256)
    private @Length(max=256) String password;
    @Length(max=64)
    @NotNull(message="Parameter [cn] could not be null.")
    private @Length(max=64) @NotNull(message="Parameter [cn] could not be null.") String cn;
    @Length(max=512)
    @NotNull(message="Parameter [baseDn] could not be null.")
    private @Length(max=512) @NotNull(message="Parameter [baseDn] could not be null.") String baseDn;
    @Length(max=512)
    private @Length(max=512) String filter;
    private String fileName;

    public boolean validate() {
        if (this.bindType.equals(n.a.a())) {
            return T.a((String)this.account) && T.a((String)this.password) && T.a((String)this.filter);
        }
        return T.b((String)this.account) && T.b((String)this.password) && this.password.length() >= 6;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getBindType() {
        return this.bindType;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getCn() {
        return this.cn;
    }

    @Generated
    public String getBaseDn() {
        return this.baseDn;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public GoogleLdapProfileVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setBindType(Integer bindType) {
        this.bindType = bindType;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setServer(String server) {
        this.server = server;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setPort(Integer port) {
        this.port = port;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setAccount(String account) {
        this.account = account;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setCn(String cn) {
        this.cn = cn;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setBaseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @Generated
    public GoogleLdapProfileVO setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public String toString() {
        return "GoogleLdapProfileVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", bindType=" + this.getBindType() + ", server=" + this.getServer() + ", port=" + this.getPort() + ", account=" + this.getAccount() + ", password=" + this.getPassword() + ", cn=" + this.getCn() + ", baseDn=" + this.getBaseDn() + ", filter=" + this.getFilter() + ", fileName=" + this.getFileName() + ")";
    }
}

