/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.omadac.global;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WebPortVO {
    @NumberSet(value={80}, ranges={@Range(min=1024L, max=65535L)}, message="Controller HTTP Port should be 80 or between 1024 and 65535")
    private Integer manageHttpPort;
    @NumberSet(value={443}, ranges={@Range(min=1024L, max=65535L)}, message="Controller HTTPS Port should be 443 or between 1024 and 65535")
    private Integer manageHttpsPort;
    @NumberSet(value={80}, ranges={@Range(min=1024L, max=65535L)}, message="Portal HTTP Port should be 80 or between 1024 and 65535")
    private Integer portalHttpPort;
    @NumberSet(ranges={@Range(min=1024L, max=65535L)}, message="Portal HTTPS Port should be between 1024 and 65535")
    private Integer portalHttpsPort;
    @NumberSet(ranges={@Range(min=1024L, max=65535L)}, message="Upgrade HTTPS Port should be between 1024 and 65535")
    private Integer upgradeHttpsPort;
    private String hostName;
    private Boolean autoRefresh;
    private Boolean autoPortalIpEnable;
    private Boolean portalHttpsRedirect;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Illegal Portal Host config, it should be a domain name or IP address")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Illegal Portal Host config, it should be a domain name or IP address") String portalHost;

    @Generated
    public static WebPortVOBuilder builder() {
        return new WebPortVOBuilder();
    }

    @Generated
    public Integer getManageHttpPort() {
        return this.manageHttpPort;
    }

    @Generated
    public Integer getManageHttpsPort() {
        return this.manageHttpsPort;
    }

    @Generated
    public Integer getPortalHttpPort() {
        return this.portalHttpPort;
    }

    @Generated
    public Integer getPortalHttpsPort() {
        return this.portalHttpsPort;
    }

    @Generated
    public Integer getUpgradeHttpsPort() {
        return this.upgradeHttpsPort;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public Boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    @Generated
    public Boolean getAutoPortalIpEnable() {
        return this.autoPortalIpEnable;
    }

    @Generated
    public Boolean getPortalHttpsRedirect() {
        return this.portalHttpsRedirect;
    }

    @Generated
    public String getPortalHost() {
        return this.portalHost;
    }

    @Generated
    public void setManageHttpPort(Integer manageHttpPort) {
        this.manageHttpPort = manageHttpPort;
    }

    @Generated
    public void setManageHttpsPort(Integer manageHttpsPort) {
        this.manageHttpsPort = manageHttpsPort;
    }

    @Generated
    public void setPortalHttpPort(Integer portalHttpPort) {
        this.portalHttpPort = portalHttpPort;
    }

    @Generated
    public void setPortalHttpsPort(Integer portalHttpsPort) {
        this.portalHttpsPort = portalHttpsPort;
    }

    @Generated
    public void setUpgradeHttpsPort(Integer upgradeHttpsPort) {
        this.upgradeHttpsPort = upgradeHttpsPort;
    }

    @Generated
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Generated
    public void setAutoRefresh(Boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    @Generated
    public void setAutoPortalIpEnable(Boolean autoPortalIpEnable) {
        this.autoPortalIpEnable = autoPortalIpEnable;
    }

    @Generated
    public void setPortalHttpsRedirect(Boolean portalHttpsRedirect) {
        this.portalHttpsRedirect = portalHttpsRedirect;
    }

    @Generated
    public void setPortalHost(String portalHost) {
        this.portalHost = portalHost;
    }

    @Generated
    public String toString() {
        return "WebPortVO(manageHttpPort=" + this.getManageHttpPort() + ", manageHttpsPort=" + this.getManageHttpsPort() + ", portalHttpPort=" + this.getPortalHttpPort() + ", portalHttpsPort=" + this.getPortalHttpsPort() + ", upgradeHttpsPort=" + this.getUpgradeHttpsPort() + ", hostName=" + this.getHostName() + ", autoRefresh=" + this.getAutoRefresh() + ", autoPortalIpEnable=" + this.getAutoPortalIpEnable() + ", portalHttpsRedirect=" + this.getPortalHttpsRedirect() + ", portalHost=" + this.getPortalHost() + ")";
    }

    @Generated
    public WebPortVO() {
    }

    @Generated
    public WebPortVO(Integer manageHttpPort, Integer manageHttpsPort, Integer portalHttpPort, Integer portalHttpsPort, Integer upgradeHttpsPort, String hostName, Boolean autoRefresh, Boolean autoPortalIpEnable, Boolean portalHttpsRedirect, String portalHost) {
        this.manageHttpPort = manageHttpPort;
        this.manageHttpsPort = manageHttpsPort;
        this.portalHttpPort = portalHttpPort;
        this.portalHttpsPort = portalHttpsPort;
        this.upgradeHttpsPort = upgradeHttpsPort;
        this.hostName = hostName;
        this.autoRefresh = autoRefresh;
        this.autoPortalIpEnable = autoPortalIpEnable;
        this.portalHttpsRedirect = portalHttpsRedirect;
        this.portalHost = portalHost;
    }

    @Generated
    public static class WebPortVOBuilder {
        @Generated
        private Integer manageHttpPort;
        @Generated
        private Integer manageHttpsPort;
        @Generated
        private Integer portalHttpPort;
        @Generated
        private Integer portalHttpsPort;
        @Generated
        private Integer upgradeHttpsPort;
        @Generated
        private String hostName;
        @Generated
        private Boolean autoRefresh;
        @Generated
        private Boolean autoPortalIpEnable;
        @Generated
        private Boolean portalHttpsRedirect;
        @Generated
        private String portalHost;

        @Generated
        WebPortVOBuilder() {
        }

        @Generated
        public WebPortVOBuilder manageHttpPort(Integer manageHttpPort) {
            this.manageHttpPort = manageHttpPort;
            return this;
        }

        @Generated
        public WebPortVOBuilder manageHttpsPort(Integer manageHttpsPort) {
            this.manageHttpsPort = manageHttpsPort;
            return this;
        }

        @Generated
        public WebPortVOBuilder portalHttpPort(Integer portalHttpPort) {
            this.portalHttpPort = portalHttpPort;
            return this;
        }

        @Generated
        public WebPortVOBuilder portalHttpsPort(Integer portalHttpsPort) {
            this.portalHttpsPort = portalHttpsPort;
            return this;
        }

        @Generated
        public WebPortVOBuilder upgradeHttpsPort(Integer upgradeHttpsPort) {
            this.upgradeHttpsPort = upgradeHttpsPort;
            return this;
        }

        @Generated
        public WebPortVOBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        @Generated
        public WebPortVOBuilder autoRefresh(Boolean autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Generated
        public WebPortVOBuilder autoPortalIpEnable(Boolean autoPortalIpEnable) {
            this.autoPortalIpEnable = autoPortalIpEnable;
            return this;
        }

        @Generated
        public WebPortVOBuilder portalHttpsRedirect(Boolean portalHttpsRedirect) {
            this.portalHttpsRedirect = portalHttpsRedirect;
            return this;
        }

        @Generated
        public WebPortVOBuilder portalHost(String portalHost) {
            this.portalHost = portalHost;
            return this;
        }

        @Generated
        public WebPortVO build() {
            return new WebPortVO(this.manageHttpPort, this.manageHttpsPort, this.portalHttpPort, this.portalHttpsPort, this.upgradeHttpsPort, this.hostName, this.autoRefresh, this.autoPortalIpEnable, this.portalHttpsRedirect, this.portalHost);
        }

        @Generated
        public String toString() {
            return "WebPortVO.WebPortVOBuilder(manageHttpPort=" + this.manageHttpPort + ", manageHttpsPort=" + this.manageHttpsPort + ", portalHttpPort=" + this.portalHttpPort + ", portalHttpsPort=" + this.portalHttpsPort + ", upgradeHttpsPort=" + this.upgradeHttpsPort + ", hostName=" + this.hostName + ", autoRefresh=" + this.autoRefresh + ", autoPortalIpEnable=" + this.autoPortalIpEnable + ", portalHttpsRedirect=" + this.portalHttpsRedirect + ", portalHost=" + this.portalHost + ")";
        }
    }
}

