/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.omadac.global;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class MailServerVO {
    @NotNull(message="smtpEnable should not be null")
    private @NotNull(message="smtpEnable should not be null") Boolean smtpEnable;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String smtpServer;
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) Integer port;
    private Boolean sslEnable;
    private Boolean authEnable;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String username;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String password;
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}") String senderAddress;
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}") String receiver;

    public OperationResponse validate() {
        if (this.getSmtpEnable().booleanValue()) {
            if (this.getPort() == null || this.getSslEnable() == null || this.getAuthEnable() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            if (this.getSmtpServer() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            if (this.getAuthEnable().booleanValue() && (this.getUsername() == null || this.getPassword() == null)) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public static MailServerVOBuilder builder() {
        return new MailServerVOBuilder();
    }

    @Generated
    public Boolean getSmtpEnable() {
        return this.smtpEnable;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    @Generated
    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSenderAddress() {
        return this.senderAddress;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public void setSmtpEnable(Boolean smtpEnable) {
        this.smtpEnable = smtpEnable;
    }

    @Generated
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    @Generated
    public void setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public String toString() {
        return "MailServerVO(smtpEnable=" + this.getSmtpEnable() + ", smtpServer=" + this.getSmtpServer() + ", port=" + this.getPort() + ", sslEnable=" + this.getSslEnable() + ", authEnable=" + this.getAuthEnable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", senderAddress=" + this.getSenderAddress() + ", receiver=" + this.getReceiver() + ")";
    }

    @Generated
    public MailServerVO() {
    }

    @Generated
    public MailServerVO(Boolean smtpEnable, String smtpServer, Integer port, Boolean sslEnable, Boolean authEnable, String username, String password, String senderAddress, String receiver) {
        this.smtpEnable = smtpEnable;
        this.smtpServer = smtpServer;
        this.port = port;
        this.sslEnable = sslEnable;
        this.authEnable = authEnable;
        this.username = username;
        this.password = password;
        this.senderAddress = senderAddress;
        this.receiver = receiver;
    }

    @Generated
    public static class MailServerVOBuilder {
        @Generated
        private Boolean smtpEnable;
        @Generated
        private String smtpServer;
        @Generated
        private Integer port;
        @Generated
        private Boolean sslEnable;
        @Generated
        private Boolean authEnable;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String senderAddress;
        @Generated
        private String receiver;

        @Generated
        MailServerVOBuilder() {
        }

        @Generated
        public MailServerVOBuilder smtpEnable(Boolean smtpEnable) {
            this.smtpEnable = smtpEnable;
            return this;
        }

        @Generated
        public MailServerVOBuilder smtpServer(String smtpServer) {
            this.smtpServer = smtpServer;
            return this;
        }

        @Generated
        public MailServerVOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public MailServerVOBuilder sslEnable(Boolean sslEnable) {
            this.sslEnable = sslEnable;
            return this;
        }

        @Generated
        public MailServerVOBuilder authEnable(Boolean authEnable) {
            this.authEnable = authEnable;
            return this;
        }

        @Generated
        public MailServerVOBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public MailServerVOBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public MailServerVOBuilder senderAddress(String senderAddress) {
            this.senderAddress = senderAddress;
            return this;
        }

        @Generated
        public MailServerVOBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        @Generated
        public MailServerVO build() {
            return new MailServerVO(this.smtpEnable, this.smtpServer, this.port, this.sslEnable, this.authEnable, this.username, this.password, this.senderAddress, this.receiver);
        }

        @Generated
        public String toString() {
            return "MailServerVO.MailServerVOBuilder(smtpEnable=" + this.smtpEnable + ", smtpServer=" + this.smtpServer + ", port=" + this.port + ", sslEnable=" + this.sslEnable + ", authEnable=" + this.authEnable + ", username=" + this.username + ", password=" + this.password + ", senderAddress=" + this.senderAddress + ", receiver=" + this.receiver + ")";
        }
    }
}

