/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan;

import com.tplink.smb.omada.common.util.J;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.PortBindingVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.SelectPortBindingBriefVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class ModifyVlanParamVO {
    @NotNull(message="lanNetwork should not be null")
    @Valid
    private @NotNull(message="lanNetwork should not be null") @Valid LanNetworkVO lanNetwork;
    @NotNull(message="deviceConfig should not be null")
    @Valid
    private @NotNull(message="deviceConfig should not be null") @Valid SelectPortBindingBriefVO deviceConfig;

    public ModifyVlanParamVO cloneParamVOForSync() {
        ModifyVlanParamVO modifyVlanParamVO = new ModifyVlanParamVO();
        modifyVlanParamVO.setLanNetwork(this.cloneNetworkForSync(this.lanNetwork));
        modifyVlanParamVO.setDeviceConfig(this.clonePortBindingForSync(this.deviceConfig));
        return modifyVlanParamVO;
    }

    public LanNetworkVO cloneNetworkForSync(LanNetworkVO lanNetworkVO) {
        if (Objects.isNull((Object)lanNetworkVO)) {
            return null;
        }
        LanNetworkVO cloneVO = new LanNetworkVO();
        J.a((Object)((Object)lanNetworkVO), (Object)((Object)cloneVO));
        return cloneVO;
    }

    public SelectPortBindingBriefVO clonePortBindingForSync(SelectPortBindingBriefVO selectPortBindingBriefVO) {
        if (Objects.isNull(selectPortBindingBriefVO)) {
            return null;
        }
        SelectPortBindingBriefVO cloneVO = new SelectPortBindingBriefVO();
        J.a((Object)selectPortBindingBriefVO, (Object)cloneVO);
        if (!CollectionUtils.isEmpty(selectPortBindingBriefVO.getDeviceList())) {
            ArrayList<PortBindingVO> deviceList = new ArrayList<PortBindingVO>();
            for (PortBindingVO portBindingVO : selectPortBindingBriefVO.getDeviceList()) {
                PortBindingVO newPortBindingVO = new PortBindingVO();
                newPortBindingVO.setMac(portBindingVO.getMac());
                newPortBindingVO.setType(portBindingVO.getType());
                newPortBindingVO.setPorts(CollectionUtils.isEmpty(portBindingVO.getPorts()) ? new ArrayList<String>() : new ArrayList<String>(portBindingVO.getPorts()));
                newPortBindingVO.setLags(CollectionUtils.isEmpty(portBindingVO.getLags()) ? new ArrayList<Integer>() : new ArrayList<Integer>(portBindingVO.getLags()));
                newPortBindingVO.setStackId(portBindingVO.getStackId());
                deviceList.add(newPortBindingVO);
            }
            cloneVO.setDeviceList(deviceList);
        }
        return cloneVO;
    }

    @Generated
    public LanNetworkVO getLanNetwork() {
        return this.lanNetwork;
    }

    @Generated
    public SelectPortBindingBriefVO getDeviceConfig() {
        return this.deviceConfig;
    }

    @Generated
    public void setLanNetwork(LanNetworkVO lanNetwork) {
        this.lanNetwork = lanNetwork;
    }

    @Generated
    public void setDeviceConfig(SelectPortBindingBriefVO deviceConfig) {
        this.deviceConfig = deviceConfig;
    }

    @Generated
    public String toString() {
        return "ModifyVlanParamVO(lanNetwork=" + this.getLanNetwork() + ", deviceConfig=" + this.getDeviceConfig() + ")";
    }

    @Generated
    public ModifyVlanParamVO() {
    }

    @Generated
    public ModifyVlanParamVO(LanNetworkVO lanNetwork, SelectPortBindingBriefVO deviceConfig) {
        this.lanNetwork = lanNetwork;
        this.deviceConfig = deviceConfig;
    }
}

