/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.routing.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.StaticRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="StaticRoutingInfoTemplate")
public class StaticRoutingInfoTemplateOpenApiVO {
    @Schema(name="id", description="ID")
    private String id;
    @NotNull(message="StaticRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="StaticRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="StaticRouting parameter [status] should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="StaticRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="StaticRouting parameter [destinations] should not be null")
    @Schema(name="destinations", description="IP address/SubNet, up to 16 entries are allowed for the destinations list.")
    private @NotNull(message="StaticRouting parameter [destinations] should not be null") List<String> destinations;
    @NotNull(message="StaticRouting parameter [routeType] should not be null")
    @Schema(name="routeType", description="RouteType should be a value as follows: 0: NextHop; 1: Interface")
    @Range(min=0L, max=1L)
    private @NotNull(message="StaticRouting parameter [routeType] should not be null") @Range(min=0L, max=1L) Integer routeType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.")
    @Schema(name="nextHopIp", description="Only for routeType:0 or routeType:1 and selected WAN is Static IP/Dynamic IP mode")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.") String nextHopIp;
    @Range(min=0L, max=3L)
    @Schema(name="interfaceType", description="Only for routeType:1, interfaceType should be a value as follows: 0: Internet(WAN); 1: Network(LAN).")
    private @Range(min=0L, max=3L) Integer interfaceType;
    @Schema(name="interfaceId", description="Interface ID, for example: if interfaceType is network, interfaceId should be LAN network ID. LAN Network can be created using 'Create LAN network template' interface, and LAN Network ID can be obtained from 'Get LAN network list template' interface.")
    private String interfaceId;
    @NotNull(message="StaticRouting parameter [metric] should not be null")
    @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.")
    @Schema(name="metric", description="Metric should be within the range of 0\u201315.")
    private @NotNull(message="StaticRouting parameter [metric] should not be null") @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.") Integer metric;

    public static StaticRoutingInfoTemplateOpenApiVO buildByWebVO(StaticRoutingVO vo) {
        return ((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)((StaticRoutingInfoTemplateOpenApiVOBuilder)StaticRoutingInfoTemplateOpenApiVO.builder().id(vo.getId())).name(vo.getName())).status(vo.getStatus())).destinations(vo.getDestinations())).routeType(vo.getRouteType())).nextHopIp(vo.getNextHopIp())).interfaceType(vo.getInterfaceType())).interfaceId(vo.getInterfaceId())).metric(vo.getMetric())).build();
    }

    @Generated
    protected StaticRoutingInfoTemplateOpenApiVO(StaticRoutingInfoTemplateOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.name = b2.name;
        this.status = b2.status;
        this.destinations = b2.destinations;
        this.routeType = b2.routeType;
        this.nextHopIp = b2.nextHopIp;
        this.interfaceType = b2.interfaceType;
        this.interfaceId = b2.interfaceId;
        this.metric = b2.metric;
    }

    @Generated
    public static StaticRoutingInfoTemplateOpenApiVOBuilder<?, ?> builder() {
        return new StaticRoutingInfoTemplateOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDestinations() {
        return this.destinations;
    }

    @Generated
    public Integer getRouteType() {
        return this.routeType;
    }

    @Generated
    public String getNextHopIp() {
        return this.nextHopIp;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public Integer getMetric() {
        return this.metric;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setRouteType(Integer routeType) {
        this.routeType = routeType;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setNextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO setMetric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @Generated
    public String toString() {
        return "StaticRoutingInfoTemplateOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", destinations=" + this.getDestinations() + ", routeType=" + this.getRouteType() + ", nextHopIp=" + this.getNextHopIp() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", metric=" + this.getMetric() + ")";
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO(String id, String name, Boolean status, List<String> destinations, Integer routeType, String nextHopIp, Integer interfaceType, String interfaceId, Integer metric) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.destinations = destinations;
        this.routeType = routeType;
        this.nextHopIp = nextHopIp;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.metric = metric;
    }

    @Generated
    public StaticRoutingInfoTemplateOpenApiVO() {
    }

    @Generated
    public static abstract class StaticRoutingInfoTemplateOpenApiVOBuilder<C extends StaticRoutingInfoTemplateOpenApiVO, B extends StaticRoutingInfoTemplateOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<String> destinations;
        @Generated
        private Integer routeType;
        @Generated
        private String nextHopIp;
        @Generated
        private Integer interfaceType;
        @Generated
        private String interfaceId;
        @Generated
        private Integer metric;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B destinations(List<String> destinations) {
            this.destinations = destinations;
            return this.self();
        }

        @Generated
        public B routeType(Integer routeType) {
            this.routeType = routeType;
            return this.self();
        }

        @Generated
        public B nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this.self();
        }

        @Generated
        public B interfaceType(Integer interfaceType) {
            this.interfaceType = interfaceType;
            return this.self();
        }

        @Generated
        public B interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this.self();
        }

        @Generated
        public B metric(Integer metric) {
            this.metric = metric;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "StaticRoutingInfoTemplateOpenApiVO.StaticRoutingInfoTemplateOpenApiVOBuilder(id=" + this.id + ", name=" + this.name + ", status=" + this.status + ", destinations=" + this.destinations + ", routeType=" + this.routeType + ", nextHopIp=" + this.nextHopIp + ", interfaceType=" + this.interfaceType + ", interfaceId=" + this.interfaceId + ", metric=" + this.metric + ")";
        }
    }

    @Generated
    private static final class StaticRoutingInfoTemplateOpenApiVOBuilderImpl
    extends StaticRoutingInfoTemplateOpenApiVOBuilder<StaticRoutingInfoTemplateOpenApiVO, StaticRoutingInfoTemplateOpenApiVOBuilderImpl> {
        @Generated
        private StaticRoutingInfoTemplateOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected StaticRoutingInfoTemplateOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StaticRoutingInfoTemplateOpenApiVO build() {
            return new StaticRoutingInfoTemplateOpenApiVO(this);
        }
    }
}

