/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.internal.gridquery;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.FilterMapCache;
import com.tplink.smb.omada.common.cache.h;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.gridquery.e;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;

public class QueryDataDTO {
    private int currentPage = 1;
    private int currentPageSize = 0;
    private LinkedHashMap<String, String> sorts;
    private String searchKey;
    @a(e=true)
    private Map<String, Object> filters;

    public static b transQueryDataWithSort(QueryDataDTO queryDataDTO, String sortMapKey) {
        return QueryDataDTO.transQueryDataWithSortAndFilter(queryDataDTO, sortMapKey, null);
    }

    public static b transQueryDataWithSortAndFilter(QueryDataDTO queryDataDTO, String sortMapKey, String filterMapKey) {
        b queryData = new b();
        queryData.a(queryDataDTO.getCurrentPage() == 0 ? 1 : queryDataDTO.getCurrentPage());
        queryData.b(queryDataDTO.getCurrentPageSize() == 0 ? 10 : queryDataDTO.getCurrentPageSize());
        queryData.c(queryDataDTO.getSearchKey());
        if (sortMapKey == null) {
            return queryData;
        }
        Map sortMap = h.a((String)sortMapKey);
        if (!CollectionUtils.isEmpty(queryDataDTO.getSorts())) {
            queryDataDTO.getSorts().forEach((key, direction) -> {
                if (sortMap.get(key) != null) {
                    queryData.a(new e((String)sortMap.get(key), direction));
                }
            });
        }
        if (filterMapKey == null) {
            return queryData;
        }
        Map filterMap = FilterMapCache.a((String)filterMapKey);
        if (!CollectionUtils.isEmpty(queryDataDTO.getFilters())) {
            queryDataDTO.getFilters().forEach((key, value) -> {
                FilterMapCache.FilterKeyItem item = (FilterMapCache.FilterKeyItem)filterMap.get(key);
                if (item != null) {
                    switch (item.getType()) {
                        case NUMBER: {
                            Number number = NumberUtils.createNumber((String)value.toString());
                            queryData.a(item.getKey(), (Object)number);
                            break;
                        }
                        case BOOLEAN: {
                            queryData.a(item.getKey(), (Object)Boolean.valueOf(value.toString()));
                            break;
                        }
                        default: {
                            queryData.a(item.getKey(), (Object)value.toString());
                        }
                    }
                }
            });
        }
        return queryData;
    }

    public static b transQueryData(QueryDataDTO queryDataDTO) {
        return QueryDataDTO.transQueryDataWithSortAndFilter(queryDataDTO, null, null);
    }

    public boolean noNeedPagingQuery() {
        return this.currentPage == 0 && this.currentPageSize == 0;
    }

    @Generated
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public int getCurrentPageSize() {
        return this.currentPageSize;
    }

    @Generated
    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    @Generated
    public String getSearchKey() {
        return this.searchKey;
    }

    @Generated
    public Map<String, Object> getFilters() {
        return this.filters;
    }

    @Generated
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    @Generated
    public void setCurrentPageSize(int currentPageSize) {
        this.currentPageSize = currentPageSize;
    }

    @Generated
    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    @Generated
    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    @Generated
    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    @Generated
    public QueryDataDTO() {
    }
}

