/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.internal.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.RoleEnumDTO;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

@KeepClass
public class UserDescriptionDTO {
    @Deprecated
    private Integer roleType;
    private Integer userType;
    private String accountId;
    private String name;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String operateOmadacName;
    private String operateSiteName;
    private String roleTypeName;

    @JsonIgnore
    public Optional<String> getUsernameOrCloudAccount() {
        return this.isCloudUser() ? Optional.ofNullable(this.email) : Optional.ofNullable(this.name);
    }

    public boolean isCloudUser() {
        if (this.getUserType() != null) {
            return Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), this.getUserType());
        }
        if (this.getRoleType() != null && RoleEnumDTO.resolve((Integer)this.getRoleType()) != null) {
            return RoleEnumDTO.resolve((Integer)this.getRoleType()).isCloudUser();
        }
        return false;
    }

    public static UserDescriptionDTO buildNewDTO(UserDescriptionDTO dto) {
        return new UserDescriptionDTO(dto.getRoleType(), dto.getUserType(), dto.getAccountId(), dto.getName(), dto.getEmail(), dto.getOperateOmadacName(), dto.getOperateSiteName(), dto.getRoleTypeName());
    }

    @Generated
    public static UserDescriptionDTOBuilder builder() {
        return new UserDescriptionDTOBuilder();
    }

    @Deprecated
    @Generated
    public Integer getRoleType() {
        return this.roleType;
    }

    @Generated
    public Integer getUserType() {
        return this.userType;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getOperateOmadacName() {
        return this.operateOmadacName;
    }

    @Generated
    public String getOperateSiteName() {
        return this.operateSiteName;
    }

    @Generated
    public String getRoleTypeName() {
        return this.roleTypeName;
    }

    @Deprecated
    @Generated
    public UserDescriptionDTO setRoleType(Integer roleType) {
        this.roleType = roleType;
        return this;
    }

    @Generated
    public UserDescriptionDTO setUserType(Integer userType) {
        this.userType = userType;
        return this;
    }

    @Generated
    public UserDescriptionDTO setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Generated
    public UserDescriptionDTO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public UserDescriptionDTO setEmail(String email) {
        this.email = email;
        return this;
    }

    @Generated
    public UserDescriptionDTO setOperateOmadacName(String operateOmadacName) {
        this.operateOmadacName = operateOmadacName;
        return this;
    }

    @Generated
    public UserDescriptionDTO setOperateSiteName(String operateSiteName) {
        this.operateSiteName = operateSiteName;
        return this;
    }

    @Generated
    public UserDescriptionDTO setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
        return this;
    }

    @Generated
    public String toString() {
        return "UserDescriptionDTO(roleType=" + this.getRoleType() + ", userType=" + this.getUserType() + ", accountId=" + this.getAccountId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", operateOmadacName=" + this.getOperateOmadacName() + ", operateSiteName=" + this.getOperateSiteName() + ", roleTypeName=" + this.getRoleTypeName() + ")";
    }

    @Generated
    public UserDescriptionDTO() {
    }

    @Generated
    public UserDescriptionDTO(Integer roleType, Integer userType, String accountId, String name, String email, String operateOmadacName, String operateSiteName, String roleTypeName) {
        this.roleType = roleType;
        this.userType = userType;
        this.accountId = accountId;
        this.name = name;
        this.email = email;
        this.operateOmadacName = operateOmadacName;
        this.operateSiteName = operateSiteName;
        this.roleTypeName = roleTypeName;
    }

    @Generated
    public static class UserDescriptionDTOBuilder {
        @Generated
        private Integer roleType;
        @Generated
        private Integer userType;
        @Generated
        private String accountId;
        @Generated
        private String name;
        @Generated
        private String email;
        @Generated
        private String operateOmadacName;
        @Generated
        private String operateSiteName;
        @Generated
        private String roleTypeName;

        @Generated
        UserDescriptionDTOBuilder() {
        }

        @Deprecated
        @Generated
        public UserDescriptionDTOBuilder roleType(Integer roleType) {
            this.roleType = roleType;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder userType(Integer userType) {
            this.userType = userType;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder operateOmadacName(String operateOmadacName) {
            this.operateOmadacName = operateOmadacName;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder operateSiteName(String operateSiteName) {
            this.operateSiteName = operateSiteName;
            return this;
        }

        @Generated
        public UserDescriptionDTOBuilder roleTypeName(String roleTypeName) {
            this.roleTypeName = roleTypeName;
            return this;
        }

        @Generated
        public UserDescriptionDTO build() {
            return new UserDescriptionDTO(this.roleType, this.userType, this.accountId, this.name, this.email, this.operateOmadacName, this.operateSiteName, this.roleTypeName);
        }

        @Generated
        public String toString() {
            return "UserDescriptionDTO.UserDescriptionDTOBuilder(roleType=" + this.roleType + ", userType=" + this.userType + ", accountId=" + this.accountId + ", name=" + this.name + ", email=" + this.email + ", operateOmadacName=" + this.operateOmadacName + ", operateSiteName=" + this.operateSiteName + ", roleTypeName=" + this.roleTypeName + ")";
        }
    }
}

