/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.app.site.vpn.wireguard;

import com.tplink.smb.omada.manager.configuration.api.web.site.wireguardvpn.dto.WireguardPeerVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WireguardPeerAppVO {
    private String id;
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="name should not more than 64 character")
    private @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="name should not more than 64 character") String name;
    @NotNull
    private Boolean status;
    @NotNull
    private String interfaceId;
    private String interfaceName;
    @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="public key must have 44 character of base64 and end with '=' ")
    private @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="public key must have 44 character of base64 and end with '=' ") String publicKey;
    private String endPoint;
    @Range(min=1L, max=65535L, message="port must between 1 and  65535")
    private @Range(min=1L, max=65535L, message="port must between 1 and  65535") Integer endPointPort;
    @NotNull
    private List<String> allowAddress;
    @Pattern(regexp="^$|^[0-9a-zA-Z+/]{43}=$", message="preshared key must have 44 character of base64 and end with '=' ")
    private @Pattern(regexp="^$|^[0-9a-zA-Z+/]{43}=$", message="preshared key must have 44 character of base64 and end with '=' ") String presharedKey;
    @Range(min=0L, max=65535L, message="keep alive must between 0 and 65535")
    private @Range(min=0L, max=65535L, message="keep alive must between 0 and 65535") Integer keepAlive;
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="comment should not more than 128 character")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="comment should not more than 128 character") String comment;

    public static WireguardPeerAppVO transToWireguardPeerAppVO(WireguardPeerVO vo) {
        WireguardPeerAppVO appVO = new WireguardPeerAppVO();
        if (Objects.isNull(vo)) {
            return appVO;
        }
        appVO.setId(vo.getId());
        appVO.setName(vo.getName());
        appVO.setStatus(vo.getStatus());
        appVO.setInterfaceId(vo.getInterfaceId());
        appVO.setInterfaceName(vo.getInterfaceName());
        appVO.setPublicKey(vo.getPublicKey());
        appVO.setEndPoint(vo.getEndPoint());
        appVO.setEndPointPort(vo.getEndPointPort());
        appVO.setAllowAddress(vo.getAllowAddress());
        appVO.setPresharedKey(vo.getPresharedKey());
        appVO.setKeepAlive(vo.getKeepAlive());
        appVO.setComment(vo.getComment());
        return appVO;
    }

    public static WireguardPeerVO transToWireguardPeerVO(WireguardPeerAppVO appVO) {
        WireguardPeerVO vo = new WireguardPeerVO();
        if (Objects.isNull(appVO)) {
            return vo;
        }
        vo.setId(appVO.getId());
        vo.setName(appVO.getName());
        vo.setStatus(appVO.getStatus());
        vo.setInterfaceId(appVO.getInterfaceId());
        vo.setInterfaceName(appVO.getInterfaceName());
        vo.setPublicKey(appVO.getPublicKey());
        vo.setAllowAddress(appVO.getAllowAddress());
        vo.setPresharedKey(appVO.getPresharedKey());
        vo.setKeepAlive(appVO.getKeepAlive());
        vo.setComment(appVO.getComment());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public Integer getEndPointPort() {
        return this.endPointPort;
    }

    @Generated
    public List<String> getAllowAddress() {
        return this.allowAddress;
    }

    @Generated
    public String getPresharedKey() {
        return this.presharedKey;
    }

    @Generated
    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    @Generated
    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setEndPointPort(Integer endPointPort) {
        this.endPointPort = endPointPort;
    }

    @Generated
    public void setAllowAddress(List<String> allowAddress) {
        this.allowAddress = allowAddress;
    }

    @Generated
    public void setPresharedKey(String presharedKey) {
        this.presharedKey = presharedKey;
    }

    @Generated
    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public WireguardPeerAppVO() {
    }

    @Generated
    public WireguardPeerAppVO(String id, String name, Boolean status, String interfaceId, String interfaceName, String publicKey, String endPoint, Integer endPointPort, List<String> allowAddress, String presharedKey, Integer keepAlive, String comment) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.interfaceId = interfaceId;
        this.interfaceName = interfaceName;
        this.publicKey = publicKey;
        this.endPoint = endPoint;
        this.endPointPort = endPointPort;
        this.allowAddress = allowAddress;
        this.presharedKey = presharedKey;
        this.keepAlive = keepAlive;
        this.comment = comment;
    }

    @Generated
    public String toString() {
        return "WireguardPeerAppVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", interfaceId=" + this.getInterfaceId() + ", interfaceName=" + this.getInterfaceName() + ", publicKey=" + this.getPublicKey() + ", endPoint=" + this.getEndPoint() + ", endPointPort=" + this.getEndPointPort() + ", allowAddress=" + this.getAllowAddress() + ", presharedKey=" + this.getPresharedKey() + ", keepAlive=" + this.getKeepAlive() + ", comment=" + this.getComment() + ")";
    }
}

