/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.app.site.vpn.wireguard;

import com.tplink.smb.omada.manager.configuration.api.web.site.wireguardvpn.dto.WireguardVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WireguardAppVO {
    private String id;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="name should not more than 64 character")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="name should not more than 64 character") String name;
    @NotNull
    private Boolean status;
    @NotNull
    @Range(min=576L, max=1440L, message="MTU must between 576 and 1440")
    private @NotNull @Range(min=576L, max=1440L, message="MTU must between 576 and 1440") Integer mtu;
    @NotNull
    @Range(min=1L, max=65535L, message="port must between 1 and 65535")
    private @NotNull @Range(min=1L, max=65535L, message="port must between 1 and 65535") Integer listenPort;
    @NotNull
    @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="private key must have 44 character of base64 and end with '='")
    private @NotNull @Pattern(regexp="^[0-9a-zA-Z+/]{43}=$", message="private key must have 44 character of base64 and end with '='") String privateKey;
    private String publicKey;
    @NotNull
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="invalid local ip address")
    private @NotNull @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="invalid local ip address") String localIp;

    public static WireguardAppVO transToWireguardAppVO(WireguardVO vo) {
        WireguardAppVO appVO = new WireguardAppVO();
        if (Objects.isNull(vo)) {
            return appVO;
        }
        appVO.setId(vo.getId());
        appVO.setName(vo.getName());
        appVO.setStatus(vo.getStatus());
        appVO.setMtu(vo.getMtu());
        appVO.setListenPort(vo.getListenPort());
        appVO.setPrivateKey(vo.getPrivateKey());
        appVO.setPublicKey(vo.getPublicKey());
        appVO.setLocalIp(vo.getLocalIp());
        return appVO;
    }

    public static WireguardVO transToWireguardVO(WireguardAppVO appVO) {
        WireguardVO vo = new WireguardVO();
        if (Objects.isNull(appVO)) {
            return vo;
        }
        vo.setId(appVO.getId());
        vo.setName(appVO.getName());
        vo.setStatus(appVO.getStatus());
        vo.setMtu(appVO.getMtu());
        vo.setListenPort(appVO.getListenPort());
        vo.setPrivateKey(appVO.getPrivateKey());
        vo.setPublicKey(appVO.getPublicKey());
        vo.setLocalIp(appVO.getLocalIp());
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public Integer getListenPort() {
        return this.listenPort;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getLocalIp() {
        return this.localIp;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setMtu(Integer mtu) {
        this.mtu = mtu;
    }

    @Generated
    public void setListenPort(Integer listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    @Generated
    public WireguardAppVO() {
    }

    @Generated
    public WireguardAppVO(String id, String name, Boolean status, Integer mtu, Integer listenPort, String privateKey, String publicKey, String localIp) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.mtu = mtu;
        this.listenPort = listenPort;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.localIp = localIp;
    }

    @Generated
    public String toString() {
        return "WireguardAppVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", mtu=" + this.getMtu() + ", listenPort=" + this.getListenPort() + ", privateKey=" + this.getPrivateKey() + ", publicKey=" + this.getPublicKey() + ", localIp=" + this.getLocalIp() + ")";
    }
}

