/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.app.site.vpn.vpnusers;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnAdvancedSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnCertificateVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnUserSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.vpn.dto.VpnVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class VpnAppVO {
    private String id;
    private String site;
    private Integer entryId;
    private String omadacId;
    @NotNull(message="VPN name should not be null")
    @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.")
    private @NotNull(message="VPN name should not be null") @Pattern(regexp="^[a-zA-Z0-9_]{1,63}$", message="VPN name should be 1~63 visible ASCII characters, and its format can only contain letters, _,and numbers.") String name;
    @NotNull(message="VPN purpose should not be null")
    @Range(min=0L, max=1L)
    private @NotNull(message="VPN purpose should not be null") @Range(min=0L, max=1L) Integer purpose;
    private Integer siteVpnType;
    private Boolean status;
    private Boolean accountAuth;
    private Integer openVpnTunnelMode;
    private Integer openVpnMode;
    private String remoteSite;
    private String remoteIp;
    private List<IPSubnetsVO> remoteSubnet;
    private Integer networkType;
    private List<String> networkList;
    private List<IPSubnetsVO> customNetwork;
    private String preSharedKey;
    private List<String> wans;
    private VpnAdvancedSettingVO vpnAdvancedSetting;
    private Integer clientVpnType1;
    private Integer clientVpnType2;
    private Integer encryption;
    private Integer ipPoolType;
    private String ipPoolStart;
    private String ipPoolEnd;
    private IPSubnetsVO ipPool;
    private String dns1;
    private String dns2;
    private Integer serviceType;
    @Range(min=1L, max=65535L, message="servicePort should range between 1 and 65535")
    private @Range(min=1L, max=65535L, message="servicePort should range between 1 and 65535") Integer servicePort;
    private Integer workingMode;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String clientUserName;
    @PII(strategy=PIIMaskStrategy.MASK)
    private String clientPassword;
    private Integer clientSaLifetime;
    private VpnCertificateVO vpnConfiguration;
    @Deprecated
    private List<VpnUserSettingVO> vpnUsers;
    private Integer authType;
    private String ldapProfile;

    public static VpnAppVO transToVpnAppVO(VpnVO vo) {
        VpnAppVO appVO = new VpnAppVO();
        if (Objects.isNull(vo)) {
            return appVO;
        }
        appVO.setId(vo.getId());
        appVO.setSite(vo.getSite());
        appVO.setEntryId(vo.getEntryId());
        appVO.setOmadacId(vo.getOmadacId());
        appVO.setName(vo.getName());
        appVO.setPurpose(vo.getPurpose());
        appVO.setSiteVpnType(vo.getSiteVpnType());
        appVO.setStatus(vo.getStatus());
        appVO.setAccountAuth(vo.getAccountAuth());
        appVO.setOpenVpnTunnelMode(vo.getOpenVpnTunnelMode());
        appVO.setOpenVpnMode(vo.getOpenVpnMode());
        appVO.setRemoteSite(vo.getRemoteSite());
        appVO.setRemoteIp(vo.getRemoteIp());
        appVO.setRemoteSubnet(vo.getRemoteSubnet());
        appVO.setNetworkType(vo.getNetworkType());
        appVO.setNetworkList(vo.getNetworkList());
        appVO.setCustomNetwork(vo.getCustomNetwork());
        appVO.setPreSharedKey(vo.getPreSharedKey());
        appVO.setWans(vo.getWans());
        appVO.setVpnAdvancedSetting(vo.getVpnAdvancedSetting());
        appVO.setClientVpnType1(vo.getClientVpnType1());
        appVO.setClientVpnType2(vo.getClientVpnType2());
        appVO.setEncryption(vo.getEncryption());
        appVO.setIpPoolType(vo.getIpPoolType());
        appVO.setIpPoolStart(vo.getIpPoolStart());
        appVO.setIpPoolEnd(vo.getIpPoolEnd());
        appVO.setIpPool(vo.getIpPool());
        appVO.setDns1(vo.getDns1());
        appVO.setDns2(vo.getDns2());
        appVO.setServiceType(vo.getServiceType());
        appVO.setServicePort(vo.getServicePort());
        appVO.setWorkingMode(vo.getWorkingMode());
        appVO.setClientUserName(vo.getClientUserName());
        appVO.setClientPassword(vo.getClientPassword());
        appVO.setClientSaLifetime(vo.getClientSaLifetime());
        appVO.setVpnConfiguration(vo.getVpnConfiguration());
        appVO.setVpnUsers(vo.getVpnUsers());
        appVO.setAuthType(vo.getAuthType());
        appVO.setLdapProfile(vo.getLdapProfile());
        return appVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public Integer getEntryId() {
        return this.entryId;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPurpose() {
        return this.purpose;
    }

    @Generated
    public Integer getSiteVpnType() {
        return this.siteVpnType;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getAccountAuth() {
        return this.accountAuth;
    }

    @Generated
    public Integer getOpenVpnTunnelMode() {
        return this.openVpnTunnelMode;
    }

    @Generated
    public Integer getOpenVpnMode() {
        return this.openVpnMode;
    }

    @Generated
    public String getRemoteSite() {
        return this.remoteSite;
    }

    @Generated
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Generated
    public List<IPSubnetsVO> getRemoteSubnet() {
        return this.remoteSubnet;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public List<IPSubnetsVO> getCustomNetwork() {
        return this.customNetwork;
    }

    @Generated
    public String getPreSharedKey() {
        return this.preSharedKey;
    }

    @Generated
    public List<String> getWans() {
        return this.wans;
    }

    @Generated
    public VpnAdvancedSettingVO getVpnAdvancedSetting() {
        return this.vpnAdvancedSetting;
    }

    @Generated
    public Integer getClientVpnType1() {
        return this.clientVpnType1;
    }

    @Generated
    public Integer getClientVpnType2() {
        return this.clientVpnType2;
    }

    @Generated
    public Integer getEncryption() {
        return this.encryption;
    }

    @Generated
    public Integer getIpPoolType() {
        return this.ipPoolType;
    }

    @Generated
    public String getIpPoolStart() {
        return this.ipPoolStart;
    }

    @Generated
    public String getIpPoolEnd() {
        return this.ipPoolEnd;
    }

    @Generated
    public IPSubnetsVO getIpPool() {
        return this.ipPool;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public Integer getServiceType() {
        return this.serviceType;
    }

    @Generated
    public Integer getServicePort() {
        return this.servicePort;
    }

    @Generated
    public Integer getWorkingMode() {
        return this.workingMode;
    }

    @Generated
    public String getClientUserName() {
        return this.clientUserName;
    }

    @Generated
    public String getClientPassword() {
        return this.clientPassword;
    }

    @Generated
    public Integer getClientSaLifetime() {
        return this.clientSaLifetime;
    }

    @Generated
    public VpnCertificateVO getVpnConfiguration() {
        return this.vpnConfiguration;
    }

    @Deprecated
    @Generated
    public List<VpnUserSettingVO> getVpnUsers() {
        return this.vpnUsers;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public String getLdapProfile() {
        return this.ldapProfile;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setEntryId(Integer entryId) {
        this.entryId = entryId;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setSiteVpnType(Integer siteVpnType) {
        this.siteVpnType = siteVpnType;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setAccountAuth(Boolean accountAuth) {
        this.accountAuth = accountAuth;
    }

    @Generated
    public void setOpenVpnTunnelMode(Integer openVpnTunnelMode) {
        this.openVpnTunnelMode = openVpnTunnelMode;
    }

    @Generated
    public void setOpenVpnMode(Integer openVpnMode) {
        this.openVpnMode = openVpnMode;
    }

    @Generated
    public void setRemoteSite(String remoteSite) {
        this.remoteSite = remoteSite;
    }

    @Generated
    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    @Generated
    public void setRemoteSubnet(List<IPSubnetsVO> remoteSubnet) {
        this.remoteSubnet = remoteSubnet;
    }

    @Generated
    public void setNetworkType(Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setCustomNetwork(List<IPSubnetsVO> customNetwork) {
        this.customNetwork = customNetwork;
    }

    @Generated
    public void setPreSharedKey(String preSharedKey) {
        this.preSharedKey = preSharedKey;
    }

    @Generated
    public void setWans(List<String> wans) {
        this.wans = wans;
    }

    @Generated
    public void setVpnAdvancedSetting(VpnAdvancedSettingVO vpnAdvancedSetting) {
        this.vpnAdvancedSetting = vpnAdvancedSetting;
    }

    @Generated
    public void setClientVpnType1(Integer clientVpnType1) {
        this.clientVpnType1 = clientVpnType1;
    }

    @Generated
    public void setClientVpnType2(Integer clientVpnType2) {
        this.clientVpnType2 = clientVpnType2;
    }

    @Generated
    public void setEncryption(Integer encryption) {
        this.encryption = encryption;
    }

    @Generated
    public void setIpPoolType(Integer ipPoolType) {
        this.ipPoolType = ipPoolType;
    }

    @Generated
    public void setIpPoolStart(String ipPoolStart) {
        this.ipPoolStart = ipPoolStart;
    }

    @Generated
    public void setIpPoolEnd(String ipPoolEnd) {
        this.ipPoolEnd = ipPoolEnd;
    }

    @Generated
    public void setIpPool(IPSubnetsVO ipPool) {
        this.ipPool = ipPool;
    }

    @Generated
    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    @Generated
    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Generated
    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setWorkingMode(Integer workingMode) {
        this.workingMode = workingMode;
    }

    @Generated
    public void setClientUserName(String clientUserName) {
        this.clientUserName = clientUserName;
    }

    @Generated
    public void setClientPassword(String clientPassword) {
        this.clientPassword = clientPassword;
    }

    @Generated
    public void setClientSaLifetime(Integer clientSaLifetime) {
        this.clientSaLifetime = clientSaLifetime;
    }

    @Generated
    public void setVpnConfiguration(VpnCertificateVO vpnConfiguration) {
        this.vpnConfiguration = vpnConfiguration;
    }

    @Deprecated
    @Generated
    public void setVpnUsers(List<VpnUserSettingVO> vpnUsers) {
        this.vpnUsers = vpnUsers;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setLdapProfile(String ldapProfile) {
        this.ldapProfile = ldapProfile;
    }

    @Generated
    public VpnAppVO() {
    }

    @Generated
    public VpnAppVO(String id, String site, Integer entryId, String omadacId, String name, Integer purpose, Integer siteVpnType, Boolean status, Boolean accountAuth, Integer openVpnTunnelMode, Integer openVpnMode, String remoteSite, String remoteIp, List<IPSubnetsVO> remoteSubnet, Integer networkType, List<String> networkList, List<IPSubnetsVO> customNetwork, String preSharedKey, List<String> wans, VpnAdvancedSettingVO vpnAdvancedSetting, Integer clientVpnType1, Integer clientVpnType2, Integer encryption, Integer ipPoolType, String ipPoolStart, String ipPoolEnd, IPSubnetsVO ipPool, String dns1, String dns2, Integer serviceType, Integer servicePort, Integer workingMode, String clientUserName, String clientPassword, Integer clientSaLifetime, VpnCertificateVO vpnConfiguration, List<VpnUserSettingVO> vpnUsers, Integer authType, String ldapProfile) {
        this.id = id;
        this.site = site;
        this.entryId = entryId;
        this.omadacId = omadacId;
        this.name = name;
        this.purpose = purpose;
        this.siteVpnType = siteVpnType;
        this.status = status;
        this.accountAuth = accountAuth;
        this.openVpnTunnelMode = openVpnTunnelMode;
        this.openVpnMode = openVpnMode;
        this.remoteSite = remoteSite;
        this.remoteIp = remoteIp;
        this.remoteSubnet = remoteSubnet;
        this.networkType = networkType;
        this.networkList = networkList;
        this.customNetwork = customNetwork;
        this.preSharedKey = preSharedKey;
        this.wans = wans;
        this.vpnAdvancedSetting = vpnAdvancedSetting;
        this.clientVpnType1 = clientVpnType1;
        this.clientVpnType2 = clientVpnType2;
        this.encryption = encryption;
        this.ipPoolType = ipPoolType;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.ipPool = ipPool;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.serviceType = serviceType;
        this.servicePort = servicePort;
        this.workingMode = workingMode;
        this.clientUserName = clientUserName;
        this.clientPassword = clientPassword;
        this.clientSaLifetime = clientSaLifetime;
        this.vpnConfiguration = vpnConfiguration;
        this.vpnUsers = vpnUsers;
        this.authType = authType;
        this.ldapProfile = ldapProfile;
    }

    @Generated
    public String toString() {
        return "VpnAppVO(id=" + this.getId() + ", site=" + this.getSite() + ", entryId=" + this.getEntryId() + ", omadacId=" + this.getOmadacId() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", siteVpnType=" + this.getSiteVpnType() + ", status=" + this.getStatus() + ", accountAuth=" + this.getAccountAuth() + ", openVpnTunnelMode=" + this.getOpenVpnTunnelMode() + ", openVpnMode=" + this.getOpenVpnMode() + ", remoteSite=" + this.getRemoteSite() + ", remoteIp=" + this.getRemoteIp() + ", remoteSubnet=" + this.getRemoteSubnet() + ", networkType=" + this.getNetworkType() + ", networkList=" + this.getNetworkList() + ", customNetwork=" + this.getCustomNetwork() + ", preSharedKey=" + this.getPreSharedKey() + ", wans=" + this.getWans() + ", vpnAdvancedSetting=" + this.getVpnAdvancedSetting() + ", clientVpnType1=" + this.getClientVpnType1() + ", clientVpnType2=" + this.getClientVpnType2() + ", encryption=" + this.getEncryption() + ", ipPoolType=" + this.getIpPoolType() + ", ipPoolStart=" + this.getIpPoolStart() + ", ipPoolEnd=" + this.getIpPoolEnd() + ", ipPool=" + this.getIpPool() + ", dns1=" + this.getDns1() + ", dns2=" + this.getDns2() + ", serviceType=" + this.getServiceType() + ", servicePort=" + this.getServicePort() + ", workingMode=" + this.getWorkingMode() + ", clientUserName=" + this.getClientUserName() + ", clientPassword=" + this.getClientPassword() + ", clientSaLifetime=" + this.getClientSaLifetime() + ", vpnConfiguration=" + this.getVpnConfiguration() + ", vpnUsers=" + this.getVpnUsers() + ", authType=" + this.getAuthType() + ", ldapProfile=" + this.getLdapProfile() + ")";
    }
}

