/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.app.site.dto.internet;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.OsgPortInfoVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.UsbLteSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanLoadBalanceVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanPortSettingVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class InternetAppVO {
    private String omadacId;
    @NotNull(message="siteId parameter [siteId] should not be null.")
    private @NotNull(message="siteId parameter [siteId] should not be null.") String siteId;
    private Boolean enable;
    private Boolean adoptedGateway;
    private OsgPortInfoVO osgPortInfo;
    private List<String> portUuids;
    @Valid
    private List<WanPortSettingVO> wanPortSettings;
    private List<UsbLteSettingVO> usbLteSettings;
    private List<LteWanSettingVO> lteWanSettings;
    private Boolean supportDiscreteWan;
    private Boolean supportAllWan;
    private Integer supportMaxWanNum;
    private Boolean supportIpv6NonAddress;
    private Boolean supportReduceUsbRfi;
    @Valid
    private WanLoadBalanceVO wanLoadBalance;

    public boolean validate() {
        if (!CollectionUtils.isEmpty(this.getWanPortSettings())) {
            for (WanPortSettingVO wanPortSettingVO : this.getWanPortSettings()) {
                if (WanPortSettingVO.validate(wanPortSettingVO)) continue;
                return false;
            }
        }
        if (!CollectionUtils.isEmpty(this.usbLteSettings)) {
            for (UsbLteSettingVO usbLteSettingVO : this.usbLteSettings) {
                if (usbLteSettingVO.checkPortDesc()) continue;
                return false;
            }
        }
        return !T.a((String)this.omadacId) && !T.a((String)this.siteId);
    }

    public static InternetAppVO buildFormWebVO(InternetVO internetVO) {
        InternetAppVO res = new InternetAppVO();
        res.setOmadacId(internetVO.getOmadacId());
        res.setSiteId(internetVO.getSiteId());
        res.setEnable(internetVO.getEnable());
        res.setOsgPortInfo(internetVO.getOsgPortInfo());
        res.setPortUuids(internetVO.getPortUuids());
        res.setSupportAllWan(internetVO.getSupportAllWan());
        res.setSupportMaxWanNum(internetVO.getSupportMaxWanNum());
        res.setAdoptedGateway(Optional.of(internetVO.getOsgPortInfo()).map(osgInfo -> osgInfo.getRealOsgModel() != null).orElse(false));
        res.setSupportDiscreteWan(internetVO.getSupportDiscreteWan());
        res.setSupportReduceUsbRfi(internetVO.getSupportReduceUsbRfi());
        res.setSupportIpv6NonAddress(internetVO.getSupportIpv6NonAddress());
        res.setWanPortSettings(internetVO.getWanPortSettings());
        res.setUsbLteSettings(internetVO.getUsbLteSettings());
        res.setLteWanSettings(internetVO.getLteWanSettings());
        res.setWanLoadBalance(internetVO.getWanLoadBalance());
        return res;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Boolean getAdoptedGateway() {
        return this.adoptedGateway;
    }

    @Generated
    public OsgPortInfoVO getOsgPortInfo() {
        return this.osgPortInfo;
    }

    @Generated
    public List<String> getPortUuids() {
        return this.portUuids;
    }

    @Generated
    public List<WanPortSettingVO> getWanPortSettings() {
        return this.wanPortSettings;
    }

    @Generated
    public List<UsbLteSettingVO> getUsbLteSettings() {
        return this.usbLteSettings;
    }

    @Generated
    public List<LteWanSettingVO> getLteWanSettings() {
        return this.lteWanSettings;
    }

    @Generated
    public Boolean getSupportDiscreteWan() {
        return this.supportDiscreteWan;
    }

    @Generated
    public Boolean getSupportAllWan() {
        return this.supportAllWan;
    }

    @Generated
    public Integer getSupportMaxWanNum() {
        return this.supportMaxWanNum;
    }

    @Generated
    public Boolean getSupportIpv6NonAddress() {
        return this.supportIpv6NonAddress;
    }

    @Generated
    public Boolean getSupportReduceUsbRfi() {
        return this.supportReduceUsbRfi;
    }

    @Generated
    public WanLoadBalanceVO getWanLoadBalance() {
        return this.wanLoadBalance;
    }

    @Generated
    public InternetAppVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public InternetAppVO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public InternetAppVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public InternetAppVO setAdoptedGateway(Boolean adoptedGateway) {
        this.adoptedGateway = adoptedGateway;
        return this;
    }

    @Generated
    public InternetAppVO setOsgPortInfo(OsgPortInfoVO osgPortInfo) {
        this.osgPortInfo = osgPortInfo;
        return this;
    }

    @Generated
    public InternetAppVO setPortUuids(List<String> portUuids) {
        this.portUuids = portUuids;
        return this;
    }

    @Generated
    public InternetAppVO setWanPortSettings(List<WanPortSettingVO> wanPortSettings) {
        this.wanPortSettings = wanPortSettings;
        return this;
    }

    @Generated
    public InternetAppVO setUsbLteSettings(List<UsbLteSettingVO> usbLteSettings) {
        this.usbLteSettings = usbLteSettings;
        return this;
    }

    @Generated
    public InternetAppVO setLteWanSettings(List<LteWanSettingVO> lteWanSettings) {
        this.lteWanSettings = lteWanSettings;
        return this;
    }

    @Generated
    public InternetAppVO setSupportDiscreteWan(Boolean supportDiscreteWan) {
        this.supportDiscreteWan = supportDiscreteWan;
        return this;
    }

    @Generated
    public InternetAppVO setSupportAllWan(Boolean supportAllWan) {
        this.supportAllWan = supportAllWan;
        return this;
    }

    @Generated
    public InternetAppVO setSupportMaxWanNum(Integer supportMaxWanNum) {
        this.supportMaxWanNum = supportMaxWanNum;
        return this;
    }

    @Generated
    public InternetAppVO setSupportIpv6NonAddress(Boolean supportIpv6NonAddress) {
        this.supportIpv6NonAddress = supportIpv6NonAddress;
        return this;
    }

    @Generated
    public InternetAppVO setSupportReduceUsbRfi(Boolean supportReduceUsbRfi) {
        this.supportReduceUsbRfi = supportReduceUsbRfi;
        return this;
    }

    @Generated
    public InternetAppVO setWanLoadBalance(WanLoadBalanceVO wanLoadBalance) {
        this.wanLoadBalance = wanLoadBalance;
        return this;
    }

    @Generated
    public String toString() {
        return "InternetAppVO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", enable=" + this.getEnable() + ", adoptedGateway=" + this.getAdoptedGateway() + ", osgPortInfo=" + this.getOsgPortInfo() + ", portUuids=" + this.getPortUuids() + ", wanPortSettings=" + this.getWanPortSettings() + ", usbLteSettings=" + this.getUsbLteSettings() + ", lteWanSettings=" + this.getLteWanSettings() + ", supportDiscreteWan=" + this.getSupportDiscreteWan() + ", supportAllWan=" + this.getSupportAllWan() + ", supportMaxWanNum=" + this.getSupportMaxWanNum() + ", supportIpv6NonAddress=" + this.getSupportIpv6NonAddress() + ", supportReduceUsbRfi=" + this.getSupportReduceUsbRfi() + ", wanLoadBalance=" + this.getWanLoadBalance() + ")";
    }
}

