/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.analyze.api.dto;

import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osg.OsgSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osw.OswSetKeyEnum;
import com.tplink.smb.omada.manager.analyze.api.dto.RunCheckQueryVO;
import com.tplink.smb.omada.manager.analyze.api.dto.SourceTypeEnum;
import com.tplink.smb.omada.manager.analyze.api.dto.a;
import com.tplink.smb.omada.manager.analyze.api.dto.c;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class TroubleshootingTaskDTO {
    private static final String AP_TYPE = "[Access Point] ";
    private static final String SWITCH_TYPE = "[Switch] ";
    private static final String GATEWAY_TYPE = "[Gateway] ";
    private static final String HARDWARE_CONTROLLER_TYPE = "[Hardware Controller] ";
    private Integer deviceType;
    private List<String> source;
    private String dest;
    private Integer destType;
    private String client;
    @Range(max=2000L, min=10L, message="packetSize \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e10\u6216\u5c0f\u4e8e\u7b49\u4e8e2000")
    private @Range(max=2000L, min=10L, message="packetSize \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e10\u6216\u5c0f\u4e8e\u7b49\u4e8e2000") Integer packetSize;
    @Range(max=100L, min=1L, message="count \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1\u6216\u5c0f\u4e8e\u7b49\u4e8e100")
    private @Range(max=100L, min=1L, message="count \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1\u6216\u5c0f\u4e8e\u7b49\u4e8e100") Integer count;
    private String nid;
    private String testType;
    private Long timeStamp;

    public static TroubleshootingTaskDTO toCmd(RunCheckQueryVO runCheckQueryVO, ApSetKeyEnum testType) {
        TroubleshootingTaskDTO cmd = new TroubleshootingTaskDTO();
        switch (testType) {
            case PING: {
                cmd.setTestType(c.a.b());
                break;
            }
            case TRACE_ROUTE: {
                cmd.setTestType(c.b.b());
                break;
            }
            case DNS_LOOK_UP: {
                cmd.setTestType(c.c.b());
                break;
            }
            case ARP_TABLE: {
                cmd.setTestType(c.d.b());
                break;
            }
        }
        cmd.setDeviceType(runCheckQueryVO.getDeviceType());
        cmd.setSource(runCheckQueryVO.getSource());
        cmd.setDest(runCheckQueryVO.getDest());
        cmd.setDestType(runCheckQueryVO.getDestType());
        cmd.setClient(runCheckQueryVO.getClient());
        cmd.setPacketSize(runCheckQueryVO.getPacketSize());
        cmd.setCount(runCheckQueryVO.getCount());
        cmd.setTimeStamp(System.currentTimeMillis());
        cmd.setNid(runCheckQueryVO.getNid());
        return cmd;
    }

    public static TroubleshootingTaskDTO toCmd(RunCheckQueryVO runCheckQueryVO, OsgSetKeyEnum testType) {
        TroubleshootingTaskDTO cmd = new TroubleshootingTaskDTO();
        switch (testType) {
            case PING: {
                cmd.setTestType(c.a.b());
                break;
            }
            case TRACE_ROUTE: {
                cmd.setTestType(c.b.b());
                break;
            }
            case DNS_LOOK_UP: {
                cmd.setTestType(c.c.b());
                break;
            }
            case ARP_TABLE: {
                cmd.setTestType(c.d.b());
                break;
            }
        }
        cmd.setDeviceType(runCheckQueryVO.getDeviceType());
        cmd.setSource(runCheckQueryVO.getSource());
        cmd.setDest(runCheckQueryVO.getDest());
        cmd.setDestType(runCheckQueryVO.getDestType());
        cmd.setClient(runCheckQueryVO.getClient());
        cmd.setPacketSize(runCheckQueryVO.getPacketSize());
        cmd.setCount(runCheckQueryVO.getCount());
        cmd.setTimeStamp(System.currentTimeMillis());
        cmd.setNid(runCheckQueryVO.getNid());
        return cmd;
    }

    public static TroubleshootingTaskDTO toCmd(RunCheckQueryVO runCheckQueryVO, OswSetKeyEnum testType) {
        TroubleshootingTaskDTO cmd = new TroubleshootingTaskDTO();
        switch (testType) {
            case PING: {
                cmd.setTestType(c.a.b());
                break;
            }
            case TRACE_ROUTE: {
                cmd.setTestType(c.b.b());
                break;
            }
            case DNS_LOOK_UP: {
                cmd.setTestType(c.c.b());
                break;
            }
            case ARP_TABLE: {
                cmd.setTestType(c.d.b());
                break;
            }
        }
        cmd.setDeviceType(runCheckQueryVO.getDeviceType());
        cmd.setSource(runCheckQueryVO.getSource());
        cmd.setDest(runCheckQueryVO.getDest());
        cmd.setDestType(runCheckQueryVO.getDestType());
        cmd.setClient(runCheckQueryVO.getClient());
        cmd.setPacketSize(runCheckQueryVO.getPacketSize());
        cmd.setCount(runCheckQueryVO.getCount());
        cmd.setTimeStamp(System.currentTimeMillis());
        cmd.setNid(runCheckQueryVO.getNid());
        return cmd;
    }

    public static String getEmailSourceType(Integer sourceType) {
        if (sourceType.equals(SourceTypeEnum.b.a())) {
            return SWITCH_TYPE;
        }
        if (sourceType.equals(SourceTypeEnum.c.a())) {
            return GATEWAY_TYPE;
        }
        if (sourceType.equals(SourceTypeEnum.d.a())) {
            return HARDWARE_CONTROLLER_TYPE;
        }
        return AP_TYPE;
    }

    public static String getEmailDest(TroubleshootingTaskDTO troubleshootingTask) {
        Integer destType = troubleshootingTask.getDestType();
        if (Objects.equals(destType, a.b.a())) {
            return troubleshootingTask.getClient();
        }
        return troubleshootingTask.getDest();
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public List<String> getSource() {
        return this.source;
    }

    @Generated
    public String getDest() {
        return this.dest;
    }

    @Generated
    public Integer getDestType() {
        return this.destType;
    }

    @Generated
    public String getClient() {
        return this.client;
    }

    @Generated
    public Integer getPacketSize() {
        return this.packetSize;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public String getNid() {
        return this.nid;
    }

    @Generated
    public String getTestType() {
        return this.testType;
    }

    @Generated
    public Long getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setSource(List<String> source) {
        this.source = source;
    }

    @Generated
    public void setDest(String dest) {
        this.dest = dest;
    }

    @Generated
    public void setDestType(Integer destType) {
        this.destType = destType;
    }

    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Generated
    public void setPacketSize(Integer packetSize) {
        this.packetSize = packetSize;
    }

    @Generated
    public void setCount(Integer count) {
        this.count = count;
    }

    @Generated
    public void setNid(String nid) {
        this.nid = nid;
    }

    @Generated
    public void setTestType(String testType) {
        this.testType = testType;
    }

    @Generated
    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof TroubleshootingTaskDTO)) {
            return false;
        }
        TroubleshootingTaskDTO other = (TroubleshootingTaskDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$deviceType = this.getDeviceType();
        Integer other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !((Object)this$deviceType).equals(other$deviceType)) {
            return false;
        }
        Integer this$destType = this.getDestType();
        Integer other$destType = other.getDestType();
        if (this$destType == null ? other$destType != null : !((Object)this$destType).equals(other$destType)) {
            return false;
        }
        Integer this$packetSize = this.getPacketSize();
        Integer other$packetSize = other.getPacketSize();
        if (this$packetSize == null ? other$packetSize != null : !((Object)this$packetSize).equals(other$packetSize)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Long this$timeStamp = this.getTimeStamp();
        Long other$timeStamp = other.getTimeStamp();
        if (this$timeStamp == null ? other$timeStamp != null : !((Object)this$timeStamp).equals(other$timeStamp)) {
            return false;
        }
        List<String> this$source = this.getSource();
        List<String> other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$dest = this.getDest();
        String other$dest = other.getDest();
        if (this$dest == null ? other$dest != null : !this$dest.equals(other$dest)) {
            return false;
        }
        String this$client = this.getClient();
        String other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$nid = this.getNid();
        String other$nid = other.getNid();
        if (this$nid == null ? other$nid != null : !this$nid.equals(other$nid)) {
            return false;
        }
        String this$testType = this.getTestType();
        String other$testType = other.getTestType();
        return !(this$testType == null ? other$testType != null : !this$testType.equals(other$testType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TroubleshootingTaskDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : ((Object)$deviceType).hashCode());
        Integer $destType = this.getDestType();
        result = result * 59 + ($destType == null ? 43 : ((Object)$destType).hashCode());
        Integer $packetSize = this.getPacketSize();
        result = result * 59 + ($packetSize == null ? 43 : ((Object)$packetSize).hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Long $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : ((Object)$timeStamp).hashCode());
        List<String> $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $dest = this.getDest();
        result = result * 59 + ($dest == null ? 43 : $dest.hashCode());
        String $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $nid = this.getNid();
        result = result * 59 + ($nid == null ? 43 : $nid.hashCode());
        String $testType = this.getTestType();
        result = result * 59 + ($testType == null ? 43 : $testType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TroubleshootingTaskDTO(deviceType=" + this.getDeviceType() + ", source=" + this.getSource() + ", dest=" + this.getDest() + ", destType=" + this.getDestType() + ", client=" + this.getClient() + ", packetSize=" + this.getPacketSize() + ", count=" + this.getCount() + ", nid=" + this.getNid() + ", testType=" + this.getTestType() + ", timeStamp=" + this.getTimeStamp() + ")";
    }

    @Generated
    public TroubleshootingTaskDTO() {
    }

    @Generated
    public TroubleshootingTaskDTO(Integer deviceType, List<String> source, String dest, Integer destType, String client, Integer packetSize, Integer count, String nid, String testType, Long timeStamp) {
        this.deviceType = deviceType;
        this.source = source;
        this.dest = dest;
        this.destType = destType;
        this.client = client;
        this.packetSize = packetSize;
        this.count = count;
        this.nid = nid;
        this.testType = testType;
        this.timeStamp = timeStamp;
    }
}

