/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.google.common.primitives.Primitives;
import com.tplink.smb.omada.dispatcher.annotation.ReqParam;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.CollectionCommonUtils;
import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import com.tplink.smb.omada.dispatcher.common.util.URLEncoderUtils;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.NumberUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class RequestParameterResolver
implements ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestParameterResolver.class);
    private static final Set<Class<?>> BASIC_CLASSES = new HashSet();

    @Override
    public boolean supported(MethodParameter parameter, ParameterResolveContext context) {
        return parameter.hasParameterAnnotation(ReqParam.class);
    }

    @Override
    public ResolveResult resolveParameter(MethodParameter parameter, ParameterResolveContext context) {
        RequestEntity<String> request = context.getRequestEntity();
        ReqParam requestParamAnnotation = (ReqParam)parameter.getParameterAnnotation(ReqParam.class);
        Assert.notNull((Object)requestParamAnnotation, (String)"ReqParam is not supposed to be null.");
        Class clazz = parameter.getNestedParameterType();
        String name = requestParamAnnotation.value();
        if (StringUtils.isNull((String)name)) {
            log.warn("Request parameter");
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getUrl()).build();
        MultiValueMap queryParams = uriComponents.getQueryParams();
        try {
            if (Map.class.isAssignableFrom(clazz)) {
                Map paramMap = CollectionCommonUtils.convertRequestParamsToMap((Map)queryParams);
                Object resultMap = paramMap.get(name);
                return ResolveResult.successResult(resultMap);
            }
            if (List.class.isAssignableFrom(clazz)) {
                List resultList = (List)queryParams.get((Object)name);
                return ResolveResult.successResult(resultList);
            }
            if (BASIC_CLASSES.contains(clazz)) {
                return ResolveResult.successResult(this.convert(URLEncoderUtils.decode((String)((String)queryParams.getFirst((Object)name))), clazz));
            }
            log.warn("Not supported type {} with ReqParam annotation, path: {}.", (Object)clazz, (Object)request.getUrl().getPath());
            return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
        }
        catch (Exception e) {
            log.info("resolveParameter error: {}, path: {}.", new Object[]{e.getMessage(), request.getUrl().getPath(), e});
            return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
        }
    }

    private <T> T convert(String origin, Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Request parameter class is null.");
        }
        if (origin == null) {
            if (Primitives.allWrapperTypes().contains(clazz) || String.class == clazz) {
                return null;
            }
            throw new NullPointerException("Origin parameter is null, cannot convert to class: " + clazz);
        }
        try {
            Class wrappedClazz = Primitives.wrap(clazz);
            if (Number.class.isAssignableFrom(wrappedClazz)) {
                if (StringUtils.isNull((String)origin)) {
                    if (Primitives.allWrapperTypes().contains(wrappedClazz)) {
                        return null;
                    }
                    throw new NumberFormatException(origin + " cannot be converted to number.");
                }
                return (T)NumberUtils.parseNumber((String)origin, (Class)wrappedClazz);
            }
            if (String.class.isAssignableFrom(wrappedClazz)) {
                return (T)origin;
            }
            if (Boolean.class.isAssignableFrom(wrappedClazz)) {
                return (T)Boolean.valueOf(origin);
            }
            if (Character.class.isAssignableFrom(wrappedClazz)) {
                if (origin.length() == 1) {
                    return (T)Character.valueOf(origin.charAt(0));
                }
                throw new TypeIncompatibleException("String \"" + origin + "\" has more than one character.");
            }
        }
        catch (Exception e) {
            throw new TypeIncompatibleException("Parameter type " + clazz + " is not compatible with value \"" + origin + "\"", e);
        }
        throw new UnsupportedParameterClassException("Class: " + clazz + " unsupported in RequestParameterResolver.");
    }

    static {
        BASIC_CLASSES.addAll(Primitives.allPrimitiveTypes());
        BASIC_CLASSES.addAll(Primitives.allWrapperTypes());
        BASIC_CLASSES.add(String.class);
    }

    private static class TypeIncompatibleException
    extends RuntimeException {
        TypeIncompatibleException(String message) {
            super(message);
        }

        TypeIncompatibleException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class UnsupportedParameterClassException
    extends RuntimeException {
        UnsupportedParameterClassException(String message) {
            super(message);
        }
    }
}

