/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.tplink.smb.omada.dispatcher.annotation.ReqBody;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;

public class RequestBodyResolver
implements ParameterResolver {
    public static final Logger log = LoggerFactory.getLogger(RequestBodyResolver.class);
    private static final Set<Class<?>> SUPPORTED_CLASSES = Sets.newHashSet((Object[])new Class[]{String.class, JSONObject.class, JSONArray.class, Map.class, List.class});
    private ObjectMapper objectMapper;

    public RequestBodyResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean supported(MethodParameter parameter, ParameterResolveContext context) {
        return SUPPORTED_CLASSES.contains(parameter.getNestedParameterType()) && parameter.hasParameterAnnotation(ReqBody.class);
    }

    @Override
    public ResolveResult resolveParameter(MethodParameter parameter, ParameterResolveContext context) {
        ReqBody annotation = (ReqBody)parameter.getParameterAnnotation(ReqBody.class);
        Assert.notNull((Object)annotation, (String)"ReqParameter is null.");
        RequestEntity<String> request = context.getRequestEntity();
        String body = (String)request.getBody();
        if (body == null) {
            if (annotation.required()) {
                log.warn("Dispatcher request body is null, path: {}.", (Object)request.getUrl().getPath());
                return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
            }
            return ResolveResult.successResult(null);
        }
        Class clazz = parameter.getNestedParameterType();
        try {
            if (String.class.isAssignableFrom(clazz)) {
                return ResolveResult.successResult(body);
            }
            if (JSONObject.class.isAssignableFrom(clazz)) {
                return ResolveResult.successResult(new JSONObject(body));
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                return ResolveResult.successResult(new JSONArray(body));
            }
            if (Map.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(parameter.getNestedGenericParameterType());
                return ResolveResult.successResult(this.objectMapper.readValue(body, javaType));
            }
            log.warn("Parameter type [{}] unsupported, path: {}.", (Object)clazz.getName(), (Object)request.getUrl().getPath());
            return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
        }
        catch (Exception e) {
            log.info("resolveParameter error: {}, path: {}.", new Object[]{e.getMessage(), request.getUrl().getPath(), e});
            return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

