/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.smb.omada.dispatcher.annotation.ReqAttribute;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.JsonUtils;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

public class RequestAttributeResolver
implements ParameterResolver {
    public static final Logger log = LoggerFactory.getLogger(RequestAttributeResolver.class);
    private final ObjectMapper objectMapper;

    public RequestAttributeResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean supported(MethodParameter parameter, ParameterResolveContext context) {
        return parameter.hasParameterAnnotation(ReqAttribute.class);
    }

    @Override
    public ResolveResult resolveParameter(MethodParameter parameter, ParameterResolveContext context) {
        ReqAttribute annotation = (ReqAttribute)parameter.getParameterAnnotation(ReqAttribute.class);
        Assert.notNull((Object)annotation, (String)"ReqAttribute is null.");
        AttributeRequestEntity request = (AttributeRequestEntity)context.getRequestEntity();
        Object attributeValue = request.getAttributes().get(annotation.value());
        if (attributeValue == null) {
            if (annotation.required()) {
                log.warn("Dispatcher request attribute value is null, path: {}.", (Object)request.getUrl().getPath());
                return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
            }
            return ResolveResult.successResult(null);
        }
        try {
            if (String.class.isAssignableFrom(attributeValue.getClass()) && JsonUtils.checkJson((String)((String)attributeValue))) {
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(parameter.getNestedGenericParameterType());
                return ResolveResult.successResult(this.objectMapper.readValue((String)attributeValue, javaType));
            }
            return ResolveResult.successResult(attributeValue);
        }
        catch (Exception e) {
            log.info("request attribute resolver error: {}, attributeValue: {}, path: {}.", new Object[]{e.getMessage(), attributeValue, request.getUrl().getPath(), e});
            return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
        }
    }
}

